UNIT ResDlg;

INTERFACE

USES PmDialog,PmObject,PmTypes;

CONST
    {Basic styles}
    NO_STYLE=0;
    {WS_...}
    FS_ICON=$00000001;
    FS_ACCELTABLE=$00000002;
    FS_SHELLPOSITION=$00000004;
    FS_TASKLIST=$00000008;
    FS_NOBYTEALIGN=$00000010;
    FS_NOMOVEWITHOWNER=$00000020;
    FS_SYSMODAL=$00000040;
    FS_DLGBORDER=$00000080;
    FS_BORDER=$00000100;
    FS_WINDOWALIGN=0;
    FS_SCREENALIGN=$00000200;
    FS_MOUSEALIGN=$00000400;
    FS_SIZEBORDER=$00000800;
    FS_AUTOICON=$00001000;
    FS_DBE_APPSTAT=$00008000;
    FS_STANDARD=$0000000F;
    BS_BITMAP=$40;
    BS_ICON=$80;
    WS_NOTHING=0;
    WS_NORMAL=$80010000;    {WS_GROUP|WS_VISIBLE}
    CBS_SIMPLE=$0001;
    CBS_DROPDOWN=$0002;
    CBS_DROPDOWNLIST=$0004;
    ES_LEFT=$00000000;
    ES_CENTER=$00000001;
    ES_RIGHT=$00000002;
    ES_AUTOSCROLL=$00000004;
    ES_MARGIN=$00000008;
    ES_AUTOTAB=$00000010;
    ES_READONLY=$00000020;
    ES_COMMAND=$00000040;
    ES_UNREADABLE=$00000080;
    ES_AUTOSIZE=$00000200;
    MLS_WORDWRAP=$00000001;
    MLS_BORDER=$00000002;
    MLS_VSCROLL=$00000004;
    MLS_HSCROLL=$00000008;
    MLS_READONLY=$00000010;
    MLS_IGNORETAB=$00000020;
    MLS_DISABLEUNDO=$00000040;

    {Flags}
    NO_FLAGS=0;
    {FCF...}
    SPBS_ALLCHARACTERS=$00000000;
    SPBS_NUMERICONLY=$00000001;
    SPBS_READONLY=$00000002;
    SPBS_MASTER=$00000010;
    SPBS_SERVANT=$00000000;
    SPBS_JUSTDEFAULT=$00000000;
    SPBS_JUSTLEFT=$00000008;
    SPBS_JUSTRIGHT=$00000004;
    SPBS_JUSTCENTER=$0000000C;
    SPBS_NOBORDER=$00000020;
    SPBS_FASTSPIN=$00000100;
    SPBS_PADWITHZEROS=$00000080;
    SLS_HORIZONTAL=$00000000;
    SLS_VERTICAL=$00000001;
    SLS_CENTER=$00000000;
    SLS_BOTTOM=$00000002;
    SLS_TOP=$00000004;
    SLS_LEFT=$00000002;
    SLS_RIGHT=$00000004;
    SLS_SNAPTOINCREMENT=$00000008;
    SLS_BUTTONSBOTTOM=$00000010;
    SLS_BUTTONSTOP=$00000020;
    SLS_BUTTONSLEFT=$00000010;
    SLS_BUTTONSRIGHT=$00000020;
    SLS_OWNERDRAW=$00000040;
    SLS_READONLY=$00000080;
    SLS_RIBBONSTRIP=$00000100;
    SLS_HOMEBOTTOM=$00000000;
    SLS_HOMETOP=$00000200;
    SLS_HOMELEFT=$00000000;
    SLS_HOMERIGHT=$00000200;
    SLS_PRIMARYSCALE1=$00000000;
    SLS_PRIMARYSCALE2=$00000400;
    VS_BITMAP=$0001;
    VS_ICON=$0002;
    VS_TEXT=$0004;
    VS_RGB=$0008;
    VS_COLORINDEX=$0010;
    VS_BORDER=$0020;
    VS_ITEMBORDER=$0040;
    VS_SCALEBITMAPS=$0080;
    VS_RIGHTTOLEFT=$0100;
    VS_OWNERDRAW=$0200;
    SS_TEXT=$0001;
    SS_GROUPBOX=$0002;
    SS_ICON=$0003;
    SS_BITMAP=$0004;
    SS_FGNDRECT=$0005;
    SS_HALFTONERECT=$0006;
    SS_BKGNDRECT=$0007;
    SS_FGNDFRAME=$0008;
    SS_HALFTONEFRAME=$0009;
    SS_BKGNDFRAME=$000a;
    SS_SYSICON=$000b;
    SS_AUTOSIZE=$0040;
    LS_MULTIPLESEL=$00000001;
    LS_OWNERDRAW=$00000002;
    LS_NOADJUSTPOS=$00000004;
    LS_HORZSCROLL=$00000008;
    LS_EXTENDEDSEL=$00000010;

    TYPE TButtonDialog=OBJECT(TDIALOG)
                      FUNCTION DialogHandleEvent(Dlg:HWND;msg:LONGWORD;
                                        Para1,Para2:LONGWORD;VAR Handled:BOOLEAN):
                                        LONGWORD:VIRTUAL;
                       CONSTRUCTOR Init(Parent,Owner:HWND;hmod:HModule;idDlg:LONGWORD;
                                        pCreateParams:Pointer);
                       DESTRUCTOR Done;
                END;

     TCheckBoxDialog=OBJECT(TDIALOG)
                       FUNCTION DialogHandleEvent(Dlg:HWND;msg:LONGWORD;
                                        Para1,Para2:LONGWORD;VAR Handled:BOOLEAN):
                                        LONGWORD:VIRTUAL;
                       CONSTRUCTOR Init(Parent,Owner:HWND;hmod:HModule;idDlg:LONGWORD;
                                        pCreateParams:Pointer);
                       DESTRUCTOR Done;
                END;

    TRadioBoxDialog=OBJECT(TDIALOG)
                       FUNCTION DialogHandleEvent(Dlg:HWND;msg:LONGWORD;
                                        Para1,Para2:LONGWORD;VAR Handled:BOOLEAN):
                                        LONGWORD:VIRTUAL;
                       CONSTRUCTOR Init(Parent,Owner:HWND;hmod:HModule;idDlg:LONGWORD;
                                        pCreateParams:Pointer);
                       DESTRUCTOR Done;
                END;

    TGroupBoxDialog=OBJECT(TDIALOG)
                       FUNCTION DialogHandleEvent(Dlg:HWND;msg:LONGWORD;
                                        Para1,Para2:LONGWORD;VAR Handled:BOOLEAN):
                                        LONGWORD:VIRTUAL;
                       CONSTRUCTOR Init(Parent,Owner:HWND;hmod:HModule;idDlg:LONGWORD;
                                        pCreateParams:Pointer);
                       DESTRUCTOR Done;
                END;

    TDialogDialog=OBJECT(TDIALOG)
                       FUNCTION DialogHandleEvent(Dlg:HWND;msg:LONGWORD;
                                        Para1,Para2:LONGWORD;VAR Handled:BOOLEAN):
                                        LONGWORD:VIRTUAL;
                       CONSTRUCTOR Init(Parent,Owner:HWND;hmod:HModule;idDlg:LONGWORD;
                                        pCreateParams:Pointer);
                       DESTRUCTOR Done;
                END;

    TOptionsDialog=OBJECT(TDIALOG)
                       FUNCTION DialogHandleEvent(Dlg:HWND;msg:LONGWORD;
                                        Para1,Para2:LONGWORD;VAR Handled:BOOLEAN):
                                        LONGWORD:VIRTUAL;
                       CONSTRUCTOR Init(Parent,Owner:HWND;hmod:HModule;idDlg:LONGWORD;
                                        pCreateParams:Pointer);
                       DESTRUCTOR Done;
                END;

    TTextDialog=OBJECT(TDIALOG)
                       FUNCTION DialogHandleEvent(Dlg:HWND;msg:LONGWORD;
                                        Para1,Para2:LONGWORD;VAR Handled:BOOLEAN):
                                        LONGWORD:VIRTUAL;
                       CONSTRUCTOR Init(Parent,Owner:HWND;hmod:HModule;idDlg:LONGWORD;
                                        pCreateParams:Pointer);
                       DESTRUCTOR Done;
                END;

    TEntryDialog=OBJECT(TDIALOG)
                       FUNCTION DialogHandleEvent(Dlg:HWND;msg:LONGWORD;
                                        Para1,Para2:LONGWORD;VAR Handled:BOOLEAN):
                                        LONGWORD:VIRTUAL;
                       CONSTRUCTOR Init(Parent,Owner:HWND;hmod:HModule;idDlg:LONGWORD;
                                        pCreateParams:Pointer);
                       DESTRUCTOR Done;
                END;

    TListBoxDialog=OBJECT(TDIALOG)
                       FUNCTION DialogHandleEvent(Dlg:HWND;msg:LONGWORD;
                                        Para1,Para2:LONGWORD;VAR Handled:BOOLEAN):
                                        LONGWORD:VIRTUAL;
                       CONSTRUCTOR Init(Parent,Owner:HWND;hmod:HModule;idDlg:LONGWORD;
                                        pCreateParams:Pointer);
                       DESTRUCTOR Done;
                END;

    TNewResDialog=OBJECT(TDIALOG)
                       FUNCTION DialogHandleEvent(Dlg:HWND;msg:LONGWORD;
                                        Para1,Para2:LONGWORD;VAR Handled:BOOLEAN):
                                        LONGWORD:VIRTUAL;
                       CONSTRUCTOR Init(Parent,Owner:HWND;hmod:HModule;idDlg:LONGWORD;
                                        pCreateParams:Pointer);
                       DESTRUCTOR Done;
                END;

VAR restext:STRING;
    reslong:LONGWORD;

CONST
     R_DIALOG       =1;
     R_MENU         =2;
     R_ACCEL        =3;
     R_ICON         =4;
     R_BITMAP       =5;



PROCEDURE ButtonDlg(VAR Text,idConstName:STRING;VAR Style,id:LONGWORD);
PROCEDURE CheckBoxDlg(VAR Text,idConstName:STRING;VAR Style,id:LONGWORD);
PROCEDURE RadioBoxDlg(VAR Text,idConstName:STRING;VAR Style,id:LONGWORD);
PROCEDURE GroupBoxDlg(VAR Text,idConstName:STRING;VAR Style,id:LONGWORD);
PROCEDURE DialogDlg(VAR Text,idConstName:STRING;VAR Style,id:LONGWORD);
PROCEDURE TextDlg(VAR Text,idConstName:STRING;VAR Style,id:LONGWORD);
PROCEDURE EntryDlg(VAR Text,idConstName:STRING;VAR Style,id:LONGWORD);
PROCEDURE ListBoxDlg(VAR Text,idConstName:STRING;VAR Style,id:LONGWORD);
PROCEDURE OptionsDlg(VAR Grid:BYTE;Options:LONGWORD);


PROCEDURE CalcBasicStyles(Flags:LONGWORD;VAR s:STRING);
PROCEDURE CalcEditStyles(Flags:LONGWORD;VAR s:STRING);
FUNCTION NewResDlg:BYTE;

IMPLEMENTATION

IMPORTS {Private}
       PROCEDURE WinDisMissDlg(result:LONGWORD;Dlg:HWND):    PMWIN index 729;
END;

PROCEDURE CalcBasicStyles(Flags:LONGWORD;VAR s:STRING);
VAR t:LONGWORD;
BEGIN
     ASM
        MOVD $t,$80000000
     END;
     IF Flags AND t=t THEN s:=s+'WS_VISIBLE';
     IF Flags AND WS_DISABLED=WS_DISABLED THEN
     BEGIN
          IF s<>'' THEN s:=s+'|';
          s:=s+'WS_DISABLED';
     END;
     IF Flags AND WS_TABSTOP=WS_TABSTOP THEN
     BEGIN
          IF s<>'' THEN s:=s+'|';
          s:=s+'WS_TABSTOP';
     END;
     IF Flags AND WS_GROUP=WS_GROUP THEN
     BEGIN
          IF s<>'' THEN s:=s+'|';
          s:=s+'WS_GROUP';
     END;
END;

PROCEDURE CalcEditStyles(Flags:LONGWORD;VAR s:STRING);
BEGIN
     IF Flags AND ES_MARGIN=ES_MARGIN THEN
     BEGIN
          IF s<>'' THEN s:=s+'|';
          s:=s+'ES_MARGIN';
     END;
     IF Flags AND ES_LEFT=ES_LEFT THEN
     BEGIN
          {ES_LEFT=0}
          {IF s<>'' THEN s:=s+'|';
          s:=s+'ES_LEFT';}
     END;
     IF Flags AND ES_CENTER=ES_CENTER THEN
     BEGIN
          IF s<>'' THEN s:=s+'|';
          s:=s+'ES_CENTER';
     END;
     IF Flags AND ES_RIGHT=ES_RIGHT THEN
     BEGIN
          IF s<>'' THEN s:=s+'|';
          s:=s+'ES_RIGHT';
     END;
     IF Flags AND ES_AUTOSCROLL=ES_AUTOSCROLL THEN
     BEGIN
          IF s<>'' THEN s:=s+'|';
          s:=s+'ES_AUTOSCROLL';
     END;
     IF Flags AND ES_AUTOTAB=ES_AUTOTAB THEN
     BEGIN
          IF s<>'' THEN s:=s+'|';
          s:=s+'ES_AUTOTAB';
     END;
     IF Flags AND ES_READONLY=ES_READONLY THEN
     BEGIN
          IF s<>'' THEN s:=s+'|';
          s:=s+'ES_READONLY';
     END;
     IF Flags AND ES_COMMAND=ES_COMMAND THEN
     BEGIN
          IF s<>'' THEN s:=s+'|';
          s:=s+'ES_COMMAND';
     END;
     IF Flags AND ES_UNREADABLE=ES_UNREADABLE THEN
     BEGIN
          IF s<>'' THEN s:=s+'|';
          s:=s+'ES_UNREADABLE';
     END;
     IF Flags AND ES_AUTOSIZE=ES_AUTOSIZE THEN
     BEGIN
          IF s<>'' THEN s:=s+'|';
          s:=s+'ES_AUTOSIZE';
     END;
END;

FUNCTION TButtonDialog.DialogHandleEvent(Dlg:HWND;msg:LONGWORD;
                       Para1,Para2:LONGWORD;VAR Handled:BOOLEAN):LONGWORD;
VAR r:LONGWORD;
    H:BOOLEAN;
    help:LONGWORD;
    Command,Control:WORD;
BEGIN
     r:=Inherited.DialogHandleEvent(Dlg,msg,para1,para2,Handled);
     H:=TRUE;
     CASE msg OF
         WM_INITDLG:
         BEGIN
              SetCheckBoxState(Dlg,103,1);
              SettextLimit(Dlg,100,128);  {Text}
              SettextLimit(Dlg,201,32);   {ConstName}
              DialogSetText(Dlg,100,restext);
         END;
         WM_COMMAND:
         BEGIN
              command:=WORD(para1);
              CASE command oF
                110:
                BEGIN
                     DialogGetText(Dlg,100,restext,250);

                     ResLong:=0;
                     IF GetCheckBoxState(Dlg,101)<>0 THEN
                       ResLong:=ResLong OR 1;
                END;
              END; {case}
              H:=FALSE; {Handled by Pm}
         END;
         ELSE H:=FALSE;
     END; {case}

     Handled:=H;
     DialogHandleEvent:=r;
END;

CONSTRUCTOR TButtonDialog.Init(Parent,Owner:HWND;hmod:HModule;idDlg:LONGWORD;
                 pCreateParams:Pointer);
BEGIN
     Inherited.Init(Parent,Owner,hmod,idDlg,pCreateParams);
END;

DESTRUCTOR TButtonDialog.Done;
BEGIN
END;


PROCEDURE ButtonDlg(VAR Text,idConstName:STRING;VAR Style,id:LONGWORD);
VAR Dlg:TButtonDialog;
    r:LONGWORD;
BEGIN
     restext:=text;
     Dlg.Init(1,AppWinFrameHandle,0,1000,NIL);
     Dlg.ExecDialog(r);
     IF r=110 THEN
     BEGIN
          Text:=restext;
          {Style:=resLong;}
     END;
     Dlg.Done;
END;

FUNCTION TCheckBoxDialog.DialogHandleEvent(Dlg:HWND;msg:LONGWORD;
                       Para1,Para2:LONGWORD;VAR Handled:BOOLEAN):LONGWORD;
VAR r:LONGWORD;
    H:BOOLEAN;
    help:LONGWORD;
    Command,Control:WORD;
BEGIN
     r:=Inherited.DialogHandleEvent(Dlg,msg,para1,para2,Handled);
     H:=TRUE;
     CASE msg OF
         WM_INITDLG:
         BEGIN
              SetCheckBoxState(Dlg,103,1);
              SettextLimit(Dlg,100,128);  {Text}
              SettextLimit(Dlg,201,32);   {ConstName}
              DialogSetText(Dlg,100,restext);
         END;
         WM_COMMAND:
         BEGIN
              command:=WORD(para1);
              CASE command oF
                110:
                BEGIN
                     DialogGetText(Dlg,100,restext,250);

                     ResLong:=0;
                     IF GetCheckBoxState(Dlg,101)<>0 THEN
                       ResLong:=ResLong OR 1;
                END;
              END; {case}
              H:=FALSE; {Handled by Pm}
         END;
         ELSE H:=FALSE;
     END; {case}

     Handled:=H;
     DialogHandleEvent:=r;
END;

CONSTRUCTOR TCheckBoxDialog.Init(Parent,Owner:HWND;hmod:HModule;idDlg:LONGWORD;
                 pCreateParams:Pointer);
BEGIN
     Inherited.Init(Parent,Owner,hmod,idDlg,pCreateParams);
END;

DESTRUCTOR TCheckBoxDialog.Done;
BEGIN
END;


PROCEDURE CheckBoxDlg(VAR Text,idConstName:STRING;VAR Style,id:LONGWORD);
VAR Dlg:TCheckBoxDialog;
    r:LONGWORD;
BEGIN
     restext:=text;
     Dlg.Init(1,AppWinFrameHandle,0,1001,NIL);
     Dlg.ExecDialog(r);
     IF r=110 THEN
     BEGIN
          Text:=restext;
          {Style:=resLong;}
     END;
     Dlg.Done;
END;

FUNCTION TRadioBoxDialog.DialogHandleEvent(Dlg:HWND;msg:LONGWORD;
                       Para1,Para2:LONGWORD;VAR Handled:BOOLEAN):LONGWORD;
VAR r:LONGWORD;
    H:BOOLEAN;
    help:LONGWORD;
    Command,Control:WORD;
BEGIN
     r:=Inherited.DialogHandleEvent(Dlg,msg,para1,para2,Handled);
     H:=TRUE;
     CASE msg OF
         WM_INITDLG:
         BEGIN
              SetCheckBoxState(Dlg,103,1);
              SettextLimit(Dlg,100,128);  {Text}
              SettextLimit(Dlg,201,32);   {ConstName}
              DialogSetText(Dlg,100,restext);
         END;
         WM_COMMAND:
         BEGIN
              command:=WORD(para1);
              CASE command oF
                110:
                BEGIN
                     DialogGetText(Dlg,100,restext,250);

                     ResLong:=0;
                     IF GetCheckBoxState(Dlg,101)<>0 THEN
                       ResLong:=ResLong OR 1;
                END;
              END; {case}
              H:=FALSE; {Handled by Pm}
         END;
         ELSE H:=FALSE;
     END; {case}

     Handled:=H;
     DialogHandleEvent:=r;
END;

CONSTRUCTOR TRadioBoxDialog.Init(Parent,Owner:HWND;hmod:HModule;idDlg:LONGWORD;
                 pCreateParams:Pointer);
BEGIN
     Inherited.Init(Parent,Owner,hmod,idDlg,pCreateParams);
END;

DESTRUCTOR TRadioBoxDialog.Done;
BEGIN
END;


PROCEDURE RadioBoxDlg(VAR Text,idConstName:STRING;VAR Style,id:LONGWORD);
VAR Dlg:TCheckBoxDialog;
    r:LONGWORD;
BEGIN
     restext:=text;
     Dlg.Init(1,AppWinFrameHandle,0,1002,NIL);
     Dlg.ExecDialog(r);
     IF r=110 THEN
     BEGIN
          Text:=restext;
          {Style:=resLong;}
     END;
     Dlg.Done;
END;

FUNCTION TGroupBoxDialog.DialogHandleEvent(Dlg:HWND;msg:LONGWORD;
                       Para1,Para2:LONGWORD;VAR Handled:BOOLEAN):LONGWORD;
VAR r:LONGWORD;
    H:BOOLEAN;
    help:LONGWORD;
    Command,Control:WORD;
BEGIN
     r:=Inherited.DialogHandleEvent(Dlg,msg,para1,para2,Handled);
     H:=TRUE;
     CASE msg OF
         WM_INITDLG:
         BEGIN
              SetCheckBoxState(Dlg,103,1);
              SettextLimit(Dlg,100,128);  {Text}
              SettextLimit(Dlg,201,32);   {ConstName}
              DialogSetText(Dlg,100,restext);
         END;
         WM_COMMAND:
         BEGIN
              command:=WORD(para1);
              CASE command oF
                110:
                BEGIN
                     DialogGetText(Dlg,100,restext,250);

                     ResLong:=0;
                     IF GetCheckBoxState(Dlg,101)<>0 THEN
                       ResLong:=ResLong OR 1;
                END;
              END; {case}
              H:=FALSE; {Handled by Pm}
         END;
         ELSE H:=FALSE;
     END; {case}

     Handled:=H;
     DialogHandleEvent:=r;
END;

CONSTRUCTOR TGroupBoxDialog.Init(Parent,Owner:HWND;hmod:HModule;idDlg:LONGWORD;
                 pCreateParams:Pointer);
BEGIN
     Inherited.Init(Parent,Owner,hmod,idDlg,pCreateParams);
END;

DESTRUCTOR TGroupBoxDialog.Done;
BEGIN
END;


PROCEDURE GroupBoxDlg(VAR Text,idConstName:STRING;VAR Style,id:LONGWORD);
VAR Dlg:TCheckBoxDialog;
    r:LONGWORD;
BEGIN
     restext:=text;
     Dlg.Init(1,AppWinFrameHandle,0,1003,NIL);
     Dlg.ExecDialog(r);
     IF r=110 THEN
     BEGIN
          Text:=restext;
          {Style:=resLong;}
     END;
     Dlg.Done;
END;

FUNCTION TDialogDialog.DialogHandleEvent(Dlg:HWND;msg:LONGWORD;
                       Para1,Para2:LONGWORD;VAR Handled:BOOLEAN):LONGWORD;
VAR r:LONGWORD;
    H:BOOLEAN;
    help:LONGWORD;
    Command,Control:WORD;
BEGIN
     r:=Inherited.DialogHandleEvent(Dlg,msg,para1,para2,Handled);
     H:=TRUE;
     CASE msg OF
         WM_INITDLG:
         BEGIN
              SetCheckBoxState(Dlg,103,1);
              SetRadioButtonState(Dlg,109,1);
              SettextLimit(Dlg,100,128);  {Text}
              SettextLimit(Dlg,201,32);   {ConstName}
              DialogSetText(Dlg,100,restext);
         END;
         WM_COMMAND:
         BEGIN
              command:=WORD(para1);
              CASE command oF
                110:
                BEGIN
                     DialogGetText(Dlg,100,restext,250);

                     ResLong:=0;
                     IF GetCheckBoxState(Dlg,101)<>0 THEN
                       ResLong:=ResLong OR 1;
                END;
              END; {case}
              H:=FALSE; {Handled by Pm}
         END;
         ELSE H:=FALSE;
     END; {case}

     Handled:=H;
     DialogHandleEvent:=r;
END;

CONSTRUCTOR TDialogDialog.Init(Parent,Owner:HWND;hmod:HModule;idDlg:LONGWORD;
                 pCreateParams:Pointer);
BEGIN
     Inherited.Init(Parent,Owner,hmod,idDlg,pCreateParams);
END;

DESTRUCTOR TDialogDialog.Done;
BEGIN
END;


PROCEDURE DialogDlg(VAR Text,idConstName:STRING;VAR Style,id:LONGWORD);
VAR Dlg:TDialogDialog;
    r:LONGWORD;
BEGIN
     restext:=text;
     Dlg.Init(1,AppWinFrameHandle,0,1004,NIL);
     Dlg.ExecDialog(r);
     IF r=110 THEN
     BEGIN
          Text:=restext;
          {Style:=resLong;}
     END;
     Dlg.Done;
END;

FUNCTION TOptionsDialog.DialogHandleEvent(Dlg:HWND;msg:LONGWORD;
                       Para1,Para2:LONGWORD;VAR Handled:BOOLEAN):LONGWORD;
VAR r:LONGWORD;
    H:BOOLEAN;
    help:LONGWORD;
    Command,Control:WORD;
BEGIN
     r:=Inherited.DialogHandleEvent(Dlg,msg,para1,para2,Handled);
     H:=TRUE;
     CASE msg OF
         WM_INITDLG:
         BEGIN
              SetCheckBoxState(Dlg,103,1);
              SetRadioButtonState(Dlg,109,1);
              SettextLimit(Dlg,100,128);  {Text}
              SettextLimit(Dlg,201,32);   {ConstName}
              DialogSetText(Dlg,100,restext);
         END;
         WM_COMMAND:
         BEGIN
              command:=WORD(para1);
              CASE command oF
                110:
                BEGIN
                     DialogGetText(Dlg,100,restext,250);

                     ResLong:=0;
                     IF GetCheckBoxState(Dlg,101)<>0 THEN
                       ResLong:=ResLong OR 1;
                END;
              END; {case}
              H:=FALSE; {Handled by Pm}
         END;
         ELSE H:=FALSE;
     END; {case}

     Handled:=H;
     DialogHandleEvent:=r;
END;

CONSTRUCTOR TOptionsDialog.Init(Parent,Owner:HWND;hmod:HModule;idDlg:LONGWORD;
                 pCreateParams:Pointer);
BEGIN
     Inherited.Init(Parent,Owner,hmod,idDlg,pCreateParams);
END;

DESTRUCTOR TOptionsDialog.Done;
BEGIN
END;


PROCEDURE OptionsDlg(VAR Grid:BYTE;VAR Options:LONGWORD);
VAR Dlg:TOptionsDialog;
    r:LONGWORD;
    b:LONGINT;
    c:INTEGER;
BEGIN
     restext:=tostr(grid);
     Dlg.Init(1,AppWinFrameHandle,0,1005,NIL);
     Dlg.ExecDialog(r);
     IF r=110 THEN
     BEGIN
          VAL(restext,b,c);
          IF c=0 THEN Grid:=b;
          Options:=resLong;
     END;
     Dlg.Done;
END;

FUNCTION TTextDialog.DialogHandleEvent(Dlg:HWND;msg:LONGWORD;
                       Para1,Para2:LONGWORD;VAR Handled:BOOLEAN):LONGWORD;
VAR r:LONGWORD;
    H:BOOLEAN;
    help:LONGWORD;
    Command,Control:WORD;
BEGIN

     r:=Inherited.DialogHandleEvent(Dlg,msg,para1,para2,Handled);
     H:=TRUE;
     CASE msg OF
         WM_INITDLG:
         BEGIN
              SetCheckBoxState(Dlg,120,1);
              SetRadioButtonState(Dlg,103,1);
              SettextLimit(Dlg,100,128);  {Text}
              SettextLimit(Dlg,201,32);   {ConstName}
              DialogSetText(Dlg,100,restext);
         END;
         WM_COMMAND:
         BEGIN
              command:=WORD(para1);
              CASE command oF
                110:
                BEGIN
                     DialogGetText(Dlg,100,restext,250);

                     ResLong:=0;
                     IF GetCheckBoxState(Dlg,101)<>0 THEN
                       ResLong:=ResLong OR 1;
                END;
              END; {case}
              H:=FALSE; {Handled by Pm}
         END;
         ELSE H:=FALSE;
     END; {case}

     Handled:=H;
     DialogHandleEvent:=r;
END;

CONSTRUCTOR TTextDialog.Init(Parent,Owner:HWND;hmod:HModule;idDlg:LONGWORD;
                 pCreateParams:Pointer);
BEGIN
     Inherited.Init(Parent,Owner,hmod,idDlg,pCreateParams);
END;

DESTRUCTOR TTextDialog.Done;
BEGIN
END;

PROCEDURE TextDlg(VAR Text,idConstName:STRING;VAR Style,id:LONGWORD);
VAR Dlg:TTextDialog;
    r:LONGWORD;
    b,c:BYTE;
BEGIN
     restext:=text;
     Dlg.Init(1,AppWinFrameHandle,0,1006,NIL);
     Dlg.ExecDialog(r);
     IF r=110 THEN
     BEGIN
          Text:=restext;
          {Style:=reslong;}
     END;
     Dlg.Done;
END;

FUNCTION TEntryDialog.DialogHandleEvent(Dlg:HWND;msg:LONGWORD;
                       Para1,Para2:LONGWORD;VAR Handled:BOOLEAN):LONGWORD;
VAR r:LONGWORD;
    H:BOOLEAN;
    help:LONGWORD;
    Command,Control:WORD;
BEGIN
     r:=Inherited.DialogHandleEvent(Dlg,msg,para1,para2,Handled);
     H:=TRUE;
     CASE msg OF
         WM_INITDLG:
         BEGIN
              SetCheckBoxState(Dlg,120,1);
              SetRadioButtonState(Dlg,103,1);
              SettextLimit(Dlg,100,128);  {Text}
              SettextLimit(Dlg,201,32);   {ConstName}
              DialogSetText(Dlg,100,restext);
         END;
         WM_COMMAND:
         BEGIN
              command:=WORD(para1);
              CASE command oF
                110:
                BEGIN
                     DialogGetText(Dlg,100,restext,250);

                     ResLong:=0;
                     IF GetCheckBoxState(Dlg,101)<>0 THEN
                       ResLong:=ResLong OR 1;
                END;
              END; {case}
              H:=FALSE; {Handled by Pm}
         END;
         ELSE H:=FALSE;
     END; {case}

     Handled:=H;
     DialogHandleEvent:=r;
END;

CONSTRUCTOR TEntryDialog.Init(Parent,Owner:HWND;hmod:HModule;idDlg:LONGWORD;
                 pCreateParams:Pointer);
BEGIN
     Inherited.Init(Parent,Owner,hmod,idDlg,pCreateParams);
END;

DESTRUCTOR TEntryDialog.Done;
BEGIN
END;

PROCEDURE EntryDlg(VAR Text,idConstName:STRING;VAR Style,id:LONGWORD);
VAR Dlg:TEntryDialog;
    r:LONGWORD;
    b,c:BYTE;
BEGIN
     restext:=text;
     Dlg.Init(1,AppWinFrameHandle,0,1007,NIL);
     Dlg.ExecDialog(r);
     IF r=110 THEN
     BEGIN
          Text:=restext;
          {Style:=reslong;}
     END;
     Dlg.Done;
END;

FUNCTION TListBoxDialog.DialogHandleEvent(Dlg:HWND;msg:LONGWORD;
                       Para1,Para2:LONGWORD;VAR Handled:BOOLEAN):LONGWORD;
VAR r:LONGWORD;
    H:BOOLEAN;
    help:LONGWORD;
    Command,Control:WORD;
BEGIN
     r:=Inherited.DialogHandleEvent(Dlg,msg,para1,para2,Handled);
     H:=TRUE;
     CASE msg OF
         WM_INITDLG:
         BEGIN
              SetCheckBoxState(Dlg,120,1);
              SetRadioButtonState(Dlg,103,1);
              SettextLimit(Dlg,100,128);  {Text}
              SettextLimit(Dlg,201,32);   {ConstName}
              DialogSetText(Dlg,100,restext);
         END;
         WM_COMMAND:
         BEGIN
              command:=WORD(para1);
              CASE command oF
                110:
                BEGIN
                     DialogGetText(Dlg,100,restext,250);

                     ResLong:=0;
                     IF GetCheckBoxState(Dlg,101)<>0 THEN
                       ResLong:=ResLong OR 1;
                END;
              END; {case}
              H:=FALSE; {Handled by Pm}
         END;
         ELSE H:=FALSE;
     END; {case}

     Handled:=H;
     DialogHandleEvent:=r;
END;

CONSTRUCTOR TListBoxDialog.Init(Parent,Owner:HWND;hmod:HModule;idDlg:LONGWORD;
                 pCreateParams:Pointer);
BEGIN
     Inherited.Init(Parent,Owner,hmod,idDlg,pCreateParams);
END;

DESTRUCTOR TListBoxDialog.Done;
BEGIN
END;

PROCEDURE ListBoxDlg(VAR Text,idConstName:STRING;VAR Style,id:LONGWORD);
VAR Dlg:TEntryDialog;
    r:LONGWORD;
    b,c:BYTE;
BEGIN
     restext:=text;
     Dlg.Init(1,AppWinFrameHandle,0,1008,NIL);
     Dlg.ExecDialog(r);
     IF r=110 THEN
     BEGIN
          Text:=restext;
          {Style:=reslong;}
     END;
     Dlg.Done;
END;

VAR AvailResList:PListBoxItems;

FUNCTION TNewResDialog.DialogHandleEvent(Dlg:HWND;msg:LONGWORD;
                       Para1,Para2:LONGWORD;VAR Handled:BOOLEAN):LONGWORD;
VAR r:LONGWORD;
    H:BOOLEAN;
    help:LONGWORD;
    Command,Control:WORD;
    pb:^Byte;
    s:STRING;
    res:TListBoxItems;
BEGIN
     r:=Inherited.DialogHandleEvent(Dlg,msg,para1,para2,Handled);
     H:=TRUE;
     CASE msg OF
         WM_INITDLG:
         BEGIN
              AvailResList:=NIL;

              s:='Dialog Template';
              getmem(pb,1);
              pb^:=R_DIALOG;
              NewListBoxItem(AvailResList,s,pb,1,FALSE);

              s:='Menu Template';
              getmem(pb,1);
              pb^:=R_MENU;
              NewListBoxItem(AvailResList,s,pb,1,FALSE);

              s:='Accelerator table';
              getmem(pb,1);
              pb^:=R_ACCEL;
              NewListBoxItem(AvailResList,s,pb,1,FALSE);

              s:='Icon';
              getmem(pb,1);
              pb^:=R_ICON;
              NewListBoxItem(AvailResList,s,pb,1,FALSE);

              s:='Bitmap';
              getmem(pb,1);
              pb^:=R_BITMAP;
              NewListBoxItem(AvailResList,s,pb,1,FALSE);

              FillListBox(Dlg,100,AvailResList);
         END;
         WM_CONTROL:
         BEGIN
              help:=LONGWORD(Para1);
              Control:=Hi(help);
              CASE Control OF
                LN_ENTER:
                BEGIN
                     ListBoxGetSelItem(Dlg,100,Res,AvailResList,TRUE);
                     IF res._index=65535 THEN ResLong:=0 {No item selected}
                     ELSE
                     BEGIN
                          pb:=res.data;
                          ResLong:=pb^;
                     END;
                     WinDismissDlg(110,Dlg);
                END;
              END; {Case}
              H:=FALSE;
         END;
         WM_COMMAND:
         BEGIN
              command:=WORD(para1);
              CASE command oF
                110:
                BEGIN
                     ListBoxGetSelItem(Dlg,100,res,AvailResList,TRUE);
                     IF res._index=65535 THEN ResLong:=0 {No item selected}
                     ELSE
                     BEGIN
                          pb:=res.data;
                          ResLong:=pb^;
                     END;
                END;
              END; {case}
              H:=FALSE; {Handled by Pm}
         END;
         ELSE H:=FALSE;
     END; {case}

     Handled:=H;
     DialogHandleEvent:=r;
END;

CONSTRUCTOR TNewResDialog.Init(Parent,Owner:HWND;hmod:HModule;idDlg:LONGWORD;
                 pCreateParams:Pointer);
BEGIN
     Inherited.Init(Parent,Owner,hmod,idDlg,pCreateParams);
END;

DESTRUCTOR TNewResDialog.Done;
BEGIN
END;

FUNCTION NewResDlg:BYTE;
VAR Dlg:TNewResDialog;
    r:LONGWORD;
    b,c:BYTE;
Label l;
BEGIN
l:
     Dlg.Init(1,AppWinFrameHandle,0,501,NIL);
     Dlg.ExecDialog(r);
     Dlg.Done;
     IF r=110 THEN
     BEGIN
          IF reslong=0 THEN
          BEGIN
               ErrorBox(MB_WARNING,'You must specify a resource !');
               goto l;
          END;
          NewResDlg:=reslong
     END;
     ELSE NewResDlg:=0;
END;


BEGIN
END. 























































