{$A+,B-,D+,E+,F-,G+,I+,L+,N-,O-,P-,Q-,R-,S+,T-,V-,X+,Y+}
{$M 16384,0,655360}
Program IntroBetaVersion;

{ This is the Beta Version Intro.  It will include the program name, my name
dates, and other relvant information }

Uses INPUT,
     VGA256,
     Crt;

Const IntroLines : Array[1..14] of String[40] =
 ('The Solar System: By Joseph Broms',
  'December 19, 1994',
  '',
  'This program is designed to visualize',
  'the nine planets revolving around the',
  'sun.  Use the arrow keys to move, F1',
  'and F2 to zoom planet sizes, Use I and',
  'D to zoom in and out of the entire map',
  'Press T to toggle labels.  The program',
  'shows the correct speed, size, and',
  'distance form sun.  Escape quits the',
  'program.',
  '','Press any key to continue');





var Error:      Integer;  { Error number for picture }
    I,J: word;
    Pal: RGB256;

begin
  StartGraphics;                { Open graphics mode 320x200x256 for 2 pages }
  SetUpVirtual;

  ResetScreenPalette(0);
  LoadPic ('STARS.PIC',0,0,VGA,Pal);
  FadeIn(Pal,15);
  Delay(1000);
  FadeOut(5);

  Cls (0,VGA);
  ResetPalette (Pal,0);
  For i := 1 to 101 do
  begin
    Pal[i,1] := ((i-1) div 2);
    Pal[i,2] := 0;
    Pal[i,3] := 0;
  end;
  For i := 102 to 202 do
  begin
    Pal[i,1] := 50 - ((i-102) div 2);
    Pal[i,2] := 0;
    Pal[i,3] := 0;
  end;
  Pal[255,1] := 63;
  Pal[255,2] := 63;
  Pal[255,3] := 63;

  ResetScreenPalette(0);
  SetColor (255,0,0,0);
  for i := 0 to 200 do Line (0,i,319,i,i+1,VGA);
  For i := 1 to 12 do
    WriteGraphString (Introlines[i],1,i*12+15,255,VGA);
  FadeIn(Pal,0);
  repeat
    CycleColors (Pal,1,202,FALSE);
    delay(10);
    SetAllRGB (Pal);
  until keypressed;
  FadeOut (0);
  StartText;
  ClearBuffer;
end.
