{$A+,B-,D+,E+,F-,G-,I+,L+,N-,O-,P-,Q-,R-,S+,T-,V-,X+,Y+}
{$M 16384,0,655360}
program Projections_3D;

uses VGA256,
     INPUT,
     crt,
     dos;

const MaxPlanes = 4000;

type PlaneType = Record
       Color:           BYTE;
       Dist:            LONGINT;
       Points: Array[1..4,1..3] of LONGINT;
     end;

     SpaceType = Array[1..MaxPlanes] of ^PLANETYPE;

     Globaltype = Record
       Hidden,
       Rotate,
       Clip,
       Color:        BOOLEAN;
       ScreenX,
       ScreenY,
       SizeOfSpace,
       EyeX,
       EyeY,
       EyeZ,
       AngleX,
       AngleY,
       AngleZ:     INTEGER;
     end;


Var
    Space,
    RealSpace:  SPACETYPE;
    Rotation:   ARRAY[1..3,1..3] of LONGINT;
    SINTABLE,
    COSTABLE:   ARRAY[0..360] of LONGINT;
    Global:     GLOBALTYPE;



function RealToFixed (Num: REAL): LONGINT;
begin
   RealToFixed := Round(Num * 256);
end;


function FixedtoReal (Num: LONGINT): REAL;
begin
  FixedtoReal := (Num / 256);
end;


Procedure MakeTrigTable;
VAR I: WORD;
begin
  for I := 0 to 360 do
  begin
    SinTable[I] := RealtoFixed ( Sin ( I * pi / 180 ) );
    CosTable[I] := RealtoFixed ( Cos ( I * pi / 180 ) );
  end;
end;

procedure AvgDist (i:word);
begin
  with Global do
  RealSpace[i]^.dist := round(((Sqrt(Sqr(realspace[i]^.points[1,1]-EyeX) +
                                 Sqr(realspace[i]^.points[1,2]-eyey) +
                                 Sqr(realspace[i]^.points[1,3]-eyez))) +
                          (Sqrt (Sqr(realspace[i]^.points[2,1]-eyex) +
                                 Sqr(realspace[i]^.points[2,2]-eyey) +
                                 Sqr(realspace[i]^.points[2,3]-eyez))) +
                          (Sqrt (Sqr(realspace[i]^.points[3,1]-eyex) +
                                 Sqr(realspace[i]^.points[3,2]-eyey) +
                                 Sqr(realspace[i]^.points[3,3]-eyez))) +
                          (Sqrt (Sqr(realspace[i]^.points[4,1]-eyex) +
                                 Sqr(realspace[i]^.points[4,2]-eyey) +
                                 Sqr(realspace[i]^.points[4,3]-eyez))))/4);
end;





PROCEDURE SetRotation (x, y, z: WORD);
BEGIN
  rotation[1,1]:= (CosTable[y] * CosTable[z]) div 256 ;
  rotation[1,2]:= (CosTable[y] * -SinTable[z]) div 256 ;
  rotation[1,3]:= -SinTable[y];
  rotation[2,1]:= (CosTable[x] * SinTable[z]) div 256 +
    ((SinTable[x] * SinTable[y]) div 256 * CosTable[z]) div 256;
  rotation[2,2]:= (CosTable[x] * CosTable[z]) div 256 +
    ((SinTable[x] * SinTable[y]) div 256 * -SinTable[z]) div 256;
  rotation[2,3]:= (SinTable[x] * CosTable[y]) div 256;
  rotation[3,1]:= (SinTable[z] * -SinTable[x]) div 256 +
    ((CosTable[x] * SinTable[y]) div 256 + CosTable[z]) div 256;
  rotation[3,2]:= (-SinTable[x] * CosTable[z]) div 256 +
    ((CosTable[x] * SinTable[y]) div 256 * -SinTable[z]) div 256;
  rotation[3,3]:= (CosTable[x] * CosTable[y]) div 256;
END;

procedure rotate (t: word);
var i,j,k: word;
begin
  for i := 1 to t do
    for j := 1 to 4 do
      for k := 1 to 3 do
        RealSpace[i]^.points[j,k] :=
          (rotation[k,1] * Space[i]^.points[j,1]) div 256 +
          (rotation[k,2] * Space[i]^.points[j,2]) div 256 +
          (rotation[k,3] * Space[i]^.points[j,3]) div 256;
end;

type SpaceFunc = Function(x,y:real):real;

function Saddle (x,y: real): real; far;
begin Saddle := (sqr(x)-sqr(y)); end;

function SinFunc (x,y: real): real; far;
begin SinFunc := Sin(x); end;

function SinCosFunc (x,y: real): real; far;
begin SinCosFunc := Sin(x)+Sin(y); end;

function sinCircle (x,y: real): real; far;
begin SinCircle := Sin(sqrt(sqr(x)+sqr(y))); end;

function sinX (x,y: real): real; far;
begin if (x=0) and (y=0)
      then SinX := 5
      else SinX := Sin(sqrt(sqr(x)+sqr(y)))/(sqrt(sqr(x)+sqr(y)))*5;
end;


function Flat (x,y: real): real; far;
begin Flat := Abs(x)+Abs(y); end;


procedure GetSpaceFromFunc (Func: SpaceFunc; XMin,XMax,YMin,YMax,XNum,YNum:LONGINT);
var DeltaX,DeltaY,X,Y: real;
    Num: Word;
begin
  Num := 1;
  DeltaX := (XMax-XMin)/XNum;
  DeltaY := (YMax-YMin)/YNum;
  X := XMin;
  Y := YMin;
  while Y < YMax do
  begin
    while X < XMax do
    begin
      New(Space[Num]);
      New(RealSpace[Num]);
      Space[Num]^.points[1,1] := RealtoFixed(X);
      Space[Num]^.points[1,2] := RealtoFixed(Y);
      Space[Num]^.points[1,3] := RealtoFixed(Func(X,Y));

      Space[Num]^.points[2,1] := RealtoFixed(X+DeltaX);
      Space[Num]^.points[2,2] := RealtoFixed(Y);
      Space[Num]^.points[2,3] := RealtoFixed(Func(X+DeltaX,Y));

      Space[Num]^.points[3,1] := RealtoFixed(X+DeltaX);
      Space[Num]^.points[3,2] := RealtoFixed(Y+DeltaY);
      Space[Num]^.points[3,3] := RealtoFixed(Func(X+DeltaX,Y+DeltaY));

      Space[Num]^.points[4,1] := RealtoFixed(X);
      Space[Num]^.points[4,2] := RealtoFixed(Y+DeltaY);
      Space[Num]^.points[4,3] := RealtoFixed(Func(X,Y+DeltaY));
      Inc(Num);
      X := X + DeltaX;
    end;
    Y := Y + DeltaY;
    X := XMin;
  end;
  Global.SizeOfSpace := Num-1;
end;




procedure GetSpaceFromDisk (filename: string);
var f: text;
    i,j,k: word;
begin
  assign (f,filename);
  reset (f);
  i := 0;
  writeln;
  while not(eof(f)) do
  begin
    inc(i);
    New(Space[i]);
    New(RealSpace[i]);
    for j := 1 to 4 do
      for k := 1 to 3 do
      begin
        read (f,Space[i]^.points[j,k]);
      end;
    readln (f);
  end;
  close(f);
  Global.SizeOfSpace := i;
  For i := 1 to Global.SizeOfSpace do
    For j := 1 to 4 do
      For k := 1 to 3 do
          Space[i]^.points[j,k] := RealtoFixed(Space[i]^.points[j,k])*2;
end;






procedure quicksort;

procedure sort(l,r: integer);
var
  e,f,i,j: longint;
  y: pointer;
  x: longint;
begin
  i:=l; j:=r; x:= realSpace[(i+j) div 2]^.dist;
  repeat
    while realSpace[i]^.dist<x do i:=i+1;
    while x<realSpace[j]^.dist do j:=j-1;
    if i<=j then
    begin
      y := realspace[i];
      realspace[i] := realspace[j];
      realspace[j] := y;
      i:=i+1; j:=j-1;
    end;
  until i>j;
    if l<j then sort(l,j);
  if i<r then sort(i,r);
end;

var z : word;
begin {quicksort};
  for z := 1 to Global.SizeofSpace do AvgDist(z);
  sort(1,Global.SizeOfSpace);
end;

procedure SetColors;
var j:      WORD;
    i:      WORD;
begin
  for i := 1 to 63 do
    setcolor (i,i,i,i);
  setcolor(255,63,63,63);
end;



var j,i: word;
    ch,ch2: char;
    x1,y1,x2,y2,x3,y3,x4,y4: integer;
    s: string;
    error,size: integer;
begin
  Clrscr;   { Clear the screen }

  repeat
    Writeln ('What to you wish to view?');
    Writeln;
    Writeln ('  1.  Hyperbloic Parabolid      ( Z = X^2-Y^2 )');
    Writeln;
    Writeln ('  2.  "Circular Sin" Funtion    ( Z = Sin(Sqrt(X^2+Y^2) )' );
    Writeln;
    Writeln ('  3.  "Dopler Sin" Function     ( Z = Sin(Sqrt(X^2+Y^2)/(Sqrt(X^2+Y^2) )');
    Writeln;
    Writeln ('  4.  Freeform object           ( Loaded from disk)');
    Writeln;
    Writeln ('  5.  Exit');
    Writeln;
    Write ('Please press a number 1..5: ');
    repeat
      getkey (ch,ch2);
    until (ch <> #0) or (ch2 <> #0);
    writeln;
    Global.Rotate := FALSE;
    case ch of
      '1': begin
                 GetSpacefromFunc (Saddle,-1,1,-1,1,15,15);
                 Global.EyeZ     := RealtoFixed(4);
           end;
      '2': begin GetSpacefromFunc (SinCircle,-10,10,-10,10,30,30);
                 Global.EyeZ     := RealtoFixed(30);
           end;
      '3': begin GetSpacefromFunc (SinX,-10,10,-10,10,30,30);
                 Global.EyeZ     := RealtoFixed(30);
           end;
      '4': begin
                 Getspacefromdisk('BOX.DAT');
                 Global.EyeZ     := RealtoFixed(120);
                 Global.Rotate := TRUE;
           end;

    end;
    if ch in ['1'..'4'] then
    begin



  MakeTrigTable;
  Global.Hidden := FALSE;
  Global.ScreenX  := 160;
  Global.ScreenY  := 90;
  Global.EyeX     := 0;
  Global.EyeY     := 0;
  Global.AngleX          := 250;
  Global.AngleY          := 0;
  Global.AngleZ          := 30;
  StartGraphics;
  SetUpVirtual;
  Cls(0,VADDR);
  repeat
  if Global.AngleX > 357 then dec(Global.AngleX,357);
  if Global.AngleY > 357 then dec(Global.AngleY,357);
  if Global.AngleZ > 357 then dec(Global.AngleZ,357);
  if Global.AngleX < 0 then Inc(Global.AngleX,360);
  if Global.AngleY < 0 then Inc(Global.AngleY,360);
  if Global.AngleZ < 0 then Inc(Global.AngleZ,360);
  if Global.Rotate
  then begin
    Inc(Global.AngleX,3);
    Inc(Global.AngleY,3);
    Inc(Global.AngleZ,3);
  end;

  SetRotation (Global.AngleX,Global.AngleY,Global.AngleZ);
  Rotate(Global.SizeOfSpace);
  if global.hidden then Quicksort;
  for i := 1 to Global.SizeOfSpace do
  Begin
    X1 := ((Realspace[i]^.points[1,1]+Global.EyeX) shl 8) div
          (Realspace[i]^.points[1,3]+Global.EyeZ) + Global.ScreenX;
    Y1 := ((Realspace[i]^.points[1,2]+Global.EyeY) shl 8) div
          (Realspace[i]^.points[1,3]+Global.EyeZ) + Global.ScreenY;
    X2 := ((Realspace[i]^.points[2,1]+Global.EyeX) shl 8) div
          (Realspace[i]^.points[2,3]+Global.EyeZ) + Global.ScreenX;
    Y2 := ((Realspace[i]^.points[2,2]+Global.EyeY) shl 8) div
          (Realspace[i]^.points[2,3]+Global.EyeZ) + Global.ScreenY;
    X3 := ((Realspace[i]^.points[3,1]+Global.EyeX) shl 8) div
          (Realspace[i]^.points[3,3]+Global.EyeZ) + Global.ScreenX;
    Y3 := ((Realspace[i]^.points[3,2]+Global.EyeY) shl 8) div
          (Realspace[i]^.points[3,3]+Global.EyeZ) + Global.ScreenY;
    X4 := ((Realspace[i]^.points[4,1]+Global.EyeY) shl 8) div
          (Realspace[i]^.points[4,3]+Global.EyeZ) + Global.ScreenX;
    Y4 := ((Realspace[i]^.points[4,2]+Global.EyeY) shl 8) div
          (Realspace[i]^.points[4,3]+Global.EyeZ) + Global.ScreenY;
    if global.hidden
    then drawpoly(x1,y1,x2,y2,x3,y3,x4,y4,0,VADDR);
    LineClip(X1,Y1,X2,Y2,255,VADDR);
    LineClip(X2,Y2,X3,Y3,255,VADDR);
    LineClip(X3,Y3,X4,Y4,255,VADDR);
    LineClip(X4,Y4,X1,Y1,255,VADDR);
  end;
  Flip(VADDR,VGA);
  Cls(0,VADDR);
  getkey(ch,ch2);
  if ch <> #0
  then
  case upcase(ch) of
    'D': Dec(Global.EyeZ,1024);
    'I': Inc(Global.EyeZ,1024);
    'H': Global.Hidden := not(Global.Hidden);
    'R': Global.Rotate := not(Global.Rotate);
  end;
  case ch2 of
    #72: Global.angleX := Global.angleX + 5;
    #80: Global.angleX := Global.angleX - 5;
    #75: Global.angleY := Global.angleY + 5;
    #77: Global.angleY := Global.angleY - 5;
    #73: Global.angleZ := Global.angleZ + 5;
    #81: Global.angleZ := Global.angleZ - 5;
  end;
  until ch = #27;
  shutdown;
  starttext;
  for i := 1 to Global.SizeOfSpace
    do begin
      dispose(space[i]);
      dispose(realspace[i]);
    end;
  end
  until ch = '5';
  ClearBuffer;
end.