Program Comit_Orbit;
{ By Joe Broms }

{ Some graphics procedures where writen by Axphisa.  Thanks! }

uses crt;

const Pi = 3.14159265359;

type GrCh = Array[1..8] of Byte;

{ character set }
const Alpha : Array[1..41] of GrCh =
((0,8,20,34,65,127,65,65), (0,63,65,65,63,65,65,63), (0,28,34,1,1,65,34,28),
(0,63,97,65,65,65,97,63),  (0,127,1,1,31,1,1,127),   (0,127,1,1,31,1,1,1),
(0,60,66,1,1,113,65,62),   (0,65,65,65,127,65,65,65),(0,127,8,8,8,8,8,127),
(0,127,8,8,8,9,9,6),       (0,65,33,17,15,17,33,65), (0,1,1,1,1,1,65,127),
(0,65,99,85,73,65,65,65),  (0,65,67,69,73,81,97,65), (0,28,34,65,65,65,34,28),
(0,63,65,65,63,1,1,1),     (0,28,34,65,65,113,34,92),(0,63,65,65,63,9,17,33),
(0,127,65,1,127,64,65,127),(0,127,8,8,8,8,8,8),      (0,65,65,65,65,65,65,62),
(0,65,65,65,65,34,20,8),   (0,65,65,65,73,73,73,54), (0,65,34,20,8,20,34,65),
(0,65,34,20,8,8,8,8),      (0,127,32,16,8,4,2,127),  (0,0,0,0,0,0,0,0),
(0,62,97,81,73,69,67,62),  (0,8,12,10,8,8,8,127),    (0,62,65,32,16,8,4,127),
(0,62,65,64,32,64,65,62),  (0,17,17,17,127,16,16,16),(0,127,1,1,63,64,64,63),
(0,60,2,1,63,65,65,62),    (0,127,65,64,32,16,8,8),  (0,62,65,65,62,65,65,62),
(0,62,65,65,126,64,32,28), (0,0,0,0,0,16,16,8),        (0,0,0,0,0,0,24,24),
(0,67,35,16,8,4,98,97),    (0,0,0,0,127,0,0,0));



type TrigTableRay = Array[0..9000] of real;                      { Mem: 30K }

CONST VGA = $a000;  (* This sets the constant VGA to the segment of the
                       VGA screen.                                      *)

Type Virtual = Array [1..64000] of byte;  { The size of our Virtual Screen }
     VirtPtr = ^Virtual;                  { Pointer to the virtual screen }

VAR Virscr : VirtPtr;                      { Our first Virtual screen }
    Vaddr  : word;                        { The segment of our virtual screen}

{ Global variables }
var TrigTable: ^TrigTableRay;

Procedure SetMCGA; BEGIN asm mov ax,0013h; int 10h; end; END;
Procedure SetText; BEGIN asm mov ax,0003h; int 10h; end; END;

Procedure Cls (Col : Byte; Where:word);
   { This clears the screen to the specified color }
BEGIN
     asm
        push    es
        mov     cx, 32000;
        mov     es,[where]
        xor     di,di
        mov     al,[col]
        mov     ah,al
        rep     stosw
        pop     es
     End;
END;


{}
Procedure Putpixel (X,Y : Integer; Col : Byte; where:word);
  { This puts a pixel on the screen by writing directly to memory. }
BEGIN
  Asm
    push    ds
    push    es
    mov     ax,[where]
    mov     es,ax
    mov     bx,[X]
    mov     dx,[Y]
    push    bx                      {; and this again for later}
    mov     bx, dx                  {; bx = dx}
    mov     dh, dl                  {; dx = dx * 256}
    xor     dl, dl
    shl     bx, 1
    shl     bx, 1
    shl     bx, 1
    shl     bx, 1
    shl     bx, 1
    shl     bx, 1                   {; bx = bx * 64}
    add     dx, bx                  {; dx = dx + bx (ie y*320)}
    pop     bx                      {; get back our x}
    add     bx, dx                  {; finalise location}
    mov     di, bx
    {; es:di = where to go}
    xor     al,al
    mov     ah, [Col]
    mov     es:[di],ah
    pop     es
    pop     ds
  End;
END;


{}
procedure WaitRetrace; assembler;
  {  This waits for a vertical retrace to reduce snow on the screen }
label
  l1, l2;
asm
    mov dx,3DAh
l1:
    in al,dx
    and al,08h
    jnz l1
l2:
    in al,dx
    and al,08h
    jz  l2
end;


{}
Procedure Pal(Col,R,G,B : Byte);
  { This sets the Red, Green and Blue values of a certain color }
Begin
   asm
      mov    dx,3c8h
      mov    al,[col]
      out    dx,al
      inc    dx
      mov    al,[r]
      out    dx,al
      mov    al,[g]
      out    dx,al
      mov    al,[b]
      out    dx,al
   end;
End;

{}
Procedure GetPal(Col : Byte; Var R,G,B : Byte);
  { This gets the Red, Green and Blue values of a certain color }
Var
   rr,gg,bb : Byte;
Begin
   asm
      mov    dx,3c7h
      mov    al,col
      out    dx,al

      add    dx,2

      in     al,dx
      mov    [rr],al
      in     al,dx
      mov    [gg],al
      in     al,dx
      mov    [bb],al
   end;
   r := rr;
   g := gg;
   b := bb;
end;

{}
Procedure SetUpVirtual;
   { This sets up the memory needed for the virtual screen }
BEGIN
  GetMem (VirScr,64000);
  vaddr := seg (virscr^);
END;


{}
Procedure ShutDown;
   { This frees the memory used by the virtual screen }
BEGIN
  FreeMem (VirScr,64000);
END;


{}
procedure flip(source,dest:Word);
  { This copies the entire screen at "source" to destination }
begin
  asm
    push    ds
    mov     ax, [Dest]
    mov     es, ax
    mov     ax, [Source]
    mov     ds, ax
    xor     si, si
    xor     di, di
    mov     cx, 32000
    rep     movsw
    pop     ds
  end;
end;

Procedure Line(a,b,c,d:integer;col:byte;where:word);
  { This draws a solid line from a,b to c,d in colour col }
  function sgn(a:real):integer;
  begin
       if a>0 then sgn:=+1;
       if a<0 then sgn:=-1;
       if a=0 then sgn:=0;
  end;
var i,s,d1x,d1y,d2x,d2y,u,v,m,n:integer;
begin
     u:= c - a;
     v:= d - b;
     d1x:= SGN(u);
     d1y:= SGN(v);
     d2x:= SGN(u);
     d2y:= 0;
     m:= ABS(u);
     n := ABS(v);
     IF NOT (M>N) then
     BEGIN
          d2x := 0 ;
          d2y := SGN(v);
          m := ABS(v);
          n := ABS(u);
     END;
     s := m shr 1;
     FOR i := 0 TO m DO
     BEGIN
          putpixel(a,b,col,where);
          s := s + n;
          IF not (s<m) THEN
          BEGIN
               s := s - m;
               a:= a + d1x;
               b := b + d1y;
          END
          ELSE
          BEGIN
               a := a + d2x;
               b := b + d2y;
          END;
     end;
END;



procedure WriteGraphCh (Ch: GrCh; Color:Byte; X,Y: word; Where: Word);
var i: byte;
begin
  for i := 1 to 8 do
  begin
    if (Ch[i] and $01<>0)
    then putpixel(X,Y+i-1,Color,Where)
    else putpixel(X,Y+i-1,0,Where);
    if (Ch[i] and $02<>0)
    then putpixel(x+1,y+i-1,Color,Where)
    else putpixel(x+1,y+i-1,0,Where);
    if (Ch[i] and $04<>0)
    then putpixel(x+2,y+i-1,Color,Where)
    else putpixel(x+2,y+i-1,0,Where);
    if (Ch[i] and $08<>0)
    then putpixel(x+3,y+i-1,Color,Where)
    else putpixel(x+3,y+i-1,0,Where);
    if (Ch[i] and $10<>0)
    then putpixel(x+4,y+i-1,Color,Where)
    else putpixel(x+4,y+i-1,0,Where);
    if (Ch[i] and $20<>0)
    then putpixel(x+5,y+i-1,Color,Where)
    else putpixel(x+5,y+i-1,0,Where);
    if (Ch[i] and $40<>0)
    then putpixel(x+6,y+i-1,Color,Where)
    else putpixel(x+6,y+i-1,0,Where);
    if (Ch[i] and $80<>0)
    then putpixel(x+7,y+i-1,Color,Where)
    else putpixel(x+7,y+i-1,0,Where);
  end;
end;

procedure ConvertString(var S: String);
var i: byte;
begin
  for i := 1 to length(s) do
    case ord(S[i]) of
      65..90:  S[i] := chr(ord(S[i]) - 64);
      32:      S[i] := chr(27);
      48..57:  S[i] := chr(ord(S[i]) - 20);
      ord(','):S[i] := chr(38);
      ord('.'):S[i] := chr(39);
      ord('%'):S[i] := chr(40);
      ord('-'):S[i] := chr(41);
      else s[i] := chr(27);
    end;
end;

procedure WriteGraphString (s: string; color: byte; x,y,where: word);
var i: byte;
begin
  convertstring(s);
  for i := 1 to length(S)
    do writeGraphCh (Alpha[ord(S[i])],Color,X+i*8-1,Y,Where);
end;
procedure WriteGraphStringCentered (s: string; color: byte; y,where: word);
var i: byte;
begin
  convertstring(s);
  for i := 1 to length(S)
    do writeGraphCh (Alpha[ord(S[i])],Color,round((160-(length(S)/2)*8)+i*8-1),Y,Where);
end;



procedure CreateTrigTable;
{ Allocates memory for sin table then sets up unit circle for sin form 0 to
  /2 in increments of .01 degrees.  NOTE: only run this procedure once or
  dispose of memory first, unpreditable resluts could happen.  Time: 3 secs }

var w: word;
    s: string[3];
begin
  new(TrigTable);                                         { Allocate Memory }
  for w := 0 to 9000 do                                  { Go from 0 to /2 }
    TrigTable^[w] := Sin ((0.5*pi*w)/(9000));        { Assign correct value }
end;

procedure DestroyTrigTable;
{ Deallocates memory from TrigTable.  NOTE: Only use after CreateTrig table
  has been called }
begin
  dispose(TrigTable);                                   { Deallocate memory }
end;

function Rad2Deg(Rad: Real): real;
{ Converts radians to degrees }
begin
  Rad2Deg := Rad*180/pi;
end;

function Deg2Rad(Deg: Real): real;
{ Converts degress to radians }
begin
  Deg2Rad := Deg*pi/180;
end;


function SinDeg(Deg: real): real;
{ finds sin up to 2 decimal places (example sindeg(32.87)).  About 6 times as
  fast as sin.  NOTE: first call CreateTrigTable.  Time: .000054 approx }
begin
  { Calculate degrees between 0 and 360 }
  if Deg > 360 then Deg := Deg - (round(Deg) div 360)*360
               else if Deg < 0   then Deg := Deg + (round(-Deg+360) div 360)*360;
  if Abs(90-Deg) <= 90                               { if between 0 and 180 }
  then if Deg <= 90                           { Is it less than 90 degrees? }
       then SinDeg := +TrigTable^[round(deg*100)]          { First Quadrant }
       else SinDeg := +TrigTable^[18000-round(deg*100)]   { Second Quadrant }
  else if Deg <= 270                         { Is it less then 270 degrees? }
       then SinDeg := -TrigTable^[round(deg*100)-18000]    { Third Quadrant }
       else SinDeg := -TrigTable^[36000-round(deg*100)];  { Fourth Quadrand }
end;


function CosDeg(Deg: real): real;
{ finds cos up to 2 decimal places (example cosdeg(44.01)). About 6 times as
  fast as cos.  NOTE: first call CreateTrigTable.  Time: .000054 approx }
begin
  { Calculate degrees between 0 and 360 }
  if Deg > 360 then Deg := Deg - (round(Deg) div 360)*360
               else if Deg < 0
                    then Deg := Deg + (round(-Deg+360) div 360)*360;
  if Abs(90-Deg) <= 90                               { if between 0 and 180 }
  then if Deg <= 90                           { Is it less than 90 degrees? }
       then CosDeg := +TrigTable^[round(9000-deg*100)]       { 1st Quadrant }
       else CosDeg := -TrigTable^[round(deg*100)-9000]       { 2nd Quadrant }
  else if Deg <= 270                         { Is it less then 270 degrees? }
       then CosDeg := -TrigTable^[9000-round(deg*100-18000)] { 3rd Quadrant }
       else CosDeg := +TrigTable^[round(deg*100)-27000];{ 4th Quadrand }
end;

function TanDeg(Deg: real): real;
{ finds cos up to 2 decimal places (example tan(44.01)). About 10 times as
  fast.  NOTE: first call CreateTrigTable.  Time: .000115 approx }
begin
  if Deg > 360 then Deg := Deg - (round(Deg) div 360)*360
               else if Deg < 0
                    then Deg := Deg + (round(-Deg+360) div 360)*360;
  if Abs(90-Deg) <= 90                               { if between 0 and 180 }
  then if Deg <= 90                           { Is it less than 90 degrees? }
       then TanDeg := TrigTable^[round(deg*100)] /
                      TrigTable^[round(9000-deg*100)]        { 1st Quadrant }
       else TanDeg := -(TrigTable^[18000-round(deg*100)] /
                      TrigTable^[round(deg*100)-9000])       { 2nd Quadrant }
  else if Deg <= 270                         { Is it less then 270 degrees? }
       then TanDeg := TrigTable^[round(deg*100)-18000] /
                      TrigTable^[9000-round(deg*100-18000)]  { 3rd Quadrant }
       else TanDeg := -(TrigTable^[36000-round(deg*100)] /
                      TrigTable^[round(deg*100)-27000]);     { 4th Quadrand }
end;

function SecDeg(Deg: real): real;
{ finds sin up to 2 decimal places (example sin(32.87)).  About 10 times as
  fast.  NOTE: first call CreateTrigTable.  Time: .000033 approx }
begin
  SecDeg := 1/CosDeg(Deg);
end;

function CscDeg(Deg: real): real;
{ finds cos up to 2 decimal places (example cos(44.01)). About 10 times as
  fast.  NOTE: first call CreateTrigTable.  Time: .000098 approx }
begin
  CscDeg := 1/SinDeg(Deg);
end;

function CotDeg(Deg: real): real;
{ finds cos up to 2 decimal places (example tan(44.01)). About 10 times as
  fast.  NOTE: first call CreateTrigTable.  Time: .000115 approx }
begin
  CotDeg := 1/TanDeg(Deg);
end;

function SinRad(Rad: real): real;
{ finds sin up to 2 decimal places (example sinRad(32.87)).  About 6 times as
  fast as sin.  NOTE: first call CreateTrigTable.  Time: .000054 approx }
begin
  { Calculate degrees between 0 and 360 }
  Rad := Rad2Deg(Rad);
  if Rad > 360 then Rad := Rad - (round(Rad) div 360)*360
               else if Rad < 0   then Rad := Rad + (round(-Rad+360) div 360)*360;
  if Abs(90-Rad) <= 90                               { if between 0 and 180 }
  then if Rad <= 90                           { Is it less than 90 degrees? }
       then SinRad := +TrigTable^[round(Rad*100)]          { First Quadrant }
       else SinRad := +TrigTable^[18000-round(Rad*100)]   { Second Quadrant }
  else if Rad <= 270                         { Is it less then 270 degrees? }
       then SinRad := -TrigTable^[round(Rad*100)-18000]    { Third Quadrant }
       else SinRad := -TrigTable^[36000-round(Rad*100)];  { Fourth Quadrand }
end;


function CosRad(Rad: real): real;
{ finds cos up to 2 decimal places (example cosRad(44.01)). About 6 times as
  fast as cos.  NOTE: first call CreateTrigTable.  Time: .000054 approx }
begin
  Rad := Rad2Deg(Rad);
  { Calculate degrees between 0 and 360 }
  if Rad > 360 then Rad := Rad - (round(Rad) div 360)*360
               else if Rad < 0
                    then Rad := Rad + (round(-Rad+360) div 360)*360;
  if Abs(90-Rad) <= 90                               { if between 0 and 180 }
  then if Rad <= 90                           { Is it less than 90 degrees? }
       then CosRad := +TrigTable^[round(9000-Rad*100)]       { 1st Quadrant }
       else CosRad := -TrigTable^[round(Rad*100)-9000]       { 2nd Quadrant }
  else if Rad <= 270                         { Is it less then 270 degrees? }
       then CosRad := -TrigTable^[9000-round(Rad*100-18000)] { 3rd Quadrant }
       else CosRad := +TrigTable^[round(Rad*100)-27000];{ 4th Quadrand }
end;

function TanRad(Rad: real): real;
{ finds cos up to 2 decimal places (example tan(44.01)). About 10 times as
  fast.  NOTE: first call CreateTrigTable.  Time: .000115 approx }
begin
  Rad := Rad2Deg(Rad);
  if Rad > 2*pi then Rad := Rad - (round(Rad) div 360)*360
               else if Rad < 0
                    then Rad := Rad + (round(-Rad+360) div 360)*360;
  if Abs(90-Rad) <= 90                               { if between 0 and 180 }
  then if Rad <= 90                           { Is it less than 90 degrees? }
       then TanRad := TrigTable^[round(Rad*100)] /
                      TrigTable^[round(9000-Rad*100)]        { 1st Quadrant }
       else TanRad := -(TrigTable^[18000-round(Rad*100)] /
                      TrigTable^[round(Rad*100)-9000])       { 2nd Quadrant }
  else if Rad <= 270                         { Is it less then 270 degrees? }
       then TanRad := TrigTable^[round(Rad*100)-18000] /
                      TrigTable^[9000-round(Rad*100-18000)]  { 3rd Quadrant }
       else TanRad := -(TrigTable^[36000-round(Rad*100)] /
                      TrigTable^[round(Rad*100)-27000]);     { 4th Quadrand }
end;

function SecRad(Rad: real): real;
{ finds sin up to 2 decimal places (example sin(32.87)).  About 10 times as
  fast.  NOTE: first call CreateTrigTable.  Time: .000033 approx }
begin
  Rad := Rad2Deg(Rad);
  SecRad := 1/CosRad(Rad);
end;

function CscRad(Rad: real): real;
{ finds cos up to 2 decimal places (example cos(44.01)). About 10 times as
  fast.  NOTE: first call CreateTrigTable.  Time: .000098 approx }
begin
  Rad := Rad2Deg(Rad);
  CscRad := 1/SinRad(Rad);
end;

function CotRad(Rad: real): real;
{ finds cos up to 2 decimal places (example tan(44.01)). About 10 times as
  fast.  NOTE: first call CreateTrigTable.  Time: .000115 approx }
begin
  Rad := Rad2Deg(Rad);
  CotRad := 1/TanRad(Rad);
end;




Function ArcCos ( Number : real ) : real;

begin {ArcCos}
  if Number = 0 then
    ArcCos := Pi/2
  else if Abs(Number) <1 then
    ArcCos := ArcTan(Sqrt(1-Number*Number)/Number)
  else
    begin
      writeln('Out of range error (ArcCos)');
      writeln('Press return to continue.');
      readln;
    end;
end;  {ArcCos}


{***************************  ArcSin  *****************************}

Function ArcSin ( Number : real ) : real;

begin {ArcSin}
  if Number = 1 then
    ArcSin := Pi/2
  else if Number = -1 then
    ArcSin := -Pi/2
  else if Abs(Number) < 1 then
    ArcSin := ArcTan(Number/Sqrt(1-Number*Number))
  else
    begin
      writeln('Out of range error (ArcSin)');
      writeln('Press return to continue.');
      readln;
    end;
end;  {ArcSin}

Function PowerReal ( Base : real; Exponent : real ) : real;

{PowerReal takes two real numbers, Base and Exponent, and returns
 Base^Exponent.  For integral answers, use Power.                  }

begin {PowerReal}
  if (Base > 0) then
    PowerReal := Exp(Exponent*ln(Base))
  else
    begin {else}
    if (100*round(Exponent) = round(100*Exponent)) then
      begin {Integer check}
        if (round(Exponent) mod 2 = 0) then
          PowerReal := Exp(Exponent*ln(Abs(Base)))
        else
          PowerReal :=-Exp(Exponent*ln(Abs(Base)))
      end   {Integer check}
    else
      begin {Non-integral}
        writeln('ERROR:  A non-integral exponent and a negative base');
        writeln('results in an imaginary answer.  Press return to continue.');
        readln;
      end;  {Non-Integral}
    end;   {else}
end;  {PowerReal}

function FindDeltaV (R: real): real;
begin
  FindDeltaV := PowerReal(6.35,3) / Sqr(R);
end;

function Distance (x1,y1,x2,y2: real): real;
begin
  Distance := Sqrt (Sqr(y2-y1) + Sqr(x2-x1));
end;


procedure intro;
begin
  clrscr;
  writeln ('Comit Orbit Plotter Ver 1.1');
  writeln ('written by Joe Broms');
  writeln;
  write ('Creating Trigonometry Table...');
  CreateTrigTable;
  writeln ('Done!');
  write ('Allocating Memory for display...');
  SetUpVirtual;
  writeln ('Done!');
  writeln;
end;

procedure GetInformation (var x1,y1,x2,y2,days: real; var color,stats: boolean);
var S: string;
    ErrorCode: integer;
begin
  repeat
    write ('Enter X cooridnate (A.U.): ');
    readln (s);
    val (s,x1,errorcode);
  until errorcode = 0;
  x1 := x1*6.35;
  writeln;
  repeat
    write ('Enter Y cooridnate (A.U.): ');
    readln (s);
    val (s,y1,errorcode);
  until errorcode = 0;
  y1 := y1*6.35;
  writeln;
  repeat
    write ('Enter Velocity, X component (A.U. per 60 days): ');
    readln (s);
    val (s,x2,errorcode);
  until errorcode = 0;
  x2 := x2*6.35;
  writeln;
  repeat
    write ('Enter Velocity, Y component (A.U. per 60 days): ');
    readln (s);
    val (s,y2,errorcode);
  until errorcode = 0;
  writeln;
  y2 := y2*6.35;
  repeat
    write ('Enter Number of days between calculations (days): ');
    readln (s);
    val (s,days,errorcode);
  until errorcode = 0;
  days := days/60;
  writeln;
  write ('Change color with changing speed? (Y/N): ');
  readln (s);
  Color := Upcase(S[1]) = 'Y';
  writeln;
  write ('Display Stats on screen (Y/N): ');
  readln (s);
  Stats := Upcase(S[1]) = 'Y';
end;

procedure getkeys (var ch,ch2: char);
begin
  if keypressed
  then begin
    ch := readkey;
    if ch = #0
    then ch2 := readkey
    else ch2 := #0;
  end
  else begin
    ch := #0;
    ch2 := #0
  end;
end;


var path: array[1..2000,1..5] of real;
    color,stats:                                                 boolean;
    circlesize,
    Days,X1,Y1,X2,Y2,DeltaV,Angle,DeltaX,DeltaY,ChangeX,ChangeY: real;
    oldscale,scale:                                              real;
    i,j:                                                         word;
    answer,s:                                                    string[15];
    ch,ch2:                                                      char;

procedure MoveComit (var X,Y,LastX,LastY: real);
var DeltaV,DeltaX,DeltaY,ChangeX,ChangeY: real;
begin
    DeltaV := FindDeltaV(Distance(LastX,LastY,0,0))*sqr(days);       { Find Delta }
    if (LastX > 0) then Angle := ArcTan(LastY/LastX);        { Find Angle from comit }
    if (LastX < 0) then Angle := ArcTan(LastY/LastX) - pi;
    DeltaX := DeltaV*CosRad(angle);            { Get X component for DeltaV }
    DeltaY := DeltaV*SinRad(angle);            { Get Y component for DeltaV }
    ChangeX := ((LastX - X) - DeltaX);
    ChangeY := ((LastY - Y) - DeltaY);
    X := LastX;
    Y := LastY;
    LastX := ChangeX + LastX;
    LastY := ChangeY + LastY;
    Path[I,1] := X;
    Path[I,2] := Y;
    Path[I,3] := LastX;
    Path[I,4] := LastY;
end;


begin
  intro;

  repeat
    x2 := 0;
    y2 := 0;

    GetInformation (X1,Y1,X2,Y2,Days,Color,Stats);

  { change velocity to conpensate for deltaV }
    X2 := (X2 * days) + X1;
    Y2 := (Y2 * days) + Y1;

  { Set first point }
    Path[1,1] := X1;
    Path[1,2] := Y1;
    Path[1,3] := X2;
    Path[1,4] := Y2;

    if color then
      if Round(Distance(Path[1,1],Path[1,2],Path[1,3],Path[1,4])*10/Days+20) > 100
      then Path[1,5] := 101
      else Path[1,5] := Round(Distance(Path[1,1],Path[1,2],Path[1,3],Path[1,4])*10/Days+20)
    else Path[1,5] := 15;


  { Set MCGA and clear screens }
    SetMCGA;
    Cls (0,Vaddr);
    Cls (0,VGA);

  Scale := 10;
  OldScale := 0;  { This is set purposely different to make sure entire
                     screen is drawn first time }

  {  set palette }
  for i := 20 to 100 do
    pal(i,(i div 2),0,60-(i div 2));    { Red to Blue }
  pal(101,255,0,0);                     { Red }

  i := 2;

  repeat

  { autoscale }
    while ((x2*scale+160 < 5) or (x2*scale+160 > 315)) or
          ((-y2*scale+100 < 5) or (-y2*scale+100 > 195))
    do begin
      scale := scale * 0.99;
    end;

    if oldscale <> scale        { Did screen change? }
    then begin
      cls(0,Vaddr);
      line (160,1,160,199,15,VADDR);
      line (1,100,320,100,15,VADDR);
      for j := 1 to I-1 do
      line (round(Path[j,1]*Scale+160),round(-Path[j,2]*Scale+100),
            round(Path[j,3]*Scale+160),round(-Path[j,4]*Scale+100),
            trunc(Path[j,5]),VADDR);

      end
      else
            line (round(Path[i-1,1]*Scale+160),round(-Path[I-1,2]*Scale+100),
            round(Path[i-1,3]*Scale+160),round(-Path[I-1,4]*Scale+100),
            trunc(Path[i-1,5]),VADDR);
    oldscale := scale;

    if stats then
    begin
      str (I:6,s);
      writegraphstring ('I  '+S,15,1,1,VADDR);
      str ((X1/6.35):6:3,s);
      writegraphstring ('X  '+S,15,1,11,VADDR);
      str (Y1/6.35:6:3,s);
      writegraphstring ('Y  '+S,15,1,21,VADDR);
      str (Distance(x1,y1,x2,y2)/6.35*days:6:3,s);
      writegraphstring ('VEL'+S,15,1,31,VADDR);
    end;

    flip(VADDR,VGA);                            { draw screen }

   { Calculate orbit }

   MoveComit (X1,Y1,X2,Y2);

    if color then
      if Round(Distance(Path[I,1],Path[i,2],Path[I,3],Path[I,4])*10/Days+20) > 100
      then Path[I,5] := 101
      else Path[I,5] := Round(Distance(Path[I,1],Path[i,2],Path[I,3],Path[I,4])*10/Days+20)
    else Path[I,5] := 15;

    inc(i);

    getkeys (ch,ch2);

  if ch in ['P','p']
  then begin
    writegraphstring ('PAUSED',15,1,190,VGA);
    repeat
      getkeys (ch,ch2);
    until (ch <> #0) or (ch2 <> #0);
    oldscale := 0;
  end;
  until (ch = #27) or (i = 4000);
  if ch <> #27 then readln;
  settext;
  clrscr;
  write ('Try another orbit? (Y/N):');
  readln (answer);
  writeln;
  until not(upcase (answer[1]) = 'Y');
  ShutDown;
  DestroyTrigTable;
  Clrscr;
end.




