Program Intro_to_Demo;
{$M 8192,0,0}

uses VGA256,                               { My graphics unit in mode 13h }
     INPUT,                                { My input unit }
     Crt,                                  { turbo pascal 7.0 units }
     dos;

procedure DrawMenuScreen;
var i,j : byte;
begin
  for i := 1 to 25 do
    for j := 1 to (25-i) do
      begin
        line (i*6,0,0,j*4,i,VGA);
        line (-i*6+320,0,320,j*4,i,VGA);
        line (i*6,200,0,-j*4+200,i,VGA);
        line (-i*6+320,200,320,-j*4+200,i,VGA);
      end;
  WriteGraphStringCentered ('Pascal Demos',15,255,VGA);
  Line (116,24,215,24,255,VGA);
  WriteGraphString ('1.  Recursive Search',       55,50,255,VGA);
  WriteGraphString ('2.  Comet Orbit',            55,70,255,VGA);
  WriteGraphString ('3.  The Solar System',       55,90,255,VGA);
  WriteGraphString ('4.  3D Projections',         55,110,255,VGA);
  WriteGraphString ('5.  Service Hour Database',  55,130,255,VGA);
  WriteGraphString ('6.  Exit',       55,150,255,VGA);
end;




procedure Menu (var selection: byte);
{ Simple menu for intro }
var i: byte;
    ch,
    ch2: char;
begin
  Selection := 1;
  repeat
    getkey (ch,ch2);
    case ch2 of
      #80: begin
             inc(selection);
             if selection = 7 then selection := 1;
           end;
      #72: begin
             dec(selection);
             if selection = 0 then selection := 6;
           end;
    end;
    for i := 1 to 6 do
    if i = selection
    then rectangle (50,i*20+26,275,i*20+43,255,VGA)
    else rectangle (50,i*20+26,275,i*20+43,0,VGA);
  until (ch in [#13,#27]) or (ch in ['1'..'6']);
      { to finish must press escape or return }
  if (ch in ['1'..'6']) then selection := ord(ch) - 48;
  if ch = #27 then selection := 6;
end;




var Pal: RGB256;                                             { My palette }
    Selection,
    error,i: byte;

begin
  Clrscr;                                              { Dos clear screen }
  StartGraphics;                                { Start graphics mode 13h }

  ResetScreenPalette(0);                     { Set whole RGB palette to 0 }
  LoadPic ('MYPICT.PIC',0,0,VGA,Pal);       { Load picture }
  FadeIn (Pal,0);                               { Fade picture to screen }
  Delay (1000);                                           { Wait 1 second }
  FadeOut (0);                                            { Fade to black }

  repeat

  StartGraphics;                                { Start graphics mode 13h }
  ResetScreenPalette(0);                     { Set whole RGB palette to 0 }
  Cls (0,VGA);                                    { Clear screen to black }

  for i := 1 to 50 do         { set palette to different shades of purpel }
  begin
    pal[i,1] := i+13;                                 { only red ann blue }
    pal[i,2] := 0;
    pal[i,3] := i+13;                                 { only red ann blue }
  end;
  pal[255,1] := 63;
  pal[255,2] := 63;
  pal[255,3] := 63;

  DrawMenuScreen;
  fadein (pal,0);                               { fade picture to screen }
  Menu (Selection);
  cls(0,VGA);

  swapvectors;
  case selection of
    1: begin
         StartText;
         Exec(GetEnv('COMSPEC'), '/C' + 'reader search.doc');
         Exec(GetEnv('COMSPEC'), '/C' + 'search.exe');
         StartGraphics;
       end;
    2: begin
         Exec(GetEnv('COMSPEC'), '/C' + 'reader orbit.doc');
         Exec(GetEnv('COMSPEC'), '/C' + 'orbit.exe');
       end;
    3: begin
         Exec(GetEnv('COMSPEC'), '/C' + 'reader solarsys.doc');
         Exec(GetEnv('COMSPEC'), '/C' + 'solarint.exe');
         Exec(GetEnv('COMSPEC'), '/C' + 'solarsys.exe');
       end;
    4: begin
         Exec(GetEnv('COMSPEC'), '/C' + 'reader project.doc');
         Exec(GetEnv('COMSPEC'), '/C' + 'project.exe');
       end;
    5: begin
         StartText;
         Exec(GetEnv('COMSPEC'), '/C' + 'reader service.doc');
         Exec(GetEnv('COMSPEC'), '/C' + 'service.exe');
         StartGraphics;
       end;
  end;
  swapvectors;
  until selection in [0,6];
  starttext;
end.
