Program Read_me; { by John Stephenson, Copyright 1994 }
Uses Crt,Asmmisc,Dos;

{ Uses a double linked list to handle files greater than 64k. Rather slow }
{ screen display. To increase speed rewrite the SW & SWrite procedures in }
{ assembler. If you do, please send all revisions to me, as I don't have  }
{ the time to do it myself, but wanted a quick way to see nice colours on }
{ the screen! :>                                                          }

Const
  Product = 'Read Me';
  Version = '1.00a';
  Release = 'Gamma';
  Author  = 'John Stephenson';

{$I KEY_DEF.INC}

Type
  StringPtr = ^String;
  LlPtr = ^ll;
  Ll = record
    Data: StringPtr;
    Next,Prev: llPtr;
  End;

Procedure SWrite(x,y: Byte; S: String);
var
  loop: byte;
  controlseq: string[3];
begin
  ControlSeq := '';

  for loop := 1 to length(s) do begin
    if (controlseq[0] <> #0) then begin
      Controlseq := controlseq+s[loop];
      if (controlseq[0] = #3) and (controlseq[1] = '|') then begin
        case controlseq[2] of
          '0'..'9': textattr := textattr and $0F+(byte(controlseq[2])-byte('0')) shl 4;
          'A'..'F': textattr := textattr and $0F+(byte(controlseq[2])-byte('A')+10) shl 4;
        end;
        case controlseq[3] of
          '0'..'9': textattr := textattr and $F0+(byte(controlseq[3])-byte('0'));
          'A'..'F': textattr := textattr and $F0+(byte(controlseq[3])-byte('A')+10);
        end;
        controlseq := '';
      end;
      if controlseq = '||' then begin
        putchars(x,y,controlseq[1],1);
        inc(x);
        controlseq := '';
      end;
    end
    else if s[loop] = '|' then controlseq := s[loop]
    else begin
      putchars(x,y,s[loop],1);
      inc(x);
    end;
  end;
end;

Procedure Display(From : LLPtr);
Var Count : Integer;
Begin
  Count := 1;
  While (Count <= hi(windmax)) and (From <> nil) do begin
    putchars(1,count,' ',80);
    SWrite(1,count,From^.Data^);
    From := From^.Next;
    Inc(Count);
  End;
  for count := count to hi(windmax) do putchars(1,count,' ',80);
End;

Var
  Ch      : Char;
  Count,
  loop    : Integer;
  curr,
  next,
  tail,
  head    : llptr;
  f       : text;
  lines   : longint;
  temp    : string;
  more    : boolean;
  filename: pathstr;
Begin
  if paramcount = 0 then filename := 'README.NOW'
  else filename := paramstr(1);
  writeln('Reading: ',filename);
  Assign(f,filename);
  Reset(f);
  Lines := 0;
  New(curr);
  Head := curr;
  tail := nil;
  Repeat
    if lines mod 25 = 0 then write(#13'Line: ',lines);
    Inc(lines);
    Readln(f,temp);
    More := not eof(f);

    { Get memory for the next linked data, only if needed, else terminate }
    { the list with a nil                                                 }
    If more then begin
      new(next);
      Curr^.Next := next;
    end
    else Curr^.next := nil;
    Curr^.prev := tail;

    Getmem(Curr^.data,length(temp)+1);
    Curr^.Data^ := temp;
    { Remap ident on to the next data item }
    tail := curr;
    If more then curr := next;
  Until not more;
  write(#13'Line: ',lines);
  Close(f);
  writeln;

  Curr := Head; { Point our marker pointer to the top of the list }

  clrscr;
  textattr := blue shl 4+lightcyan;
  gotoxy(1,hi(windmax)+1);
  write(' Use , and page up & down to scroll file, <ESC> to exit');
  clreol;
  textattr := lightgray;
  cursoroff;
  Repeat
    Display(Curr);     { Display a few lines }

    ch := readkey;
    { Read a key, check its value }
    If ch = #0 then begin
      ch := readkey;
      Case Ch of
        _Up   : If Curr^.Prev <> nil then Curr := Curr^.Prev;
        _Down : If Curr^.Next <> nil then Curr := Curr^.Next;
        _PageDown : Begin
          Count := 0;
          While (Count<hi(windmax)) and (Curr^.Next<>nil) do begin
            Curr := Curr^.Next;
            Inc(Count);
          End;
        End;
        _PageUp : Begin
          Count := 0;
          While (Count < hi(windmax)) and (Curr^.Prev <> nil) do Begin
            Curr := Curr^.Prev;
            Inc(Count);
          End;
        End;
        _Home : Curr := Head;        { Pretty simple, huh? }
        _End : Begin
          { Goto the end }
          While curr^.next <> nil do curr := curr^.next;
          { Move up so it's on screen ok }
          For loop := 1 to hi(windmax)-1 do if curr^.prev <> nil then curr := curr^.prev;
        End;
      End;  { Case }
    End;
  Until Ch = #27;
  Cursoron;
  Gotoxy(1,hi(windmax)+1);
  Clreol;
End.
