{ NOTE: This the actual section of source code used in JSDOOR, BUT do not }
{ use this to transfer files, use the one in the JSDOOR unit or else you're }
{ linking in something twice. I only did this so you could make a standalone }
{ mymodem without using the jsdoor unit }

{$DEFINE MYMODEM_Send_debug}
{$DEFINE MYMODEM_Recieve_debug}
type
  mymodem_header = record
    filename: string[12];   { Filename, just name & ext, no path! Duh! }
    attr: word;             { File attributes }
    time_and_date: longint; { Time & Date of the file }
    Size: longint;          { Size of the file }
    other: byte;            { Should be left nil, do not used }
    otherstr: string[80];   { Other string related to other byte, not used }
  end;
Const
  autostart = ^U^H+'MyModem'+^U^H;
  ack = #25;
  nak = #24;
  { 25 acknowledgements }
  endsend = ack+ack+ack+ack+ack+ack+ack+ack+ack+ack+
            ack+ack+ack+ack+ack+ack+ack+ack+ack+ack+
            ack+ack+ack+ack+ack;
  enter = #13#10;


Function WaitAck(ms: word): boolean;
var
  timeout: word;
  ch: char;
begin
  timeout := ms div 100; { Since we wait in 100 chunks }
  repeat
    delay(100);
    dec(timeout);
    if dataavailable then ch := readkeyfromport
    else ch := #0;
  until (ch in [nak,ack]) or (timeout = 0);
  { Wait until it's ack'd or nak'd, or we have a timeout }
  if (timeout=0) or (ch <> ack) then waitack := false
  else waitack := true;
end;

Procedure Mymodem_recieve(dir: string);
var
  outf: file;
  header: mymodem_header;
  headerascii: array[1..sizeof(mymodem_header)] of char absolute header;
  ch: char;
  posit: word;
  buffer: array[1..8192] of char;
  timeout: word;
  loop: longint;
begin
  purgeinput;
  {$IFDEF MYMODEM_Recieve_debug}
  writeln('Sending acknowledgement');
  {$ENDIF}
  writeport(ack);
  {$IFDEF MYMODEM_Recieve_debug}
  writeln('Awaiting responce');
  {$ENDIF}
  if not waitack(5000) then begin
    {$IFDEF MYMODEM_Recieve_debug}
    writeln('Timeout occured for responce');
    {$ENDIF}
  end
  else begin
    {$IFDEF MYMODEM_Recieve_debug}
    writeln('Request accepted');
    writeln('Recieving data header');
    {$ENDIF}
    { Okay, Time to read in the header (of 105 bytes -- last time I checked) }
    for loop := 1 to sizeof(mymodem_header) do begin
      {$IFDEF MYMODEM_Recieve_debug}
      write(#13,loop,' bytes of the header recieved');
      {$ENDIF}
      headerascii[loop] := readkeyfromport;
    end;
    {$IFDEF MYMODEM_Recieve_debug}
    writeln;
    writeln('Header recieved (',loop,' bytes)');
    {$ENDIF}
    if header.other <> 0 then begin
      {$IFDEF MYMODEM_Recieve_debug}
      writeln('ERROR file is unable to be recieved by this version of MyModem!');
      writeln('FATAL error');
      {$ENDIF}
      halt(1);
    end;
    { Say we've got the header }
    {$IFDEF MYMODEM_Recieve_debug}
    writeln('Sending ACK to verify we''ve recieved the header');
    {$ENDIF}
    writeport(ack);

    assign(outf,dir+header.filename);
    rewrite(outf,1);
    if ioresult = 0 then begin
      {$IFDEF MYMODEM_Recieve_debug}
      writeln('Recieving dump of ',header.filename ,' (', header.size, ' bytes)');
      {$ENDIF}
      loop := 0;
      posit := 0;
      repeat
        inc(loop);
        inc(posit);
        buffer[posit] := readkeyfromport;
        if posit > sizeof(buffer) then begin
          blockwrite(outf,buffer,posit);
          posit := 0;
        end;
      until (loop = header.size) or keypressed;
      { Flush what's left in there }
      if posit <> 1 then begin
        blockwrite(outf,buffer,posit);
        posit := 1;
      end;
      { Set time & date, before file closed }
      setftime(outf,header.time_and_date);
      close(outf);
      { Set attributes, after file closed }
      setfattr(outf,header.attr);
      { Don't worry about other, and otherstuff, and the filename has }
      { already been taken care of :)                                 }
    end;
  end;
  purgeinput;
end;

Procedure Mymodem_send(filename: string);
Var
  inf: file;
  header: mymodem_header;
  dir: dirstr;
  name: namestr;
  ext: extstr;
  ch: char;
  numread: word;
  buffer: array[1..8192] of char;
  timeout: word;
begin
  purgeinput;
  filename := fexpand(filename);
  assign(inf,filename);
  { Must get it while it while file NOT open, don't ask }
  getfattr(inf,header.attr);
  if doserror <> 0 then begin
    {$IFDEF MYMODEM_Send_debug}
    writeln('File not found!')
    {$ENDIF}
  end
  else begin
    reset(inf,1);
    { Make up the header to send }
    fsplit(filename,dir,name,ext);
    header.filename := name+ext;
    getftime(inf,header.time_and_date);
    header.size := filesize(inf);
    header.other := 0;
    header.otherstr := '';
    { Okay, now with that out of the way, lets send out the auto-init }
    {$IFDEF MYMODEM_Send_debug}
    writeln('Sending press Control X to abort message');
    {$ENDIF}
    writeport('Mymodem download, press Control X to abort download');
    {$IFDEF MYMODEM_Send_debug}
    writeln('Sending init string');
    {$ENDIF}
    writeport(enter+autostart+enter);
    {$IFDEF MYMODEM_Send_debug}
    writeln('Waiting for ACK');
    {$ENDIF}
    if not waitack(10000) then begin
      {$IFDEF MYMODEM_Send_debug}
      writeln('Timeout on waiting for ack');
      {$ENDIF}
    end
    else begin
      {$IFDEF MYMODEM_Send_debug}
      writeln('Recieved ack for the init');
      writeln('Sending ACK to verify that this is mymodem sending');
      {$ENDIF}
      writeport(ack);
      {$IFDEF MYMODEM_Send_debug}
      writeln('Sending mymodem header to remote');
      {$ENDIF}
      { Write the header }
      blockwriteport(header,sizeof(header));
      {$IFDEF MYMODEM_Send_debug}
      writeln('Waiting for ack to verify reciept of header');
      {$ENDIF}
      if not waitack(10000) then begin
        {$IFDEF MYMODEM_Send_debug}
        writeln('Timeout occured waiting for ack on the header');
        {$ENDIF}
      end
      else begin
        {$IFDEF MYMODEM_Send_debug}
        writeln('Dumping file '+header.filename,' (',header.size,')');
        {$ENDIF}
        purgeinput;
        repeat
          {$IFDEF MYMODEM_Send_debug}
          writeln('Attempting to read ',sizeof(buffer), ' bytes');
          {$ENDIF}
          blockread(inf,buffer,sizeof(buffer),numread);
          {$IFDEF MYMODEM_Send_debug}
          writeln('Read ',numread,' bytes');
          writeln('Sending ',numread,' bytes');
          {$ENDIF}
          blockwriteport(buffer,numread);
          if dataavailable then numread := 0; { Abort }
        until (numread = 0) or keypressed;
        writeport(enter+'Completed!'+enter);
        close(inf);
      end;
    end;
  end;
  purgeinput;
end;
