#define INCL_WIN

#include "sys/types.h"
#include "sys/stat.h"
#include "io.h"
#include "fcntl.h"
#include "share.h"
#include "mailer.h"
#include "xmisc.h"
#include "bbs.h"
#include "xbbs.h"

    extern ADDR *addresses;
    extern HWND xdhwnd;




MRESULT EXPENTRY SendDlgBoxProc (HWND hwndDlg,USHORT msg,
                                 MPARAM mp1,MPARAM mp2) {

    static USHORT   fline = 65535;
    static ADDR     saddr;
    static int      once = 0;

    switch(msg) {
        case WM_INITDLG:
            WinPostMsg(hwndDlg, WM_REFRESH, 0L, 0L);
            break;

        case WM_SETCP:
            fline = SHORT1FROMMP(mp1);
            return MRFROMSHORT(0);

        case WM_REFRESH:
            WinSendDlgItemMsg(hwndDlg, SM_SENDADDR, EM_SETTEXTLIMIT,
                              MPFROM2SHORT(80,0), NULL);
            WinSendDlgItemMsg(hwndDlg, SM_SENDFILE, EM_SETTEXTLIMIT,
                              MPFROM2SHORT(80,0), NULL);
            if(!once) {
                memset(&saddr,0,sizeof(ADDR));
                once++;
            }

            {
                char s[81];

                if(saddr.zone && *saddr.domain) {
                    sprintf(s,"%s#%u:%u/%u.%u",saddr.domain,saddr.zone,
                            saddr.net,saddr.node,saddr.point);
                }
                else {
                    *s = 0;
                }
                WinSetDlgItemText(hwndDlg,SM_SENDADDR,s);
                strset(s,0);
                WinSetDlgItemText(hwndDlg,SM_SENDFILE,s);
            }
            return MRFROMSHORT(0);

        case WM_CONTROL:
            return MRFROMSHORT(0);

        case WM_COMMAND:
            switch(SHORT1FROMMP(mp1)) {
                case SM_OK:
                    {
                        char   *p,s[82];
                        USHORT rc;

                        rc = WinQueryDlgItemText(hwndDlg, PM_POLLADDR, 80, s);
                        if (rc > 0) {
                            p = lstrip(rstrip(s));
                            DosEnterCritSec();
                            if(parse_addr(&p,&poll,addresses)) {
                                rc = WinQueryDlgItemText(hwndDlg, PM_POLLADDR, 80, s);
                                if (rc > 0) {
                                    if(!find_in_fidouser(0,(USHORT)-1,lstrip(rstrip(s)),&poll)) {
                                        memset(&poll,0,sizeof(ADDR));
                                        DosExitCritSec();
                                        DosBeep(100,100);
                                        break;
                                    }
                                }
                                else {
                                    memset(&poll,0,sizeof(ADDR));
                                    DosExitCritSec();
                                    DosBeep(100,100);
                                    break;
                                }
                            }
                            if(poll.zone && *poll.domain) {
                                 sprintf(s,"%s#%u:%u/%u.%u",poll.domain,
                                         poll.zone,poll.net,poll.node,
                                         poll.point);
                                if(fline != 65535) {
                                    DosSemSet(&pollnowSEM[fline]);
                                    DosExitCritSec();
                                    WinSetDlgItemText(hwndDlg,PM_POLLADDR,s);
                                    {
                                        int handle;
                                        char *fname;

                                        fname = (char *)malloc(1050);
                                        if(fname) {
                                          sprintf(fname,"%s/C.%u.%u.%u.%u.%s",
                                                  d_outbound,
                                                  poll.zone,poll.net,poll.node,
                                                  poll.point,poll.domain);
                                          handle = sopen(fname,O_RDWR | O_BINARY | O_CREAT,
                                                         SH_DENYNO,S_IWRITE | S_IREAD);
                                          free(fname);
                                        }
                                        else
                                          handle = -1;
                                        if(handle != -1)
                                          close(handle);
                                    }
                                    DosBeep(1000,2);
                                }
                                else DosExitCritSec();
                            }
                            else DosExitCritSec();
                        }
                    }
                    return MRFROMSHORT(1);

                case SM_CANCEL:
                    memset(&saddr,0,sizeof(ADDR));
                    WinPostMsg(xdhwnd, WM_SENDDOWN, 0L, 0L);
                    WinDismissDlg(hwndDlg, 0);
                    break;
            }

        case WM_CLOSE:
            WinPostMsg(xdhwnd,WM_SENDDOWN, 0L, 0L);
            WinDismissDlg(hwndDlg, 0);
            break;
    }

    return(WinDefDlgProc(hwndDlg, msg, mp1, mp2));
}
