/*  Macros for implementing simple timers.  All timers use 1000ths of
    a second, but are only 'accurate' to one clock tick. */

#ifdef USE_TIME_MACROS

clock_t timerset (clock_t tmt);
int     timeup (clock_t tmt);
// clock_t timeleft(clock_t tmt);

 #define timerset(tmt) (clock_t)((((clock_t)(tmt) * (clock_t)CLOCKS_PER_SEC) / 1000L) + clock())
 #define timeup(tmt) ((clock_t)(tmt) < clock())
// #define timeleft(tmt) (clock_t)((((clock_t)(tmt) - clock()) / (clock_t)CLOCKS_PER_SEC) * 1000L)

#else

clock_t _fastcall timerset (clock_t tmt);
int     _fastcall timeup (clock_t tmt);

#endif

clock_t _fastcall timeleft(clock_t tmt);
