#include <stdlib.h>
#include <string.h>
#include <ctype.h>



char * _fastcall rstrip (char *a) {   /* Remove trailing spaces and tabs */

  register int x;

  x = strlen(a);
  while(x && (a[x - 1] == ' ' || a[x - 1] == '\t'))
    a[--x] = 0;
  return a;
}


char * _fastcall lstrip (char *a) {   /* Remove leading spaces and tabs */

  register char *p = a;

  while(*p == ' ' || *p == '\t')
    p++;
  if(*p && p != a)
    memmove(a,p,strlen(p) + 1);
  else if(!*p)
    *a = 0;
  return a;
}


char * _fastcall stripcr (char *a) {  /* Remove trailing crs and lfs */

  register int x;

  x = strlen(a);
  while(x && (a[x - 1] == '\n' || a[x - 1] == '\r'))
    a[--x] = 0;
  return a;
}


char * _fastcall strip_trail_bksl (char *a) {  /* Remove trailing slashes */

  register int x;

  x = strlen(a);
  while (x && (a[x - 1] == '/' || a[x - 1] == '\\'))
    a[--x] = 0;
  return a;
}


char * _fastcall add_trail_bksl (char *a) {

  register int x = 0;

  if(*a) {
    x = strlen(a) - 1;
    if(a[x] != '\\' && a[x] != '/') {
      a[x + 1] = '\\';
      a[x + 2] = 0;
    }
  }
  else
    strcpy(a,"\\");
  return a;
}


char *  _fastcall strip_trail_char (char *strip,char *a) {

  register char *p;

  if(!a || !*a || !strip || !*strip)
    return a;
  p = &a[strlen(a) - 1];
  while (*a && strchr(strip,*p) != NULL) {
    *p = 0;
    p--;
  }
  return a;
}


char *  _fastcall strip_lead_char (char *strip,char *a) {

  register char *p = a;

  while(*p && strchr(strip,*p))
    p++;
  if(*p && p != a)
    memmove(a,p,strlen(p) + 1);
  else if(!*p)
    *a = 0;
  return a;
}



char * _fastcall convert_1_2_another (char one,char two,char *a) {

  register char *p = a;

  if(!p || !*p)
    return p;
  while(*p) {
    if(*p == one)
      *p = two;
    p++;
  }
  return a;
}

