/*------------------------------------------------------------------------*/
/* Values for the `flags' field                                           */
/*------------------------------------------------------------------------*/
#define B_hub    0x0001  /* node is a net hub     0000 0000 0000 0001 */
#define B_host   0x0002  /* node is a net host    0000 0000 0000 0010 */
#define B_region 0x0004  /* node is region coord  0000 0000 0000 0100 */
#define B_zone   0x0008  /* is a zone gateway     0000 0000 0000 1000 */
#define B_CM     0x0010  /* runs continuous mail  0000 0000 0001 0000 */
#define B_res1   0x0020  /* reserved by Opus      0000 0000 0010 0000 */
#define B_res2   0x0040  /* reserved by Opus      0000 0000 0100 0000 */
#define B_res3   0x0080  /* reserved by Opus      0000 0000 1000 0000 */
#define B_res4   0x0100  /* reserved by Opus      0000 0001 0000 0000 */
#define B_res5   0x0200  /* reserved for non-Opus 0000 0010 0000 0000 */
#define B_res6   0x0400  /* reserved for non-Opus 0000 0100 0000 0000 */
#define B_res7   0x0800  /* reserved for non-Opus 0000 1000 0000 0000 */
#define B_point  0x1000  /* node is a point       0001 0000 0000 0000 */
#define B_res9   0x2000  /* reserved for non-Opus 0010 0000 0000 0000 */
#define B_resa   0x4000  /* reserved for non-Opus 0100 0000 0000 0000 */
#define B_resb   0x8000  /* reserved for non-Opus 1000 0000 0000 0000 */

/*------------------------------------------------------------------------*/
/* Values for the `modem' field                                           */
/*------------------------------------------------------------------------*/
#define M_HST      0x01    /* node uses an HST                  0000 0001 */
#define M_PEP      0x02    /* node uses a PEP modem             0000 0010 */
#define M_V42b     0x04    /* node uses a V.42b modem           0000 0100 */
#define M_V42      0x08    /* node uses a V.42 modem            0000 1000 */
#define M_H96      0x10    /* node uses a Hayes V9600           0001 0000 */
#define M_V29      0x20    /* node uses a V.29 modem            0010 0000 */
#define M_V32      0x40    /* node uses a V.32 modem            0100 0000 */
#define M_V33      0x80    /* node uses a V.33 modem            1000 0000 */

/*--------------------------------------------------------------------------*/
/* Nodelist.Idx                                                             */
/* (File is terminated by EOF)                                              */
/*--------------------------------------------------------------------------*/
  struct nodeidx_ {
    unsigned int   node;          /* node number  */
    unsigned int   net;           /* net number   */
  };

  typedef struct nodeidx_ NODEIDX;

  struct real_nodeinfo_ {
    unsigned int  net;     /* net number */
    unsigned int  node;    /* node number, */
    int  cost;             /* cost per minute to call */
    char name[34];       /* node name */
    char phone[40];      /* phone number */
    char city[30];       /* city and state, */
    char password[8];    /* warning, not necessarily null terminated */
    int  realcost;         /* phone company's charge */
    unsigned int hubnode;  /* node # of this node's hub or 0 if none */
    unsigned char rate;    /* actual baud rate divided by 300 */
    char modem;            /* modem type code (see above) */
    unsigned int flags;    /* set of flags (see above) */
    int  reserved;       /* reserved */
  };

  typedef struct real_nodeinfo_ REAL_NODEINFO;

  struct nodeinfo_ {
    unsigned int  net;     /* net number */
    unsigned int  node;    /* node number, */
    int  cost;             /* cost per minute to call */
    char name[34];         /* node name */
    char phone[40];        /* phone number */
    char city[30];         /* city and state, */
    char password[9];      /* necessarily null terminated */
    int  realcost;         /* phone company's charge */
    unsigned int hubnode;  /* node # of this node's hub or 0 if none */
    unsigned char rate;    /* actual baud rate divided by 300 */
    char modem;            /* modem type code (see above) */
    unsigned int flags;    /* set of flags (see above) */
    int  reserved;         /* reserved */
  };

  typedef struct nodeinfo_ NODEINFO;


long       _fastcall read_nodelist (void);
NODEINFO * _fastcall get_node_from_list (NODEINFO *nif,unsigned int zone,
                                         unsigned int point,
                                         char *domain);
NODEINFO * _fastcall try_for_points (NODEINFO *nif,unsigned int zone,
                                     unsigned int point,
                                     char *domain,char *s);

NODEINFO * _fastcall ver7find (NODEINFO *nif,unsigned int zone,
                               unsigned int point,char *domain);

