#define MAXDATA       1024

#define IDADDR        0
#define REQUESTFILE   1
#define OPENFILE      2
#define DATAFILE      3
#define CHALLENGE     4
#define ABORTFILE     5
#define ABORTSESSION  6
#define SEEKFILE      7
#define ACKFILE       8
#define EOTFILE       9

typedef struct _preblock_ {   /* precedes a chunk of data/control block */
  USHORT type;
  USHORT handle;              /* 0 = none, 1 = stdin/out, 2-100 = reserved */
  USHORT datalen;
  ULONG  datacrc;
  USHORT blkcrc;
} PREBLOCK;

typedef struct _reqfile_ {    /* control block -- request a file */
  USHORT filenamelen;
  USHORT passwordlen;
  CHAR   datetime[16];
} REQFILE;

typedef struct _opendata_ {    /* control block -- send a file */
  ULONG  filelen;
  ULONG  attributes;
  USHORT filenamelen;
  USHORT passwordlen;
  CHAR   datetime[15];
} OPENDATA;

typedef struct _ackblk_ {      /* control block -- acknowledge receiving/received */
  USHORT filenamelen;
} ACKBLK;

int syncsendfile (USHORT cp,char *filename,char *password) {

  int      handle,success = 0,blksize = 128,temp;
  PREBLOCK pb;
  OPENDATA op;
  CHAR     data[MAXDATA + 1];

  handle = sopen(filename,O_RDONLY | O_BINARY,SH_DENYNO);
  if(!handle)
    return 0;
  op.filelen = filelength(handle);
  op.attributes = 0L;                   // fill in later
  op.filenamelen = strlen(filename);
  if(password)
    op.passwordlen = strlen(password);
  else
    op.passwordlen = 0;
  strset(op.datetime,0);                // fill in later
  com_write(cp,&op,sizeof(OPENDATA));
  if(!gotackblk(cp,filename)) {
    while(!eof(handle)) {
      temp = read(handle,data,blksize);
      if(!temp || temp == -1) {         // better later
        break;
      }
      com_write(
    }
    close(handle);
    return success;
  }
  close(handle);
  return 0;
}
