#include <io.h>
#include <share.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <errno.h>
#include "mailer.h"
#include "bbs.h"
#include "bitfuncs.h"
#include "xmisc.h"


    LIBAREA        *libareas    = NULL;
    LIBAREA        *libareatail = NULL;




int _fastcall load_libareas (void) {

    int     handle;
    char    ln[512];
    char    *p,*pp;
    LIBAREA *info;


    handle = sopen(searchpath("LIBAREAS.BB2",ln,511),O_NOINHERIT | O_RDONLY | O_BINARY,SH_DENYNO);
    if(handle == -1) {
        return 0;
    }

    while(!eof(handle)) {
        if(!fgetsx(ln,512,handle)) break;
        lstrip(ln);
        if(*ln == ';') continue;
        stripcr(ln);
        rstrip(ln);
        if(!*ln || *ln == '\x1a') continue;
        info = (LIBAREA *)malloc(sizeof(LIBAREA));
        if(!info) {

OutOfMemory:

            logfmain("Not enough memory to load all libareas");
            DosSleep(1000L);
            return -1;
        }

        memset(info,0,sizeof(LIBAREA));

        p = ln;
        pp = to_delim(p,",");
        *pp = 0;
        if(!*p) {
            info->name = NULL;
            goto BadArea;
        }
        info->name = strdup(ln);
        if(!info->name) {
            free(info);
            goto OutOfMemory;
        }

        p = ++pp;
        pp = to_delim(p,",");
        if(!*p) goto BadArea;
        *pp=0;
        info->age = atoi(p);

        p = ++pp;
        pp = to_delim(p,",");
        if(!*p) goto BadArea;
        *pp = 0;
        info->r_security1 = (unsigned long)atol(p);

        p = ++pp;
        pp = to_delim(p,",");
        if(!*p) goto BadArea;
        *pp = 0;
        info->r_security2 = (unsigned long)atol(p);

        p = ++pp;
        pp = to_delim(p,",");
        if(!*p) goto BadArea;
        *pp = 0;
        info->r_flags1 = (unsigned long)atol(p);

        p = ++pp;
        pp = to_delim(p,",");
        if(!*p) goto BadArea;
        *pp = 0;
        info->r_flags2 = (unsigned long)atol(p);

        p = ++pp;
        pp = to_delim(p,",");
        if(!*p) goto BadArea;
        *pp = 0;
        info->w_security1 = (unsigned long)atol(p);

        p = ++pp;
        pp = to_delim(p,",");
        if(!*p) goto BadArea;
        *pp = 0;
        info->w_security2 = (unsigned long)atol(p);

        p = ++pp;
        pp = to_delim(p,",");
        if(!*p) goto BadArea;
        *pp = 0;
        info->w_flags1 = (unsigned long)atol(p);

        p = ++pp;
        pp = to_delim(p,",");
        if(!*p) goto BadArea;
        *pp = 0;
        info->w_flags2 = (unsigned long)atol(p);

        p = ++pp;
        pp = to_delim(p,",");
        if(!*p) goto BadArea;
        *pp = 0;
        info->s_security1 = (unsigned long)atol(p);

        p = ++pp;
        pp = to_delim(p,",");
        if(!*p) goto BadArea;
        *pp = 0;
        info->s_security2 = (unsigned long)atol(p);

        p = ++pp;
        pp = to_delim(p,",");
        if(!*p) goto BadArea;
        *pp = 0;
        info->s_flags1 = (unsigned long)atol(p);

        p = ++pp;
        pp = to_delim(p,",");
        if(!*p) goto BadArea;
        *pp = 0;
        info->s_flags2 = (unsigned long)atol(p);

        p = ++pp;
        pp = to_delim(p,",");
        if(!*p) goto BadArea;
        *pp = 0;
        info->areaflags = (unsigned int)atoi(p);

        p = ++pp;
        pp = to_delim(p,",");
        if(!*p) goto BadArea;
        *pp = 0;
        info->number = (unsigned int)atoi(p);

        if(!info->number || info->number > 512) {

BadArea:
            logfmain("Invalid libarea %s",info->name);
            free(info->name);
            free(info);
            continue;
        }

        p = ++pp;
        pp = to_delim(p,",");
        if(!*p) info->path = NULL;
        else {
            *pp = 0;
            info->path = strdup(p);
            if(!info->path) {
                logfmain("Allocation for libarea %s path failed",info->name);
                free(info->name);
                free(info);
                continue;
            }
            while((p = strchr(info->path,'\\')) != NULL) *p = '/';
            while(*info->path && info->path[strlen(info->path) - 1] == '/') info->path[strlen(info->path) - 1] = 0;
            if(!*info->path) {
                logfmain("Bad path libarea %s",info->name);
                free(info->path);
                free(info->name);
                free(info);
                continue;
            }
        }

        p = ++pp;
        pp = to_delim(p,",");
        if(*pp) {
            *pp = 0;
            if(!*p) info->descr = NULL;
            else {
                *pp = 0;
                info->descr = strdup(p);
            }
            p = ++pp;
            pp = to_delim(p,",");
            if(*pp) {
                *pp = 0;
                if(!*p) info->password = NULL;
                else {
                    *pp = 0;
                    if(strlen(p) > 35) p[35] = 0;
                    info->password = strdup(p);
                    if(!info->password) {
                        logfmain("Allocation for password, libarea %s, failed.",info->name);
                        logfmain("Removing area from memory for security.");
                        if(info->descr) free(info->descr);
                        if(info->path) free(info->path);
                        free(info->name);
                        free(info);
                        continue;
                    }
                }
            }
        }

        if(!libareas) {
            libareas = info;
            libareatail = info;
            info->prior = NULL;
        }
        else {
            libareatail->next = info;
            info->prior = libareatail;
            libareatail = info;
        }
        info->next = NULL;
    }

    close(handle);
    return 0;
}
