#include <io.h>
#include <fcntl.h>
#include <share.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <ctype.h>
#include "mailer.h"
#include "bbs.h"
#include "xmisc.h"

    extern USER      *user[MAXINSTANCES];
    extern COMPTYPES *computer;


int _pascal list_users (int mode,USHORT cp,char *matchstr,int type) {

    /* type bitmap:
        1:  no verbose
        2:  end after match found
    */

    int  handle,lines = 0,temp,usz;
    USER *info;
    word x = 0;
    char *ct;
    char cts[33];

    handle = bbs_sopen(cp,"USERS.BB2",O_NOINHERIT | O_RDONLY | O_BINARY,SH_DENYNO);
    if(handle == -1) {
        dputs(mode,cp,"\r\nUnable to open user file...\r\n");
        DosSleep(1000L);
        return 0;
    }

    info = bbs_malloc(cp,sizeof(USER));
    if(!info) {
        dputs(mode,cp,"\r\nOut of memory.\r\n");
        bbs_close(cp,handle);
        return 0;
    }
    memset(info,0,sizeof(USER));

    if(matchstr && *matchstr) logfunc(0,cp,"Listing users \"%s\"",matchstr);
    else logfunc(0,cp,"Listing users");

    if(matchstr && *matchstr) dputs(mode,cp,"\r\nSearching...\r\n");

    while(!eof(handle)) {
        DosSleep(1L);
        usz = read(handle,info,sizeof(USER) - USERSUB);
        if(usz == -1 || usz < sizeof(USER) - USERSUB) break;
        if((info->attribs & U_DELETED) || (info->attribs & U_POINTONLY) ||
           (info->attribs & U_LOCKEDOUT) || (info->attribs & U_LISTPROTECTED))
           continue;
        if(user[cp]->offline < time(NULL)) break;
        if(matchstr && *matchstr) {

            char *find = NULL;

            find = stristr(info->handle,matchstr);
            if(!find) find = stristr(info->interests,matchstr);
            if(!find && (info->attribs & U_NOSHOWREAL))
              find = stristr(info->name,matchstr);
            if(!find && (info->attribs & U_NOSHOWPHONE))
              find = stristr(info->phone_number,matchstr);
            if(!find && (info->attribs & U_NOSHOWADDRESS))
              find = stristr(info->address,matchstr);
            if(!find) continue;
        }
        if(!(type & 1)) { /* verbose */
            if(info->attribs & U_NOSHOWREAL) {
                dprintf(mode,cp,"\r\n%-36s  (%s)\r\n",info->name,info->handle);
            }
            else dprintf(mode,cp,"\r\nHandle: %s\r\n",info->handle);
            if(info->attribs & U_NOSHOWPHONE) {
                dprintf(mode,cp," Phone: %s\r\n",info->phone_number);
                lines++;
            }
            if(info->attribs & U_NOSHOWADDRESS) {
                dprintf(mode,cp," Address:\r\n%s\r\n",info->address);
                lines++;
            }
            dprintf(mode,cp," Interests:\r\n%s\r\n",info->interests);
            ct = find_computer(info->computer_type);
            if(!ct) {
                sayp(mode,cp,132,cts,32);
                ct = cts;
            }
            dprintf(mode,cp," Computer type: %-24.24s  Birthday: %u/%02hu/%02hu\r\n",
                    ct,info->birthyear,info->birthmonth,info->birthday);
            dprintf(mode,cp," Initial logon: %0.24s\r\n",asctime(localtime(&info->initial_logon)));
            dprintf(mode,cp," Last logon: %0.24s\r\n",asctime(localtime(&info->last_logon)));
            dprintf(mode,cp," #calls: %lu  #posts: %lu",info->numcalls,info->numposts);
            lines += 7;
        }
        else {
            dprintf(mode,cp,"\r\n%-36s %0.24s  #calls: %lu",info->handle,asctime(localtime(&info->last_logon)),info->numcalls);
            lines++;
        }
        x++;
        if(matchstr && *matchstr && (type & 2)) break;
        if(lines + (((type & 1) == 0) * 7) > (int)(user[cp]->length - 2) && !eof(handle)) {
            dputs(mode,cp,"\r\n");
            if(do_more(mode,cp)) break;
            lines = 0;
        }
        else {
            temp = inkey(mode,cp);
            if(temp) {
                temp = toupper(temp);
                if(temp == 'S' || temp == ' ' || temp == 11) break;
                else if(temp == 'P' || temp == 19) {
                    mpause(mode,cp);
                    lines = 0;
                }
            }
        }
    }

    if(matchstr && *matchstr && !x) {
        dputs(mode,cp,"\r\nNo match found.");
    }
    bbs_close(cp,handle);
    bbs_free(cp,info);

    return (int)x;
}




int _pascal ask_list_users (int mode,USHORT cp) {

    char buf[80];
    char verbose[3];
    int temp;

    strset(buf,0);
    strset(verbose,0);
    input_string(mode,cp,buf,78,4,
                 "\r\nEnter a search string or [Enter] for all:\r\n",
                 STRT_ALL,STRF_NEAT,
                 "User Search",NULL);
    input_string(mode,cp,verbose,1,1,
                 "\r\nVerbose listing? (y/N) ",
                 STRT_YN,STRF_UCASE | STRF_HOT,
                 "Verbose User",NULL);
    dputs(mode,cp,"\r\n");

    lstrip(rstrip(buf));
    temp = list_users(mode,cp,buf,(*verbose != 'Y'));
    if(temp) {
        dputs(mode,cp,"\r\n");
        hitreturn(mode,cp);
    }
    return temp;
}



char * _fastcall find_computer (int comptype) {

    COMPTYPES   *info = computer;
    int         x = 1;

    if(!comptype)
      return NULL;
    while(info) {
        if(x == comptype)
          return info->name;
        x++;
        info = info->next;
    }
    return NULL;
}
