#include <io.h>
#include <fcntl.h>
#include <share.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <ctype.h>
#include "mailer.h"
#include "bbs.h"
#include "xmisc.h"



 typedef struct __line__ {
   char text[77];
   char term;
 } ELINE;

 extern MDM   *modems[MAXINSTANCES];
 extern USER  *user[MAXINSTANCES];

#define MAX_NUM_LINES 250

static void _fastcall  show_ruler (int mode, USHORT cp, int len);
static int _fastcall   menu (int mode,USHORT cp,int lastline);
static void _fastcall  enter (int mode,USHORT cp,int *lastline,
                              ELINE *lines, unsigned int type);





int _fastcall line_editor (int mode,USHORT cp,char *filename,
                           unsigned int flags,XMSG *msg) {

    ELINE        *lines;
    int          lastline = 0;
    int          choice;
    int          handle;
    register int x;
    char         input[8];
    struct stat  st;
    char         msgfilename[13];


    sprintf(msgfilename,"MSGTMP%u",cp);
    lines = (ELINE *)bbs_malloc(cp,MAX_NUM_LINES * sizeof(ELINE));
    if(!lines) {
        sayp(mode,cp,159,NULL,0);
        return -1;
    }
    memset(lines,0,MAX_NUM_LINES * sizeof(ELINE));

    cls(mode,cp);
    sayp(mode,cp,160,NULL,0);

    if(stricmp(filename,msgfilename)) {
        if(stat(filename,&st)) {
            dputs(mode,cp,filename);
            sayp(mode,cp,161,NULL,0);
        }
        else {
            handle = bbs_sopen(cp,filename,O_NOINHERIT | O_RDWR | O_BINARY, SH_DENYWR);
            if(handle == -1) {
                sayp(mode,cp,162,NULL,0);
                dprintf(mode,cp,"%s\r\n",filename);
                return -1;
            }
            else {
                while(!eof(handle) && lastline<MAX_NUM_LINES-2) {
                    if(!fgetsx(lines[lastline].text,81,handle)) {
                        memset(lines[lastline].text,0,81);
                        break;
                    }
                    lastline++;
                }
                if(!eof(handle)) {
                    sayp(mode,cp,163,NULL,0);
                    dprintf(mode,cp,"%s\r\n",filename);
                }
                bbs_close(cp,handle);
            }
        }
    }
    else if(msg) {
        sayp(mode,cp,165,NULL,0);
        dprintf(mode,cp,"%-35.35s",msg->to);
        sayp(mode,cp,164,NULL,0);
        dprintf(mode,cp,"%s\r\n",msg->from);
        sayp(mode,cp,166,NULL,0);
        dprintf(mode,cp,"%s\r\n",msg->subj);
    }

    show_ruler(mode,cp,min(78,user[cp]->width - 1));
    enter(mode,cp,&lastline,lines,0);

    for(;;) {
        choice = menu(mode,cp,lastline);
        switch (choice) {
            case 0: if(!lastline && !*lines[lastline].text) {  /* List */
                        sayp(mode,cp,170,NULL,0);
                        break;
                    }
                    strcpy(input,"1");
                    dprintf(mode,cp,"\r\n%d line%s",lastline + 1,&"s"[lastline == 0]);
                    if(!*pinput_string(mode,cp,input,3,1,171,
                                      STRT_NUMERIC,0,"Text delete",NULL))
                        break;
                    choice = atoi(input);
                    if(choice > (int)lastline + 1 || choice < 1) break;
                    choice--;
                    for(x = choice;x < (lastline + 1);x++) {
                        dprintf(mode,cp,"\r\n%03u: %s",x + 1,lines[x].text);
                        if(inkey(mode,cp) == ' ') break;
                    }
                    dputs(mode,cp,"\r\n");
                    break;

            case 1: show_ruler(mode,cp,min(75,user[cp]->width - 1));  /* Continue */
                    enter(mode,cp,&lastline,lines,0);
                    break;

            case 2: strset(input,0);                            /* Quit/Abort */
                    if(!*pinput_string(mode,cp,input,1,1,172,
                                      STRT_YN,STRF_HOT,"Are you sure",NULL))
                        break;
                    dputs(mode,cp,"\r\n");
                    if(*input != modems[cp]->YES) break;
                    bbs_free(cp,lines);            /* Quit/Abort */
                    if(!stricmp(filename,msgfilename)) unlink(filename);
                    return -2;

            case 3: memset(lines,0,MAX_NUM_LINES * sizeof(ELINE));
                    lastline = 0;             /* New buffer */
                    show_ruler(mode,cp,min(75,user[cp]->width-1));
                    enter(mode,cp,&lastline,lines,0);
                    break;

            case 4: dprintf(mode,cp,"\r\n%d line%s",lastline + 1,&"s"[lastline == 0]);
                    strset(input,0);        /* Edit (retype) line */
                    if(!*pinput_string(mode,cp,input,3,1,173,
                                      STRT_NUMERIC,0,"Text edit",NULL))
                        break;
                    choice = atoi(input);
                    if(choice > lastline + 1 || choice < 1) break;
                    choice--;
                    enter(mode,cp,&choice,lines,1);
                    break;

            case 5: dprintf(mode,cp,"\r\n%d line%s",lastline + 1,&"s"[lastline == 0]);
                    sprintf(input,"%u",lastline+1);  /* Delete line */
                    if(!*pinput_string(mode,cp,input,3,1,174,
                                      STRT_NUMERIC,0,"Text delete",NULL))
                        break;
                    choice = atoi(input);
                    if(choice > lastline + 1 || choice < 1) break;
                    choice--;
                    memmove(&lines[choice],&lines[choice + 1],
                        sizeof(ELINE) * (MAX_NUM_LINES - (choice + 1)));
                    memset(&lines[MAX_NUM_LINES-1],0,sizeof(ELINE));
                    lastline--;
                    break;

            case 6: dprintf(mode,cp,"\r\n%d line%s",lastline + 1,&"s"[lastline == 0]);
                    strset(input,0);            /* Insert line */
                    if(!*pinput_string(mode,cp,input,3,1,175,
                                      STRT_NUMERIC,0,"Text insert",NULL))
                        break;
                    choice = atoi(input);
                    if(choice > lastline + 1 || choice < 1) break;
                    choice--;
                    memmove(&lines[choice + 1],&lines[choice],
                        sizeof(ELINE) * (MAX_NUM_LINES - (choice)));
                    memset(&lines[choice],0,sizeof(ELINE));
                    enter(mode,cp,&choice,lines,1);
                    break;

             case 7: if(!lastline && !*lines[lastline].text) {  /* Save */
                       sayp(mode,cp,176,NULL,0);
                       break;
                     }
                     if(!stricmp(filename,msgfilename)) {
                       unlink(filename);
                       handle = bbs_sopen(cp,filename,O_NOINHERIT | O_RDWR | O_BINARY | O_CREAT,SH_DENYNO,S_IWRITE);
                       if(handle == -1) {
                         sayp(mode,cp,177,NULL,0);
                         dprintf(mode,cp,"%s\r\n",filename);
                         break;
                       }
                       for(x = 0;x < lastline + 1;x++) {
                         ffprintf(handle,"%s",lines[x].text);
                         if(lines[x].term)
                           write(handle,"\r",1);
                         else if(strchr(".?!:",lines[x].text[strlen(lines[x].text) - 1]))
                           write(handle,"  ",2);
                         else
                           write(handle," ",1);
                       }
                       bbs_close(cp,handle);
                       goto BreakOut;
                     }
                     else {
                       unlink(filename);
                       handle = bbs_sopen(cp,filename,O_NOINHERIT | O_RDWR | O_BINARY | O_CREAT,SH_DENYNO,S_IWRITE);
                       if(handle == -1) {
                         sayp(mode,cp,177,NULL,0);
                         dprintf(mode,cp,"%s\r\n",filename);
                         break;
                       }
                       for(x = 0;x < lastline + 1;x++) {
                         ffprintf(handle,"%s\r\n",lines[x].text);
                       }
                       bbs_close(cp,handle);
                       sayp(mode,cp,178,NULL,0);
                     }
                     break;

            case 8: if(!msg || stricmp(filename,msgfilename)) {
                        sayp(mode,cp,179,NULL,0);
                        break;
                    }
                    if(!(flags & E_NOTO)) {
                        if(!*pinput_string(mode,cp,msg->to,35,3,180,STRT_ALL,
                                      STRF_REQUIRED | STRF_PRETTY,"Msg To",
                                      NULL))
                            break;
                    }
                    if(!(flags & E_NOFROM)) {
                        if(!*pinput_string(mode,cp,msg->from,35,3,181,STRT_ALL,
                                      STRF_REQUIRED | STRF_PRETTY,"Msg From",
                                      NULL))
                            break;
                    }
                    if(!(flags & E_NOSUBJ)) {
                        if(!*pinput_string(mode,cp,msg->subj,59,3,182,STRT_ALL,
                                      STRF_REQUIRED | STRF_PRETTY,"Msg Subj",
                                      NULL))
                            break;
                    }
                    dputs(mode,cp,"\r\n");
                    break;
        }
    }

BreakOut:

    dputs(mode,cp,"\r\n");
    bbs_free(cp,lines);
    return 0;
}




static void _fastcall enter (int mode,USHORT cp,int *lastline,
                             ELINE *lines,unsigned int type) {

    char         pmpt[20];
    char         *p,*pp;
    int          waslen;
    register int x;
    int          y;
    char         temp[81];


  while(*lastline < (MAX_NUM_LINES-2)) {
    lines[*lastline].term = 1;
    if(user[cp]->attribs & U_COLOR)
      sprintf(pmpt,"\x1b[0;1;33m\r\n%03u: ",(*lastline) + 1);
    else
      sprintf(pmpt,"\r\n%03u: ",(*lastline) + 1);
    if(!*input_string(mode,cp,lines[*lastline].text,min(74,user[cp]->width - 2),1,pmpt,
                      STRT_ALL,(type == 0 ? STRF_MUSTHOT | STRF_EDIT | STRF_NOHELP : STRF_EDIT | STRF_NOHELP),
                      "",NULL))
      break;

    if(type != 0) break;

    if(!strnicmp(lines[*lastline].text," * Origin: ",11) ||
      *lines[*lastline].text == '\01' ||
      !stricmp(lines[*lastline].text,"---") ||
      !strnicmp(lines[*lastline].text,"--- ",4)) {
      quiet_bell(mode,cp,1);
      sayp(mode,cp,183,NULL,0);
      continue;
    }

    y = strlen(lines[*lastline].text);
    if(y > 10) {

      int numexclaim = 0,numlower = 0,wasalpha = 0;

      for(x = 0;x < y;x++) {
        if(islower(lines[*lastline].text[x]))
          numlower++;
        if(lines[*lastline].text[x] == '!')
          numexclaim++;
        if(isalpha(lines[*lastline].text[x]))
          wasalpha++;
      }
      if(!numlower && wasalpha) {
        quiet_bell(mode,cp,1);
        sayp(mode,cp,184,NULL,0);
        quiet_bell(mode,cp,1);
      }
      else if(numexclaim > 3) {
        quiet_bell(mode,cp,1);
        sayp(mode,cp,185,NULL,0);
      }
    }

    waslen = 0;
    if(*lastline < (MAX_NUM_LINES - 1)) {
      waslen = strlen(lines[*lastline].text);
      if(waslen == min(74,user[cp]->width - 2))
        lines[*lastline].term = 0;
      rstrip(lines[*lastline].text);
      if(strchr(lines[*lastline].text,' ')) {
        if((int)strlen(lines[*lastline].text) >= min(74,user[cp]->width - 2)) {
          for(x = 0;x < (waslen - strlen(lines[*lastline].text));x++)
            dputs(mode,cp,BACKSPACE);
          lines[*lastline].term = 0;
          strset(temp,0);
          pp = temp;
          p = &lines[*lastline].text[strlen(lines[*lastline].text) - 1];
          while(p > lines[*lastline].text && *p != ' ') {
            dputs(mode,cp,BACKSPACE);
            *pp = *p;
            *p = 0;
            pp++;
            *pp = 0;
            p--;
          }
          strrev(temp);
          strcpy(lines[(*lastline) + 1].text,temp);
        }
      }
      (*lastline)++;
    }
    else
      sayp(mode,cp,186,NULL,0);
  }
  if(!*lines[*lastline].text && *lastline)
    (*lastline)--;
}


static void _fastcall show_ruler (int mode, USHORT cp, int len) {

    char ruler[] = "\r\n    [----+----1----+----2----+----3----+----4----+----5----+----6----+----7----+----8";

    ruler[len] = 0;
    if(user[cp]->attribs & U_COLOR) {
        dputs(mode,cp,"\x1b[0;2;37m");
    }
    dputs(mode,cp,ruler);
    dputs(mode,cp,"]");
}





static int _fastcall menu (int mode,USHORT cp, int lastline) {

    int input;

    #define MENU_NUMCMDS 9

    for(;;) {
        input = pselect_one(mode,cp,187,MENU_NUMCMDS,188,NULL,"Edit Cmd",set_iflg(cp));
        if(input < 0) {
            sayp(mode,cp,189,NULL,0);
            continue;
        }
        return input;
    }
}
