/***************************************************************

   Copyright 1993-95  Northeast Data Corp.  All Rights Reserved

****************************************************************/

/***************************************************************


   CSlider.cpp

   Class implementation for MFC applications that use the slider.
   Version 3.0, November 1994, Wade Cobb & Paul King

****************************************************************/

#include "stdafx.h"
#include "cslider.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

//Init static variables
HINSTANCE CSlider::m_hDLL;
long CSlider::m_uiRefCount;

CSlider::CSlider(int nX, int nY, int nWidth, int nHeight, DWORD dwType)
{
	//Init all of our variables
	m_nX = nX;
	m_nY = nY;
	m_nWidth = nWidth;
	m_nHeight = nHeight;
	m_dwStyle = WS_CHILD | WS_VISIBLE | dwType | SCS_TABSTOP;
	m_hWnd = NULL;
	m_bDirection = FALSE;
	m_nInnerBevelStyle =  SCS_NONE;
	m_nOuterBevelStyle =  SCS_FRAME;
	m_nTickStyle = SCTICK_NORMAL;
	m_pcbmpThumb = NULL;
	m_pcbmpBack = NULL;
	m_pcbmpFocus = NULL;

	//See if the DLL is loaded yet
	if (NULL == m_hDLL)
	{
		m_hDLL = LoadLibrary("slider32.dll");
 		
		if (NULL == m_hDLL)
		{
			m_bValid = FALSE;
		}
		else
		{
			m_bValid = TRUE;
		}
	}
	
	//Even though we may not be valid, we still have a reference
	InterlockedIncrement(&m_uiRefCount);
}

CSlider::~CSlider()
{
	//Destroy the window
	::DestroyWindow(m_hWnd);

	//In case we have some bitmap objects...
	if (NULL != m_pcbmpThumb)
	{
		m_pcbmpThumb->DeleteObject();
		delete m_pcbmpThumb;
		m_pcbmpThumb = NULL;
	}

	if (NULL != m_pcbmpBack)
	{
		m_pcbmpBack->DeleteObject();
		delete m_pcbmpBack;
		m_pcbmpBack = NULL;
	}

	if (NULL != m_pcbmpFocus)
	{
		m_pcbmpFocus->DeleteObject();
		delete m_pcbmpFocus;
		m_pcbmpFocus = NULL;
	}

	//Push our reference count down
	if (0 == InterlockedDecrement(&m_uiRefCount))
	{
		//No one has a reference to us any longer, free the library
		if (NULL != m_hDLL)
		{
			FreeLibrary(m_hDLL);
		}
	}
}

BOOL CSlider::IsValid()
{
	return m_bValid;
}


BOOL CSlider::Create(CWnd *pParent, UINT uiID, short sMin, short sMax, 
	short sPos)
{
	//Make sure that one class is not being created twice
	//And that our variables has correct
	ASSERT(NULL == m_hWnd);
	ASSERT(NULL != pParent);
	ASSERT(::IsWindow(pParent->m_hWnd));

	//We need to see if this ID has already been used
	ASSERT(NULL == ::GetDlgItem(pParent->m_hWnd, uiID));

	//Create our window
	m_hWnd = ::CreateWindow("slider","", m_dwStyle, m_nX, m_nY,
		m_nWidth, m_nHeight, pParent->m_hWnd, (HMENU) uiID,
		AfxGetInstanceHandle(), NULL);

	if (NULL == m_hWnd)
	{
		//This didn't work
		return FALSE;
	}

	//Styles and other stuff
	SetRange(MAKELONG(sMin,sMax));
	SetPos(sPos);
	SetInnerBevelStyle(m_nInnerBevelStyle);
	SetOuterBevelStyle(m_nOuterBevelStyle);
	SetTickStyle(m_nTickStyle);

	//Show it
	::ShowWindow(m_hWnd, SW_SHOW);
	return TRUE;
}

void CSlider::MoveWindow(int nX, int nY, int nWidth, int nHeight, 
	BOOL bRepaint)
{
	ASSERT(::IsWindow(m_hWnd));
	::MoveWindow(m_hWnd, nX, nY, nWidth, nHeight, bRepaint);
}

void CSlider::MoveWindow(LPRECT pRect, BOOL bRepaint)
{
	MoveWindow(pRect->left, pRect->top, (pRect->right - pRect->left),
		(pRect->bottom - pRect->top), bRepaint);
}

void CSlider::GetWindowRect(LPRECT pRect)
{
	ASSERT(::IsWindow(m_hWnd));
	::GetWindowRect(m_hWnd, pRect);
}

short CSlider::GetPos()
{
	ASSERT(::IsWindow(m_hWnd));
	return (short) LOWORD(::SendMessage(m_hWnd, SCM_GETPOS, 0, 0));
}

short CSlider::SetPos(short sPos)
{
	ASSERT(::IsWindow(m_hWnd));
	return (short) LOWORD(::SendMessage(m_hWnd, SCM_SETPOS, MAKELONG(sPos,0),
		 0));
}

long CSlider::GetRange()
{
	ASSERT(::IsWindow(m_hWnd));
	return ::SendMessage(m_hWnd, SCM_GETRANGE, 0, 0);
}

long CSlider::SetRange(long lRange)
{
	ASSERT(::IsWindow(m_hWnd));
	return ::SendMessage(m_hWnd, SCM_SETRANGE, 0, lRange);
}

void CSlider::SetDirection(BOOL bReverse)
{
	ASSERT(::IsWindow(m_hWnd));
	::SendMessage(m_hWnd, SCM_CHANGEDIRECTION, 0, bReverse);
	m_bDirection = bReverse;
}

BOOL CSlider::GetDirection()
{
	return m_bDirection;
}

void CSlider::SetInnerBevelStyle(int nStyle)
{
	ASSERT(::IsWindow(m_hWnd));
	ASSERT((nStyle >= SCS_NONE) && (nStyle <= SCS_FRAME)); 
	::SendMessage(m_hWnd, SCM_SETBEVELSTYLE, SCBEVEL_INNER, nStyle); 
	m_nInnerBevelStyle = nStyle;
}

int CSlider::GetInnerBevelStyle()
{
	return m_nInnerBevelStyle;
}

void CSlider::SetOuterBevelStyle(int nStyle)
{
	ASSERT(::IsWindow(m_hWnd));
	ASSERT((nStyle >= SCS_NONE) && (nStyle <= SCS_FRAME)); 
	::SendMessage(m_hWnd, SCM_SETBEVELSTYLE, SCBEVEL_OUTER, nStyle); 
	m_nOuterBevelStyle = nStyle;
}

int CSlider::GetOuterBevelStyle()
{
	return m_nOuterBevelStyle;
}

void CSlider::SetTickStyle(int nStyle)
{
	ASSERT(::IsWindow(m_hWnd));
	ASSERT((nStyle >= SCTICK_NORMAL) && (nStyle <= SCTICK_RAISED)); 
	::SendMessage(m_hWnd, SCM_SETTICKSTYLE, nStyle, 0); 
	m_nTickStyle = nStyle;
}

int CSlider::GetTickStyle()
{
	return m_nTickStyle;
}

void CSlider::SetBorderWidth(int nWidth)
{
	ASSERT(::IsWindow(m_hWnd));
	::SendMessage(m_hWnd, SCM_SETWIDTH, SCBORDER, nWidth);
}

void CSlider::SetInnerBevelWidth(int nWidth)
{
	ASSERT(::IsWindow(m_hWnd));
	::SendMessage(m_hWnd, SCM_SETWIDTH, SCBEVEL_INNER, nWidth);
}

void CSlider::SetOuterBevelWidth(int nWidth)
{
	ASSERT(::IsWindow(m_hWnd));
	::SendMessage(m_hWnd, SCM_SETWIDTH, SCBEVEL_OUTER, nWidth);
}

void CSlider::SetThumbBitmap(UINT uiID)
{
	if (NULL != m_pcbmpThumb)
	{
		m_pcbmpThumb->DeleteObject();
		delete m_pcbmpThumb;
		m_pcbmpThumb = NULL;
	}

	if (0 != uiID)
	{
		m_pcbmpThumb = new CBitmap();
		if (FALSE == m_pcbmpThumb->LoadBitmap(uiID))
		{
			delete m_pcbmpThumb;
			m_pcbmpThumb = NULL;
		}
	}

	HBITMAP hBmp = NULL;

	if (NULL != m_pcbmpThumb)
	{
		hBmp = (HBITMAP) m_pcbmpThumb->GetSafeHandle();
	}
	
	::SendMessage(m_hWnd, SCM_SETBITMAP, SCB_THUMB, (LPARAM) hBmp);
}

BOOL CSlider::IsThumbBitmapSet()
{
	return (NULL != m_pcbmpThumb);
}

void CSlider::SetBackBitmap(UINT uiID)
{
	if (NULL != m_pcbmpBack)
	{
		m_pcbmpBack->DeleteObject();
		delete m_pcbmpBack;
		m_pcbmpBack = NULL;
	}

	if (0 != uiID)
	{
		m_pcbmpBack = new CBitmap();
		if (FALSE == m_pcbmpBack->LoadBitmap(uiID))
		{
			delete m_pcbmpBack;
			m_pcbmpBack = NULL;
		}
	}

	HBITMAP hBmp = NULL;

	if (NULL != m_pcbmpBack)
	{
		hBmp = (HBITMAP) m_pcbmpBack->GetSafeHandle();
	}
	
	::SendMessage(m_hWnd, SCM_SETBITMAP, SCB_BEZEL, (LPARAM) hBmp);
}

BOOL CSlider::IsBackBitmapSet()
{
	return (NULL != m_pcbmpBack);
}

void CSlider::SetFocusBitmap(UINT uiID)
{
	if (NULL != m_pcbmpFocus)
	{
		m_pcbmpFocus->DeleteObject();
		delete m_pcbmpFocus;
		m_pcbmpFocus = NULL;
	}

	if (0 != uiID)
	{
		m_pcbmpFocus = new CBitmap();
		if (FALSE == m_pcbmpFocus->LoadBitmap(uiID))
		{
			delete m_pcbmpFocus;
			m_pcbmpFocus = NULL;
		}
	}

	HBITMAP hBmp = NULL;

	if (NULL != m_pcbmpFocus)
	{
		hBmp = (HBITMAP) m_pcbmpFocus->GetSafeHandle();
	}
	
	::SendMessage(m_hWnd, SCM_SETBITMAP, SCB_THUMBFOCUS, (LPARAM) hBmp);
}

BOOL CSlider::IsFocusBitmapSet()
{
	return (NULL != m_pcbmpFocus);
}
