/* Bummer 2.0 installation program */

  Call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'	/* Make REXX functions available */
  Call SysLoadFuncs

  Parse Arg InstallDir     					/* Command line parameter */
  Signal On Halt Name ErrorHandler       			/* Error handler */

  Call SysCls
  Say
  Say
  Say " Bummer! 2.0 Installation "
  Say " ------------------------ "

  If InstallDir=" " Then Do					/* If no path is given, get one from the user */
    Say
    Say " Please specify the name of the subdirectory to"
    Say " which you would like to install Bummer!, hit <Enter>"
    Say " to use the current directory, or type 'Q'<Enter>"
    Say " to quit."
    Say
    Say " For Example     C:\GAMES\BUMMER<Enter>"
    Say
    Say " Please specify:"					/* Prompt for input */

    Parse Value SysCurPos() with Row Col
    Col=Col+17
    Row=Row-1
    Call SysCurPos Row, Col
    Pull InstallDir
    If (InstallDir="Q")|(InstallDir="q") Then Exit		/* Quit if they hit 'Q' */
  End

  Say								/* Give a nice blank line */

  CurrentDir = directory()					/* Find the current directory */
  
  If (InstallDir=" ") Then InstallDir=CurrentDir		/* Set to the current directory if none given */

   If (CurrentDir\=directory(InstallDir)) Then Do                /* If installing to different dir, do copying bit */
    Command = '@CD 'directory(CurrentDir)			/* Switch back to installation dir */
    Command

    Call SysFileTree InstallDir, FileDirectory, 'D'		/* Search for new directory */

    If FileDirectory.0='0' Then Do				/* If not found, create it */
      Say " Now creating directory "InstallDir" . . ."
      rc=SysMkDir(InstallDir)
      If rc\=0 Then Do
	Say
	Say " UURGH! Sorry, the desired directory couldn't be created,"
	Say " probably because you specified an invalid directory name"
	Say " or the destination disk is write-protected.  Please re-run"
        Say " this command file and try again."
	Exit
      End
    End

    Say " Now copying files to "InstallDir" . . ."          			/* Now copy files */
    Call FileCopy 'INSTALL.CMD', InstallDir
    Call FileCopy 'BUMMER.*', InstallDir
    Call FileCopy 'README.TXT', InstallDir
    Call FileCopy '*.WAV', InstallDir
    Call FileCopy '*.BSG', InstallDir
  End

  Say " Now creating/updating WPS program object . . ."			/* Now create/update the Desktop object*/                                       

  LastChar = substr(InstallDir,length(InstallDir),1)			/* See if directory terminates in a \ */

  If LastChar = "\" Then SetupString="EXENAME="InstallDir"BUMMER.EXE;STARTUPDIR="InstallDir
  Else SetupString="EXENAME="InstallDir"\BUMMER.EXE"; InstallDir=InstallDir"\"

  If SysCreateObject("WPFolder", "Bummer!", "<WP_DESKTOP>","OBJECTID=<MYFOLDER>") Then Do
     
  If SysCreateObject("WPProgram", "Bummer! 2.0", "<MYFOLDER>",SetupString, UPDATE) then
     Say "Bummer program object successfully created"
  else
     Say "Could not create program object."

  If SysCreateShadow(InstallDir"Game1.bsg", "<MYFOLDER>") then
     Say "Shadow of Game1.bsg Successfully created."
  else
     Say "Could not create shadow of Game1.bsg"

  if SysCreateShadow(InstallDir"Game2.bsg", "<MYFOLDER>") then
     Say "Shadow of Game2.bsg Successfully created."
  else
     Say "Could not create shadow of game2.bsg"

  if SysCreateShadow(InstallDIr"Readme.txt", "<MYFOLDER>") then
     Say "Shadow of readme.txt Successfully.created."
  else
     Say "Could not create shadow of readme.txt"
  End
  else
     Say "Could not create folder on the desktop"

    
  
  Say " Now you get to read the README.TXT file . . ."

  Command='@E README.TXT'            /* Look at the README.TXT */
  Command

  Say
  Say " All Right!  Bummer 2.0 has been installed successfully!"

  Exit


/******* FileCopy procedure */

  FileCopy: Arg FileName, Destination
    
    Command='@Copy 'FileName' 'Destination' >NUL'
    Command
    If rc\=0 Then Do               /* Error copying file */
      Say
      Say " AAAGH! Error copying files. This is probably because"
      Say " the destination disk is write protected (a CD-ROM, for"
      Say " example) or a file is missing.  Please make sure that"
      Say " this program can find all the files listed in the"
      Say " README.TXT file and ensure that the destination disk"
      Say " isn't write protected, and try again."
      Exit
    End
    Return


/******* ErrorHandler procedure */

  ErrorHandler:

    Call SysCls
    Say " EEEEWWWW! Unknown error! - aborting installation . . ."
  Exit

