' Truchet Tilings
' Written by Scott Edwards
' Copyright (C) June 1994
' Falsoft, Inc.
' PCM

DECLARE SUB Tile3 ()
DECLARE SUB Tile4 ()
DECLARE SUB Tile2 ()
DECLARE SUB Tile1 ()
DEFINT A-Z
DIM SHARED UpLeftX AS INTEGER
DIM SHARED UpLeftY AS INTEGER
CONST theColor = 8
CONST tileSize = 6

SCREEN 12: CLS
RANDOMIZE TIMER

FOR UpLeftY = 0 TO 480 STEP 2 * tileSize
   FOR UpLeftX = 0 TO 640 STEP 2 * tileSize
      ' Substitute Tile3 and Tile4 in line below
      ' for a different effect.
      IF RND < .5 THEN Tile1 ELSE Tile2
   NEXT UpLeftX
NEXT UpLeftY

' Loop until someone presses a key.
DO WHILE INKEY$ = ""
   PaintX = INT(RND * 640)
   PaintY = INT(RND * 480)

PickPaint:
   PaintHue = INT(RND * 15)
   IF PaintHue = theColor THEN GOTO PickPaint
   PAINT (PaintX, PaintY), PaintHue, theColor
LOOP

SUB Tile1
   LowRtX = UpLeftX + 2 * tileSize
   LowRtY = UpLeftY + 2 * tileSize

   CIRCLE (UpLeftX, UpLeftY), tileSize, theColor, 4.71, 0
   CIRCLE (LowRtX, LowRtY), tileSize, theColor, 1.5708, 3.1416
END SUB

SUB Tile2
   UpRtX = UpLeftX + 2 * tileSize
   LowLeftY = UpLeftY + 2 * tileSize

   CIRCLE (UpRtX, UpLeftY), tileSize, theColor, 3.1416, 4.71
   CIRCLE (UpLeftX, LowLeftY), tileSize, theColor, 0, 1.571
END SUB

SUB Tile3
   LineX1 = UpLeftX + tileSize
   LineY1 = UpLeftY + tileSize
   LineX2 = UpLeftX + 2 * tileSize
   LineY2 = UpLeftY + 2 * tileSize

   LINE (UpLeftX, LineY1)-(LineX1, UpLeftY), theColor
   LINE (LineX1, LineY2)-(LineX2, LineY1), theColor
END SUB

SUB Tile4
   LineX1 = UpLeftX + tileSize
   LineY1 = UpLeftY + tileSize
   LineX2 = UpLeftX + 2 * tileSize
   LineY2 = UpLeftY + 2 * tileSize

   LINE (UpLeftX, LineY1)-(LineX1, LineY2), theColor
   LINE (LineX1, UpLeftY)-(LineX2, LineY1), theColor
END SUB

