MODULE dd;

(* Michael A. Covington 1990 *)
(* In JPI TopSpeed Modula-2. *)

FROM IO
  IMPORT WrChar,WrStr,WrLn;
FROM FIO
  IMPORT ChDir,IOcheck,IOresult;
FROM Lib
  IMPORT ParamCount, ParamStr, Dos;
FROM SYSTEM
  IMPORT Registers;

TYPE
  String = ARRAY[0..63] OF CHAR;

PROCEDURE Instructions;
CONST
  nl = 12C + 15C;
BEGIN
  WrStr("DD -- Copyright 1990 Michael A. Covington" +
   nl +
   nl + "DD is like the DOS command CD except that it" +
   nl + "changes the current disk and directory at once." +
   nl +
   nl + "Example:  dd e:\mydir  " +
   nl + "  changes current disk to e:" +
   nl + "  and current directory on e: to \mydir" +
   nl +
   nl + "You may distribute DD free of charge to anyone." +
   nl + "You may not sell it without the author's permission." +
   nl)
END Instructions;

PROCEDURE ChDisk(Drive:CHAR);
VAR
  r: Registers;
  d: SHORTCARD;
BEGIN
    d := SHORTCARD(CAP(Drive)) - SHORTCARD("A");
    r.AH := 0EH;
    r.DL := d;
    Dos(r);
END ChDisk;

(* MAIN *)
VAR
  Path: String;

BEGIN
  IF ParamCount() = 0 THEN
    Instructions
  ELSE
    ParamStr(Path,1);

    IOcheck := FALSE;
    ChDir(Path);

    IF IOresult() <> 0 THEN
      WrStr("Can't chdir to ");
      WrStr(Path);
      HALT
    END;

    IF Path[1] = ":" THEN
      ChDisk(Path[0])
    END;

  END
END dd.




