*******************************************************************
*
* Funktion    : START()
* Copyright   : (c) 1993-1994, Peter Huff
*               Alle Rechte vorbehalten
*
* Datum       : 28.11.93
* Autor       : Peter Rainer Huff
* Beschreibung: Beispielprogramm fr das Anlegen eines Verzeichnis 
*	        mit mehreren Unterverzeichnissen
*
* Rckgabe    : NIL
*
*******************************************************************

#define    FALSE           .F.   
#define    TRUE            .T.   
#define    SC_NONE          0

FUNCTION START()

	LOCAL newdir := "C:\DATA\PROJECT\AIRPORT\FOYER\"

	CLS

	?  "   (c) Peter Huff, Germany, Version 1.0"
	?  "   All Rights reserved."
	?  "   Create a directory with some subdirectories (Written with FUNCky II)."  
	?
	?  "   Name      :    MVERZ()"
	?  "   Usage     :    MVERZ(dirname)  --> Status"
	?  "   Example   :    MVERZ('C:\DATA\PROJECT\AIRPORT\FOYER\')"

	IF RIGHT(ALLTRIM(newdir),1) # "\"
	   newdir := ALLTRIM(newdir) 
	ELSE
	   newdir := LEFT(ALLTRIM(newdir),LEN(ALLTRIM(newdir))-1)
	ENDIF

	IF ISDIR(newdir)
	   MESSBOX("Directory already exists :;;" + UPPER(newdir))
	ELSE
	   IF   !  MVERZ(newdir)
	          MESSBOX("Error creating directory :;;" + UPPER(newdir))
	   ELSE
	          MESSBOX("Directory has been created :;;" + UPPER(newdir))
	   ENDIF
	ENDIF

RETURN(NIL)


*******************************************************************
*
* Funktion    : MVERZ()
* Copyright   : (c) 1993-1994, Peter Huff
*               Alle Rechte vorbehalten
* Datum       : 3.06.93
* Autor       : Peter Rainer Huff
* Beschreibung: Anlegen eines Unterverzeichnis
*               
* Rckgabe    : retval (Status .T. oder .F. )
*******************************************************************

FUNCTION MVERZ(newdir)

	LOCAL i         :=  1 
	LOCAL occur     :=  {}  
	LOCAL dir       :=  ""  
	LOCAL retval    :=  .T.
	LOCAL old_path  :=  CURDRIVE() + "\" + CURDIR() 

	IF RIGHT(ALLTRIM(newdir),1) # "\"
	   newdir := ALLTRIM(newdir) + "\"
	ELSE
	   newdir := ALLTRIM(newdir)
	ENDIF

	FOR i:= 1 TO CHRTOTAL(newdir,"\")
	     AADD(occur, ATNEXT("\",newdir,i))
	NEXT

	CHDIR("\")

	FOR i := 1 TO LEN(occur)
	    IF ( i == LEN(occur) )
	       EXIT
	    ENDIF 

	    dir := dir + "\"+SUBSTR(newdir,occur[i]+1,occur[i+1]-1-occur[i])

	    IF ! MKDIR(SUBSTR(newdir,occur[i]+1,occur[i+1]-1-occur[i]))
	       IF ( i == (LEN(occur)-1) )
	          retval := FALSE
	       ENDIF
	    ELSE
	       retval := TRUE
	    ENDIF 
     
	    CHDIR(dir)    

	NEXT i

	CHDIR(old_path)  // Der alte Pfad wird wieder eingestellt
   
RETURN(retval)


*******************************************************************
*
* Funktion    : MESSBOX
* Copyright   : (c) 1993-1994, Peter Huff
*               Alle Rechte vorbehalten
*
* Datum       : 28.11.93
* Autor       : Peter Rainer Huff
* Beschreibung: 
*
* Rckgabe    : NIL
*
*******************************************************************

FUNCTION MESSBOX(mess)

	LOCAL  _mm 
	LOCAL  _ao
	LOCAL  cursstate := SETCURSOR()

	SETCURSOR(SC_NONE)

	_ao  :=  {}
	_mm  :=  ALERT(mess, _ao)

	SETCURSOR(cursstate)

RETURN(NIL)

*---Eof