/* Clipper 5.x mini-ZIP ID functions
   (c) 1994 Base 12
   December 1994
   Programmer: Jose Jimenez Jr.
   PKZIP(R) is a registered trademark of PKWARE(R)

   BZIP is a very tiny library that contains 3 functions.
   It is used for reading information regarding ZIP files.  It does
   not ZIP or UNZIP files.

   FUNCTIONS:

   Function  : ISZIP()
   Parameters: file_name

   Purpose:  Verifies if the file is of PKZIP(R) format.

   Returns:  1 = Success
             0 = Not a PKZIP(R) file
            -1 = File not found
            -2 = File could not be opened
	    -3 = Failed to read ID information
            -4 = Failed to close file

   Function  : WHOMADEZIP()
   Parameters: file_name

   Purpose:  Returns the OS that created file

   Returns:  char = OS that made ZIP
 
   Possible: MS-DOS and OS/2 (F.A.T. file systems)
	     Amiga                     
             VAX/VMS
	     *nix
             VM/CMS
	     Atari ST
             OS/2 H.P.F.S.
	     Macintosh
             Z-System
	     CP/M
             Unknown


   Function  : ZIPVERSION()
   Parameters: file_name

   Purpose:  Returns the version of min. ZIP version needed to unzip

   Returns: float = Version of ZIP file, example: 2.00
             -1 = File not found
             -2 = File could not be opened
	     -3 = Failed to read ID information
             -4 = Failed to close file
*/

@ 00,00 CLEAR  
cfile := SPACE(12)
@ 01,01 SAY "Enter file to verify: ";
        GET cfile
READ
nret := ISZIP(cfile)
DO CASE
   CASE nret = -4
      @ 03,01 SAY "Could not close file"
   CASE nret = -3
      @ 03,01 SAY "File ID could not be read, file may be damaged."
   CASE nret = -2
      @ 03,01 SAY "Could not open file."
   CASE nret = -1
      @ 03,01 SAY TRIM(cfile)+" could not be found."
   CASE nret = 0
      @ 03,01 SAY "File is not of PKZIP(R) format."
   CASE nret = 1
      @ 03,01 SAY "File is of PKZIP(R) format."
ENDCASE

IF nret != 1
   QUIT
ENDIF

// in the following, the return codes are not tested.  
// You can assume if the ISZIP() does not pass, the rest of the functions
// will not work.

@ 05,01 SAY "Searching for OS data..."
cret := WHOMADEZIP(cfile)
@ 05,01 CLEAR
@ 05,01 SAY "Zipped by : "+cret

@ 06,01 SAY "Seraching for version..."
nver := ZIPVERSION(cfile)
@ 06,01 CLEAR
@ 06,01 SAY "Version of ZIP:"
@ 06,17 SAY nver PICTURE "#.##"

QUIT

