




/*
 *
 *          Copyright (C) 1994, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1994. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */





#include "ui/xrtglbtn.h"
#include "ui/composit.h"
#include "ui/cntroler.h"

#include "base/integer.h"
#include "base/intset.h"

#if defined (__X_MOTIF__)
#include <Xm/ToggleB.h>

#endif


//------------------------------------------------------------------
//                     CLASS ExOrToggleButton
//------------------------------------------------------------------

#if defined(__MS_WINDOWS__)
#include <windows.h>
#define EXOR_TOGGLE_BUTTON_STYLE \
    BS_AUTORADIOBUTTON | WS_CHILD | WS_VISIBLE
#endif



UI_ExOrToggleButton::UI_ExOrToggleButton
    ( UI_CompositeVObject* parent, const UI_Rectangle& shape,
      UI_ViewID id, long btn_style
    )
: UI_Button(parent, shape, id,
#if defined(__MS_WINDOWS__)
             btn_style == -1 ? EXOR_TOGGLE_BUTTON_STYLE : btn_style
#else
             btn_style
#endif
             )
{
    _model = new CL_Integer;

}


UI_ExOrToggleButton::UI_ExOrToggleButton
    (UI_CompositeVObject* parent, UI_ViewID id, UI_ViewHandle handle) 
: UI_Button (parent, id, handle)
{
     _model = new CL_Integer; 
}


void UI_ExOrToggleButton::Initialize ()
{
    UI_Button::Initialize ();
    ModelChanged (*this, 1); // Dummy call to force initial setting

#if defined (__X_MOTIF__)
    Arg pargs [2], args [2];

    XtSetArg    (pargs[0], XmNradioBehavior , TRUE);
    XtSetArg    (pargs[1], XmNradioAlwaysOne, TRUE); 
    XtSetArg    (args [0], XmNindicatorType , XmONE_OF_MANY);
    XtSetArg    (args [1], XmNvisibleWhenOff, TRUE);

    XtSetValues   (_xwidget, args, 2);
    XtSetValues   ((Widget) _parent->ViewHandle (), pargs, 2);

#endif
}



CL_Object* UI_ExOrToggleButton::Model ()
{
#if defined (__MS_WINDOWS__)
    if (_handle > 0)
        SetModelValue (CL_Integer (SendMessage (_handle, BM_GETCHECK, 0,
                                                0L)));
#elif defined (__X_MOTIF__)
    if (_xwidget)
        SetModelValue (CL_Integer (XmToggleButtonGetState (_xwidget)));
#endif
    return _model;
}



bool UI_ExOrToggleButton::MakeVisualElement ()
{
    bool b = UI_SimpleVObject::MakeVisualElement ();
#if defined(__X_MOTIF__)
    XtAddCallback (_xwidget, XmNvalueChangedCallback, 
                   &UI_ExOrToggleButton::SelectionCallback, (XtPointer) this);
#endif
    return b;
}



#if defined (__X_MOTIF__)

struct _WidgetClassRec* UI_ExOrToggleButton::XName () const
{
    return xmToggleButtonWidgetClass;
}


void UI_ExOrToggleButton::SelectionCallback (Widget w, void* client,
                                             void* call)
{
    UI_ExOrToggleButton* btn = (UI_ExOrToggleButton *) client;
    int value = ((XmToggleButtonCallbackStruct*) call)->set;
    btn->SetModelValue (CL_Integer(value));
    _Controller->AddEvent (new UI_Event (Event_Select, btn, btn));
}

#endif



bool UI_ExOrToggleButton::ModelChanged (CL_Object&, long)
{
#if defined(__MS_WINDOWS__)
    if(_handle > 0) {
        SendMessage (_handle, BM_SETCHECK,
                     ((CL_Integer*) _model)->Value () > 0 ? 1 : 0, 0
                    );
    }

#elif defined(__X_MOTIF__)
    if (_xwidget) {
        bool state = (((CL_Integer *) _model)->Value () > 0 ? TRUE : FALSE);
        Arg arg[1];
        XtSetArg    (arg [0], XmNset, state);
        XtSetValues (_xwidget, arg, 1);
    }

#endif
    return TRUE;
}


char* UI_ExOrToggleButton::MSWindowsName() const
{
#ifdef __BORLANDC__
    // return "borradio";
    return "button";
#else
    return "button";
#endif
}
