




/*
 *
 *          Copyright (C) 1994, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1994. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */




#ifdef __GNUC__
#pragma implementation
#endif

// ---------------------- Include files --------------------------

#include "ui/visualob.h"
#include "ui/cntroler.h"
#include "ui/composit.h"
#include "ui/dsplsurf.h"
#include "ui/colormap.h"

#if defined(__MS_WINDOWS__)

#elif defined(__X_MOTIF__)
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <Xm/Xm.h>
struct _WidgetRec* UI_VisualObject::_shell;

#endif

#if defined(__GNUC__) && __GNUC_MINOR__ >= 6
template class CL_Binding<UI_VisualObject>;
#endif


typedef CL_Binding<UI_VisualObject> VObjBind;

// --------------- Initializations of static instance variables --------

UI_Controller*  UI_VisualObject::_Controller  = NULL;
UI_Application* UI_VisualObject::_Application = NULL;


//
//  -----------------Constructor---------------------
//

UI_VisualObject::UI_VisualObject
    (UI_CompositeVObject* parent, UI_ViewID idnum,
     const UI_Rectangle& r,long st)
{
    _shape = r;
#if defined(__MS_WINDOWS__)
    _style = st;
#elif defined (__X_MOTIF__)
    _xwidget = NULL;

#endif
    _Init (parent, idnum);
}



UI_VisualObject::UI_VisualObject (UI_CompositeVObject* prnt,
                                  UI_ViewID idnum, UI_ViewHandle h)
{
    _Init (prnt, idnum);
#if defined(__MS_WINDOWS__)
    _handle = h;
#endif

#if defined (__X_MOTIF__)
    _xwidget = NULL;

#endif
}



void UI_VisualObject::SetShapeRectangle (const UI_Rectangle& r)
{
     VObjBind b (this, &UI_VisualObject::_ShapeRectChanged);
 
    _shape.RemoveDependent (b);
    _shape = r;
    _shape.AddDependent (b, 1);
}


void UI_VisualObject::_Init (UI_CompositeVObject* prnt, UI_ViewID idnum)
{
    _displaySurface = NULL;
    _id = idnum;
    _parent = prnt;
    _fgColor = UI_Color (UIColor_White);
    _bgColor = UI_Color (UIColor_Black);
    

    VObjBind bind (this, &UI_VisualObject::_TitleChanged);
    _title.AddDependent (bind, 1);

    VObjBind b2 (this, &UI_VisualObject::_ShapeRectChanged);
    _shape.AddDependent (b2, 1);
    _ownFont = FALSE;
    _font = NULL;

    if (!_parent)
        _MakeNewFont ();
    else
        _font = _parent->_font;

#if defined (__MS_WINDOWS__)
    _handle = 0;
#endif
    _created = FALSE;

    UI_Event* e1 = new UI_Event (Event_MakeInterface, this, _parent);

    if ( !_parent )
        e1->SetDestination (NULL);
    _Controller->AddEvent (e1);

#if defined(__MS_WINDOWS__)
    _visible = (_style & WS_VISIBLE) ? TRUE : FALSE;

#else
    _visible = TRUE; // By default, we're visible

#endif
}






UI_VisualObject::~UI_VisualObject () 
{
    if ( _parent )
        _parent->RemoveChild (_id);
    if ( _displaySurface )
        delete _displaySurface;
    if ( _ownFont )
        delete _font;
}






//
//  -----------------Query---------------------------
//

UI_Rectangle UI_VisualObject::Area() const
{
#if defined(__MS_WINDOWS__)
    RECT msrec;
    GetWindowRect (_handle, &msrec);
    UI_Point p (msrec.left, msrec.top);
    UI_Rectangle rec (p, msrec.right - msrec.left, msrec.bottom - msrec.top);
    return rec;

#elif defined(__X_MOTIF__)
    return _shape; // Not sure if this is ok.
#endif
}




char* UI_VisualObject::MSWindowsName() const
{
    CL_Error::Warning ("UI_VisualObject::MSWindowsName: derived class %s"
                       " did not override!", ClassName());
    return "";
}


#if defined (__X_MOTIF__)

struct _WidgetClassRec* UI_VisualObject::XName() const
{
    CL_Error::Warning ("UI_VisualObject :: XName: derived class %s",
                         " did not override!", ClassName()
                        );
    return NULL;
}
 
#endif



UI_DisplaySurface& UI_VisualObject::CreateDisplaySurface ( )
{
    if (!_displaySurface)
        _displaySurface = new UI_DisplaySurface (this);

    _displaySurface->SetFont (_font);
    return *_displaySurface;
}



void UI_VisualObject::DestroyDisplaySurface()
{
    if ( _displaySurface ) {
        delete _displaySurface;
        _displaySurface = NULL;
    }
}

//
//------------------------Event Handling----------------
//

bool UI_VisualObject::HandleEvent (UI_Event* e)
{
    return ProcessEvent (e);

}


bool UI_VisualObject::ProcessEvent (UI_Event* e)
{
    switch (e->Type()) {
    case Event_LButtonPress:
        return ButtonDown (e->curPos, UIM_Left, e->_shiftKey, e->_ctrlKey);

    case Event_LButtonRelease:
        return ButtonUp (e->curPos, UIM_Left);

    case Event_LButtonDblClk:
        return DoubleClick (e->curPos, UIM_Left);

    case Event_MButtonPress:
        return ButtonDown (e->curPos, UIM_Middle, e->_shiftKey, e->_ctrlKey);

    case Event_MButtonRelease:
        return ButtonUp (e->curPos, UIM_Middle);

    case Event_MButtonDblClk:
        return DoubleClick (e->curPos, UIM_Middle);

    case Event_RButtonPress:
        return ButtonDown (e->curPos, UIM_Right, e->_shiftKey, e->_ctrlKey);

    case Event_RButtonRelease:
        return ButtonUp (e->curPos, UIM_Right);

    case Event_RButtonDblClk:
        return DoubleClick (e->curPos, UIM_Right);

    case Event_MouseMove:
        return MouseMove (e->curPos);

    case Event_ViewEnter:  
        return ViewEnter (e->curPos);

    case Event_ViewLeave:
        return ViewLeave (e->curPos);

    case Event_GetFocus:
        return GetFocus ();

    case Event_LoseFocus:
        return LoseFocus ();

    case Event_KeyPress:
        return KeyHit (e->key);

    case Event_Paint:
        return _created ? Paint(): FALSE;

    case Event_Resize:
        return Resize (e->curPos.XCoord(), e->curPos.YCoord());

    case Event_ViewMove:
        return ViewMove (e->curPos);
        
    case Event_ChildCreated:
        return FALSE;

    case Event_Select:
        return Select ();
        
    default:
        return FALSE;
    }
}



//
//------------------Mouse Events----------------------
//

bool UI_VisualObject::ButtonDown (const UI_Point&, UI_MouseButton, bool, bool)
{
    return FALSE;
}
    

bool UI_VisualObject::ButtonUp (const UI_Point&, UI_MouseButton)
{
    return FALSE;
}


bool UI_VisualObject::DoubleClick (const UI_Point&, UI_MouseButton)
{
    return FALSE;
}


bool UI_VisualObject::ViewEnter (const UI_Point&)
{
    return FALSE;
}


bool UI_VisualObject::ViewLeave (const UI_Point&)
{
    return FALSE;
}

//
//-------------Key Board Events-----------------
//

bool UI_VisualObject::GetFocus()
{
    return FALSE;
}


bool UI_VisualObject::LoseFocus()
{
    return FALSE;
}

bool UI_VisualObject::KeyHit (char )
{
    return FALSE;
}


bool UI_VisualObject::MouseMove(const UI_Point& )
{
    return FALSE;
}


bool UI_VisualObject::Resize (long new_width, long new_height)
{
    SetShapeRectangle (UI_Rectangle (_shape.Origin(), new_width, new_height));
    return FALSE;
}


bool UI_VisualObject::ViewMove (const UI_Point& new_position)
{
    SetShapeRectangle (UI_Rectangle (new_position, _shape.Width(),
                                     _shape.Height()));
    return FALSE;
}


//
//--------------Display Events---------------------
//



bool UI_VisualObject::_TitleChanged (CL_Object&, long)
{
#if defined(__MS_WINDOWS__)
    if (_handle > 0) {
        SendMessage (_handle, WM_SETTEXT,  0, (long)(const char*)_title);
    }
#endif

#if defined(__X_MOTIF__)
    if (!_xwidget)
        return TRUE; // Not yet set up
    XmString xmtitle;
    xmtitle = XmStringCreate ((char*)_title.AsPtr(),
                              XmSTRING_DEFAULT_CHARSET);
    XtVaSetValues (_xwidget, XmNlabelString, xmtitle, NULL);
    XmStringFree (xmtitle);
//     Display* dpy = XtDisplay (_xwidget);
//     XFlush (dpy);
    XmUpdateDisplay (_xwidget);
#endif
    return TRUE;
}



void UI_VisualObject::MakeVisible ()
{
    _visible = TRUE;

#if defined(__MS_WINDOWS__)
    if (_handle > 0)
        ShowWindow ((long) _handle, SW_SHOW);

#elif defined(__X_MOTIF__)
    if ( _parent && _xwidget) {
        XtManageChild   (_xwidget);
    }
    else
        _Controller->Refresh ();
#endif
}



void UI_VisualObject::MakeInvisible ()
{
    _visible = FALSE;
#if defined(__MS_WINDOWS__)
    if (_handle > 0)
        ShowWindow ((long)_handle, SW_HIDE);
#elif defined(__X_MOTIF__)
    if (_xwidget)
        XtUnmanageChild (_xwidget); 
#endif
}



bool UI_VisualObject::WantToQuit()
{
    return TRUE;
}

//
//---------------other events-----------------
//


void UI_VisualObject::Initialize()
{
    _created = TRUE;
    if (_parent)
        _parent->AddChild (this);
#if defined(__MS_WINDOWS__)

    CL_String my_name (MSWindowsName());
    if (my_name(0,4) == "menu")  // Hack to fix menus
        return;
    if (_handle > 0) {
        RECT msrec;
        GetClientRect (_handle, &msrec);
        POINT ms_pt;
        ms_pt.x = ms_pt.y = 0;
        ClientToScreen (_handle, &ms_pt);
        UI_Point p (ms_pt.x, ms_pt.y);
        UI_Rectangle rec (p, msrec.right - msrec.left,
	                  msrec.bottom - msrec.top);
        SetShapeRectangle (rec);
    }
#elif defined (__X_MOTIF__)

//     if (_parent && !_parent->CreatedViaResource())
//         _font->SelectFor (this);
//     VObjBind b (this, (VObjBind::MethodPtr)
//                 &UI_VisualObject::_FontChanged);
//     _font->AddDependent (b, 1);
   

#endif
}



bool UI_VisualObject::DestroyVisualElement()
{
    CL_Error::Warning ("UI_VisualObject::DestroyVisualElement: derived "
                       "class %s did not override!", ClassName());
    return FALSE;  // Should never be called: child class must override
}


bool UI_VisualObject::Enable ()
{

#if defined(__MS_WINDOWS__)
    return EnableWindow   ((long)_handle, TRUE);

#elif defined(__X_MOTIF__)
    XtSetSensitive (_xwidget, TRUE);
    return TRUE;
#endif

}



bool UI_VisualObject::Disable()
{

#if defined(__MS_WINDOWS__)
    return EnableWindow   ((long)_handle, FALSE);

#elif defined(__X_MOTIF__)
    XtSetSensitive (_xwidget, FALSE);
    return TRUE;

#endif
}



CL_String UI_VisualObject::InstanceName()
{
    return _Application->InstanceName (this);
}



bool UI_VisualObject::_ShapeRectChanged (CL_Object&, long)
{
#if defined(__MS_WINDOWS__)
    if (_handle <= 0)
        return TRUE;
    RECT rect;
    const UI_Point& p  = _shape.Origin();
    rect.left    = p.XCoord();
    rect.top     = p.YCoord();
    rect.right   = rect.left + _shape.Width();
    rect.bottom  = rect.top  + _shape.Height();
    AdjustWindowRect (&rect, _style, FALSE);
    MoveWindow (_handle, rect.left, rect.top,
                rect.right-rect.left, rect.bottom-rect.top, TRUE);
    return TRUE;

#elif defined(__X_MOTIF__)
    if (!_xwidget)
        return TRUE;
    Arg arg[4];
    short argn = 0;
    long x = _shape.Origin().XCoord();
    long y = _shape.Origin().YCoord();
    long w = _shape.Width();
    long h = _shape.Height();
    XtSetArg (arg [ argn ], XtNx,     x); argn++;
    XtSetArg (arg [ argn ], XtNy,     y); argn++;
    XtSetArg (arg [ argn ], XtNheight,h); argn++;
    XtSetArg (arg [ argn ], XtNwidth, w); argn++;
    XtSetValues (_xwidget, arg, argn);
    return TRUE;
#endif
}




UI_Font& UI_VisualObject::Font()
{
    // If someone is asking for our font, we'll assume they're trying to
    // modify our font.
#if defined(__MS_WINDOWS__)
    if (_handle <= 0)
        return *_font;
#elif defined (__X_MOTIF__)
    if (!_xwidget)
        return *_font;
#endif
    
#if defined (__MS_WINDOWS__)
    // Font stuff is not yet supported under X
    if (!_ownFont) {
        VObjBind b (this, &UI_VisualObject::_FontChanged);
        _font->RemoveDependent (b);
        _MakeNewFont ();
        _font->SelectFor (this);
        if ( _displaySurface )
            _displaySurface->SetFont ( _font );
        _font->AddDependent (b, 1);
    }
#endif
    return *_font;
}



bool UI_VisualObject::SetFont (UI_Font* f)
{
#if defined (__MS_WINDOWS__)
    // Font stuff not yet supported under X
    if (_ownFont)
        return FALSE;
    VObjBind b (this, &UI_VisualObject::_FontChanged);
    _font->RemoveDependent (b);
    _font = f;
    _font->AddDependent (b, 1);
#endif
    return TRUE;
}



UI_Font* UI_VisualObject::OurFont ()
{
    return _ownFont ? _font : _parent->OurFont();
}


bool UI_VisualObject::_FontChanged (CL_Object&, long)
{
    return FALSE;
}


void UI_VisualObject::_MakeNewFont ()
{
    if (!_ownFont) {
        if (_parent)
            _font = new UI_Font (*(_parent->_font));
        else {
            _font = new UI_Font;
        }
        _ownFont = TRUE;
        SetFont (_font);
    }
}



void UI_VisualObject::Foreground (const UI_Color& c)
{
    _fgColor = c;
//     if (_displaySurface == NULL)
//         CreateDisplaySurface ();
//     UI_ColorMapHandle h;
//     h = _displaySurface->ColorMap ().Match (c);
    
#if defined (__MS_WINDOWS__)
    HDC hdc = GetDC (_handle);
    if (hdc) {
        SetTextColor (hdc, c.NativeForm());
        ReleaseDC (_handle, hdc);
    }
    
#elif defined (__X_MOTIF__)
//    XSetForeground (XtDisplay (_xwidget), _displaySurface->Handle (), h);
    
#endif
}



void UI_VisualObject::Background (const UI_Color& c)
{
    _bgColor = c;
//     if (_displaySurface == NULL)
//         CreateDisplaySurface ();
//     UI_ColorMapHandle h;
//     h = _displaySurface->ColorMap ().Match (c);
    
#if defined (__MS_WINDOWS__)
    HDC hdc = GetDC (_handle);
    if (hdc) {
        SetBkColor (hdc, c.NativeForm());
        ReleaseDC (_handle, hdc);
    }
#elif defined (__X_MOTIF__)
    // XSetBackground (XtDisplay (_xwidget), _displaySurface->Handle (), h);
    
#endif
}




#if defined(__X_MOTIF__)
void UI_VisualObject::_SetupStyle (void* p, short& argn)
{
    argn = 0;
    Arg* arg = (Arg*) p;

    short x = _shape.Left   ();
    short y = _shape.Top    ();
    short w = _shape.Width  ();
    short h = _shape.Height ();

    XtSetArg (arg [ argn ], XtNx,     x); argn++;
    XtSetArg (arg [ argn ], XtNy,     y); argn++;
    XtSetArg (arg [ argn ], XtNheight,h); argn++;
    XtSetArg (arg [ argn ], XtNwidth, w); argn++;

}
#endif

#if defined (__MS_WINDOWS__)
void UI_VisualObject::SetStyle (ulong style)
{
    _style = style;
}
#endif
