

#ifndef _toglbtn_h_ /* Fri Mar 11 08:37:05 1994 */
#define _toglbtn_h_





/*
 *
 *          Copyright (C) 1994, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1994. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */






//  A class representing a Toggle Button. The model for this object is a
//  {\small\tt CL_Integer} whose value is either 0 or 1 depending on
//  current button state. The model can be inspected by the {\small\tt
//  Model()} method.



#include "ui/button.h"

class UI_ToggleButton : public UI_Button {

public:

    UI_ToggleButton (UI_CompositeVObject* parent, const UI_Rectangle& shape,
                     UI_ViewID id = -1,long style = -1);
    
    UI_ToggleButton (UI_CompositeVObject* parent, UI_ViewID id,
                     UI_ViewHandle h);
    // For resource-based construction


    CL_Object* Model ();
    // Return a pointer to a {\small\tt CL_Integer} (our model).

    bool MakeVisualElement ();
    
    const char* ClassName () const {return "UI_ToggleButton";};

    char* MSWindowsName () const;

#if defined (__X_MOTIF__)
    struct _WidgetClassRec* XName () const;

#endif


protected:

    bool ModelChanged (CL_Object&, long);

    ~UI_ToggleButton(){;};

    
#if defined (__X_MOTIF__)
    static void SelectionCallback (struct _WidgetRec*, void *, void *);

#endif
    
};



#endif /* _toglbtn_h_ */
