

#include "base/set.h"

#include "ui/timer.h"
#include "ui/applic.h"
#include "ui/cntroler.h"

#if defined(__UNIX__)
#include <sys/time.h>
#endif

extern UI_Application* _TheApplication; // Needed for accessing main window
                                        // and the controller

#if defined(__MS_WINDOWS__)
#include <windows.h>
static CL_IntPtrMap    _TimerMap;       // Map of Windows timer indices to
                                        // UI_Timer objects

WORD FAR PASCAL TimerFunc (HWND, WORD, int id, DWORD)
{
    UI_Timer* tmr = (UI_Timer*) _TimerMap[id];
    if (tmr)
        tmr->DoAlarm();
    return 0; // This OK?
}
#endif





UI_Timer::UI_Timer (CL_AbstractBinding& bnd)
{
    _bind = (CL_AbstractBinding*) bnd.Clone();
#if defined(__MS_WINDOWS__)
    _id = 0;
#endif
}


UI_Timer::~UI_Timer ()
{
    Stop();
    delete _bind;
}



bool UI_Timer::Start (long msecs)
{
    _msecs = msecs;
#if defined(__MS_WINDOWS__)
    if (!_TheApplication)
        return FALSE;
    long n = _TimerMap.Size()+1;
    if (SetTimer (_TheApplication->MainWindow()->ViewHandle(),
                  n, msecs, (FARPROC) TimerFunc)) {
        _id = n;
        _TimerMap.Add (n, this);
        return TRUE;
    }
    return FALSE;
#endif

#if defined(__UNIX__)
    if (!_TheApplication)
        return FALSE;
    _id = _TheApplication->Controller().RegisterTimeOut
        (msecs, &UI_Timer::DoAlarm, this);
    return _id != 0;
#endif
}


bool UI_Timer::Stop ()
{
#if defined(__MS_WINDOWS__)
    if (_id > 0) {
        KillTimer (NULL, _id);
        _TimerMap.Remove (_id);
        _id = 0;
        return TRUE;
    }
    return FALSE;
#elif defined(__X_MOTIF__)
    if (_TheApplication)
        _TheApplication->Controller().UnregisterTimeOut (_id);
#endif
}



#if defined(__MS_WINDOWS__)
void UI_Timer::DoAlarm ()
{
    if (_id >= 1)
        _bind->Execute (*this, _id);
}
#endif


#if defined(__X_MOTIF__)
void UI_Timer::DoAlarm (void* p, ulong* id)
{
    UI_Timer* tmr = (UI_Timer*) p;
    if (tmr && tmr->_bind)
        tmr->_bind->Execute (*tmr, *id);
    tmr->_id = _TheApplication->Controller().RegisterTimeOut
        (tmr->_msecs, &UI_Timer::DoAlarm, tmr);
}
#endif



