




/*
 *
 *          Copyright (C) 1994, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1994. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */



#include "base/binding.h"
#include "ui/strseq.h"
#include "ui/strview.h"

#if defined(__GNUC__) && __GNUC_MINOR__ >= 6
template class CL_Binding<UI_StringSequence>;
#endif


typedef CL_Binding<UI_StringSequence> SeqBind;

void UI_StringSequence::AddClient (UI_StringView* v)
{
    _clientSet.Add(v);
}



void UI_StringSequence::RemoveClient (UI_StringView* v)
{
    _clientSet.Remove (v);
}



bool UI_StringSequence::Update (CL_Object&, long index)
{
    _ChangeUpdate (index);
    return TRUE;
}






bool UI_StringSequence::Insert (const CL_String& s, long index)
{
    if (!CL_StringSequence::Insert (s, index))
        return FALSE;
    SeqBind b (this, &UI_StringSequence::Update);
    (*this)[index+1].AddDependent (b, index+1);
    _InsertionUpdate (index);
    return TRUE;
}


CL_String UI_StringSequence::Remove (long index)
{
    CL_String s = CL_StringSequence::Remove (index);
    _RemovalUpdate (index);

    return s;
}


bool UI_StringSequence::ShiftLeftAt  (long pos, long amount)
{
    if (!CL_StringSequence::ShiftLeftAt (pos, amount))
        return FALSE;
    SeqBind b (this, &UI_StringSequence::Update);
    for (long i = pos - amount; i < _size; i++)
        (*this)[i].PostChangeCode (b) -= amount;
    return TRUE;
}

bool UI_StringSequence::ShiftRightAt (long pos, long amount)
{
    if (!CL_StringSequence::ShiftRightAt (pos, amount))
        return FALSE;
    SeqBind b (this, &UI_StringSequence::Update);
    for (long i = pos + amount; i < _size; i++)
        (*this)[i].PostChangeCode (b) += amount;
    return TRUE;
}









void UI_StringSequence::_InsertionUpdate (long i)
{
    CL_ObjectSetIterator itr (_clientSet);

    itr.Reset();
    while (itr.More())
        ((UI_StringView*) itr.Next())->PictureInserted (i);
}

void UI_StringSequence::_RemovalUpdate (long i)
{
    CL_ObjectSetIterator itr (_clientSet);

    itr.Reset();
    while (itr.More())
        ((UI_StringView*) itr.Next())->PictureRemoved (i);
}

void UI_StringSequence::_ChangeUpdate (long i)
{
    CL_ObjectSetIterator itr (_clientSet);

    itr.Reset();
    while (itr.More())
        ((UI_StringView*) itr.Next())->PictureChanged(i);
}







