




/*
 *
 *          Copyright (C) 1994, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1994. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */




#include "ui/stred.h"
#include "ui/cntroler.h"

#if defined(__MS_WINDOWS__)
#include <windows.h>
#define DEFAULT_STYLE \
    ES_LEFT | WS_CHILD | WS_VISIBLE | WS_BORDER | WS_TABSTOP | WS_GROUP


#elif defined(__X_MOTIF__)
#include <Xm/Text.h> 

#endif


UI_StringEditor::UI_StringEditor
    (UI_CompositeVObject* parent, const UI_Rectangle& shape,
     UI_ViewID id, long s
    )
: UI_SimpleVObject (parent, id, shape, s)
{
    _model = new CL_String; 
    _limit = -1;
#if defined(__MS_WINDOWS__)
    if ( _style == -1 )
        _style =  DEFAULT_STYLE;
#endif
}

UI_StringEditor::UI_StringEditor (UI_CompositeVObject* parent,
                                  UI_ViewID id, UI_ViewHandle h)
: UI_SimpleVObject (parent, id, h)
{
    _model = new CL_String;
    _limit = -1;
}


UI_StringEditor::UI_StringEditor
    (UI_CompositeVObject* parent, CL_String* model,
     const UI_Rectangle& shape, UI_ViewID id, long s)
: UI_SimpleVObject(parent, model, id, shape, s)
{
    _limit = -1;
#if defined(__MS_WINDOWS__)
    if (_style == -1)
        _style = DEFAULT_STYLE;
#endif
}



#if defined(__X_MOTIF__)
void UI_StringEditor::_SetupStyle (void* p, short& argn)
{
    Arg* arg = (Arg*) p;
    UI_SimpleVObject::_SetupStyle (p, argn);
    XtSetArg (arg[argn], XmNeditMode, XmSINGLE_LINE_EDIT); argn++;
}
#endif


void UI_StringEditor::Initialize ()
{
    UI_SimpleVObject::Initialize ();
#if defined(__MS_WINDOWS__)
    CL_String& s = *((CL_String*) _model);
    if (s.Size() > 0)
        SendMessage (_handle, EM_REPLACESEL, 0, (long) s.AsPtr());
#elif defined(__X_MOTIF__)
    XmTextSetString (_xwidget, (char*) ((CL_String*) _model)->AsPtr());
#endif
}


#if defined (__X_MOTIF__)
struct _WidgetClassRec* UI_StringEditor::XName ( ) const
{
    return  xmTextWidgetClass;
}

#endif



//
// -----------------StringEditor Event methods--------------------
//



CL_Object* UI_StringEditor::Selection ()
{
#if defined(__MS_WINDOWS__)
    DWORD pos;
    pos = SendMessage  (_handle, EM_GETSEL, 0, 0);
    _selection = CL_Interval (LOWORD(pos), HIWORD(pos)-1);

#elif defined(__X_MOTIF__)
    XmTextPosition left, right;
    XmTextGetSelectionPosition(_xwidget, &left, &right);
    _selection = CL_Interval ((long) left, (long) right);

#endif
    return &_selection;
}


CL_Object* UI_StringEditor::Model ()
{
#if defined(__MS_WINDOWS__)
    if (_handle <= 0) {
        SetModelValue (CL_String (""));
        return _model;
    }
    long n = GetWindowTextLength (_handle);
    char* buf;
    if (! (buf = new char[n+1]))
        return _model; // No memory
    GetWindowText (_handle, buf, n+1);
    SetModelValue (CL_String (buf));
    delete buf;

#elif defined(__X_MOTIF__)
    if ( _xwidget == NULL ) {
        SetModelValue (CL_String (""));
        return _model;
    }
    char* p =  XmTextGetString (_xwidget);
    SetModelValue (CL_String (p));
    XtFree (p);
#endif
    return _model;
}





bool UI_StringEditor::KeyHit (char)
{
    return FALSE;
}


bool UI_StringEditor::SetLengthLimit (long n)
{
#if defined (__MS_WINDOWS__)
    if (n > 0 && n <= 32767) {
        _limit = n;
        return SendMessage  (_handle, EM_LIMITTEXT, n, 0);
    }
    return FALSE;
#elif defined (__X_MOTIF__)
    if (n > 0) {
        _limit = n;
        Arg arg[1];
        XtSetArg (arg[0], XmNmaxLength, n);
        XtSetValues (_xwidget, arg, 1);
    }
    return TRUE;
#endif
}


bool UI_StringEditor::ModelChanged (CL_Object&, long)
{
#if defined(__MS_WINDOWS__)
    CL_String& s = *((CL_String*) _model);
    if (_handle > 0 && s.Size() > 0)
        SendMessage (_handle, EM_REPLACESEL, 0, (long) s.AsPtr());
#elif defined(__X_MOTIF__)
    if (_xwidget) {
        XmTextSetString (_xwidget, (char*) ((CL_String*) _model)->AsPtr());
        XmUpdateDisplay  (_xwidget);
    }
#endif
    return TRUE;
}

