

#ifndef _stddlg_h_ /* Tue Jan  4 14:59:57 1994 */
#define _stddlg_h_





/*
 *
 *          Copyright (C) 1994, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1994. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */





// This header file defines functions for ``standard'' dialogs  for yes/no
// and informational message boxes and for file selection.

#include "ui/visualob.h"


// ---------------- Simple question or info dialog -------------------


// Dialog styles:
enum UI_SimpleDialogStyle {
    UIS_Ok, UIS_OkCancel, UIS_YesNo, UIS_YesNoCancel
};


// Dialog icon styles:
enum UI_SimpleDialogIconStyle {
    UIS_Information, UIS_Warning, UIS_Error, UIS_Question
};

// Id's of the buttons on these dialogs:
#define UI_IDOK      1
#define UI_IDCANCEL  2
#define UI_IDYES     3
#define UI_IDNO      4


UI_ViewID UI_SimpleDialog (const char* message,
                           UI_SimpleDialogStyle style = UIS_Ok,
                           UI_SimpleDialogIconStyle icon = UIS_Information,
                           UI_VisualObject* parent = NULL,
                           const char* box_title = "");
// Show the specified kind of dialog, and return the id of the button
// clicked on.


// ---------------------- Open file dialog ----------------------------

CL_String UI_FileSelectDialog (UI_VisualObject* parent,
                               const char* box_title = "Open file");
// Show the platform's file-open dialog, and return the chosen file name.
// Return the null string if canceled.


#endif /* _simpldlg_h_ */
