

#ifndef _scrolbar_h_
#define _scrolbar_h_





/*
 *
 *          Copyright (C) 1994, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1994. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */





// A scroll bar as a simple visual object.
// The model for this object is a sub-interval of the interval that
// represents the entire range of the scroll bar. The selection is undefined.
// The ScrollBar object maintains a set of
// clients that are notified of scrolling events (see {\small\tt event.h}
// for the kinds of scrolling events supported).



#include "base/clntset.h"
#include "ui/simple.h"
#include "ui/interval.h"

class UI_ScrollBar: public UI_SimpleVObject {

public:

    CL_Interval& Range ();
    // Return the current extent (i.e., the total range) of the scroll
    // bar. The return value may be modified.
    
    long& LineAmount ();
    // Return the amount to scroll by when the line-down/line-up key or
    // button is used. The return value is a reference and therefore may be
    // modified by the caller.

    long& PageAmount ();
    // Return the amount to scroll by when the "page-by" key or button
    // is used. The return value is a reference and therefore may be
    // modified by the caller.

    CL_ClientSet& ClientSet ();
    // Return the set of clients for this scroll bar. The set may be
    // modified, since  a reference is returned.

    bool& SmoothScroll ();
    // Return the ``smooth scrolling'' parameter for this scroll bar. If this
    // parameter is TRUE, the scroll bar notifies its clients on every
    // scrolling (mouse) event; if it is FALSE, the notification occurs only
    // when the mouse movement is completed.
    
    
    //-------------Inherited SimpleVObject methods---------------

    CL_Object* Selection () { return _model;};

    char* MSWindowsName () const { return "scrollbar";};

#if defined (__X_MOTIF__)
    struct _WidgetClassRec *XName () const;

#endif

    const char* ClassName () const { return "UI_ScrollBar";};

protected:

    //
    //------------------Construction-------------------
    //


    UI_ScrollBar (UI_CompositeVObject* parent, const UI_Rectangle& shape,
                  UI_ViewID id = -1, long style = -1);

    ~UI_ScrollBar ();

    bool MakeVisualElement ();
    
    void Initialize ();

    bool HandleEvent (UI_Event* e);

    bool ModelChanged (CL_Object&, long);

    bool RangeChanged (CL_Object&, long);
    

    CL_Interval   _range;
    CL_ClientSet  _clientSet;
    long          _lineAmount;
    long          _pageAmount;
    bool          _smoothScroll;
    bool          _vertical;

private:
#if defined(__X_MOTIF__)
    static void ScrollBarCallback (struct _WidgetRec*, void *, void *);
    // [X/Motif-specific.]
    
#endif
};





class UI_VScrollBar: public UI_ScrollBar {

public:


    // ------------------Construction-------------------
    UI_VScrollBar (UI_CompositeVObject* parent, const UI_Rectangle& shape,
                   UI_ViewID id = -1, long style = -1);

    const char* ClassName () const {return "UI_VScrollBar";};

protected:

    ~UI_VScrollBar () {};

};


class UI_HScrollBar: public UI_ScrollBar {

public:

    // ------------------Construction-------------------
    
    UI_HScrollBar (UI_CompositeVObject* parent, const UI_Rectangle& shape,
                   UI_ViewID id = -1, long style = -1);

    const char* ClassName () const {return "UI_HScrollBar";};

protected:

    ~UI_HScrollBar () {};

};




inline long& UI_ScrollBar::LineAmount ()
{
    return _lineAmount;
}



inline long& UI_ScrollBar::PageAmount ()
{
    return _pageAmount;
}


inline CL_ClientSet& UI_ScrollBar::ClientSet ()
{
    return _clientSet;
}

inline bool& UI_ScrollBar::SmoothScroll ()
{
    return _smoothScroll;
}



#endif
