

#ifndef _pushbtn_h_ /* Fri Mar 11 08:35:35 1994 */
#define _pushbtn_h_





/*
 *
 *          Copyright (C) 1994, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1994. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */






// A PushButton is a specialization of the button class, and exhibits the
// behavior of being ``selected'' when either the left mouse button is
// pressed on it, or the space bar or return key is pressed when it has
// focus. When selected, the button sends itself an {\small\tt
// Event_Select}. By default, this event does nothing; the parent
// composite can catch this event (in its {\small\tt HandleChildEvent}
// method) and take the needed action.


#include "ui/button.h"


class UI_PushButton: public UI_Button {

public:

    UI_PushButton (UI_CompositeVObject* parent, const UI_Rectangle& shape,
                   UI_ViewID id = -1, long style=-1);
    // Constructor.

    UI_PushButton(UI_CompositeVObject* parent, UI_ViewID id, UI_ViewHandle h);
    // Resource-based construction (MS-Windows only).


#if defined (__X_MOTIF__)
    struct _WidgetClassRec *XName ( ) const;

#endif
    
    const char* ClassName() const {return "UI_PushButton";};

protected:

    bool MakeVisualElement ();
    
    bool ModelChanged (CL_Object&, long);

    bool Select ();

   
    ~UI_PushButton () {};
   
#if defined (__X_MOTIF__)
    void  _SetupStyle (void* p, short& argn);
    // Override UI_VisualObject's method
    
    static void SelectionCallback (struct _WidgetRec*, void *, void *);

#endif
    
};


#endif /* _pushbtn_h_ */
