
#ifndef _pictview_h_
#define _pictview_h_





/*
 *
 *          Copyright (C) 1994, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1994. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */





#include "ui/simple.h"
#include "ui/pictseq.h"

//   An abstract class representing one of many possible views of
//   an underlying model which is a PictureSequence. The model, ie. the
//   PictureSequence is NOT owned by the PictureView. It must be constructed
//   and  passed to the constructor of the PictureView for a valid pictorial
//   representation of itself. Conceptually, it is therefore possible to 
//   have more than one view of the same sequence simultaneously. 


class UI_PictureView: public UI_SimpleVObject {

public:

    virtual bool VerticalView () const =0;
    // Return true if view is vertical


    virtual bool Select (long n) = 0;
    // Select  the nth picture of the underlying sequence.Return TRUE
    // on success.

    virtual bool UnSelect (long n) = 0;
    // Unselect the nth picture if selected.Return TRUE on success.


    virtual short PictureHeight () const = 0;
    // return the height of an individual picture;

    virtual short PictureWidth () const = 0;
    // return the width of an individual picture

    virtual void PictureInserted (long i) = 0;
    // Notify the view that a picture at index i has been inserted .
    
    virtual void PictureRemoved (long i) = 0;
    // Notify the view that a picture at index i has been removed.

    virtual void PictureChanged (long i) = 0;
    // Notify the view that a picture at index i has been changed.


    
    const char* ClassName () const { return "UI_PictureView";};

protected:


    UI_PictureView (UI_CompositeVObject* parent, const UI_Rectangle& shape,
                   UI_ViewID id = -1, long style = -1);

    UI_PictureView (UI_CompositeVObject* parent, UI_ViewID id,
                    UI_ViewHandle h);

    UI_PictureView (UI_CompositeVObject* parent, CL_Object* model,
                    const UI_Rectangle& shape,
                    UI_ViewID id = -1, long style = -1);
    // Initialization of owned model left to subclass

    bool Select () {return UI_SimpleVObject::Select();}

};

#endif 
