#ifndef _pen_h_
#define _pen_h_





/*
 *
 *          Copyright (C) 1994, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1994. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */




#include "ui/dsplrsrc.h"
#include "ui/color.h"
#include "ui/rectangl.h"

// This class encapsulates all platform specific details of the
// resource pen to provide a platfrom independent mechanism for 
// setting and modifying  this resource.




enum UI_PenPattern   {
    UIPen_None, UIPen_Solid, UIPen_Dash, UIPen_Dot, UIPen_DashDot
};

class UI_Pen : public UI_DisplayResource {

public:
    UI_Pen (UI_DisplaySurface* ctxt, short pen_size = 1,
            UI_Color pen_color = UI_Color (UIColor_Black),
            UI_PenPattern patrn = UIPen_Solid);
    
    
    ~UI_Pen ();

    // ------------------  Attribute querying methods ----------------

    short         Size ();
    // Return the thickness of the pen, in pixels.

    UI_PenPattern Pattern ();
    // Return the pattern of the pen.

    UI_Color      Color();
    // Return the color of the pen.

    // ------------------ Attribute setting methods ------------------
    
    void Size (short size);
    
    void Pattern (UI_PenPattern );

    void Color (UI_Color newColor);

    // --------------------- Positioning and drawing ------------------

    bool MoveTo     (const UI_Point& p);
    // Move the pen to the given position

    bool DrawLineTo (const UI_Point& p);
    // Draw a line from the current position to the given one, using the
    // current pattern and color

    UI_Point Position () const;
    // Return the current pen position
    

    // ---------------------- Basic methods ---------------------------
    
    const char* ClassName () const { return "UI_Pen";};    


    // ------------------- End public protocol ------------------------
    
protected:

    short          _size;
    UI_Color       _color;
    UI_PenPattern  _pattern;
    UI_Point       _position;

    void           _Setup();

};






inline short UI_Pen::Size()
{
    return _size;
}


inline UI_PenPattern UI_Pen::Pattern()
{
    return _pattern;
}

inline UI_Color UI_Pen::Color()
{
    return _color;
}


inline UI_Point UI_Pen::Position() const
{
    return _position;
}



#endif

