




/*
 *
 *          Copyright (C) 1994, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1994. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */



#include "ui/pen.h"
#include "ui/color.h"
#include "ui/dsplsurf.h"

#if defined(__MS_WINDOWS__)
 
#include <windows.h>
static short getPatternFromMS (UI_PenPattern );

#elif defined(__X_MOTIF__)

#include <X11/Intrinsic.h>

static long getPatternFromX (UI_PenPattern);
#endif

// UI_Pen::UI_Pen()
// {
//     size = 1;
//     color.Set (UIColor_Black);
//     pattern = UIPen_Solid;
//     _handle = 0;
//     _Setup ();
// }

UI_Pen::UI_Pen (UI_DisplaySurface* ct, short sz, UI_Color cl,
                UI_PenPattern pt)
: UI_DisplayResource (ct)
{
    _size = sz;
    _color = cl;
    _pattern = pt;
}

void UI_Pen::_Setup ()
{
#if defined(__MS_WINDOWS__)
    if(_handle)
        DeleteObject (_handle); 
    short msp = getPatternFromMS (_pattern);
    _handle = (UI_ResourceHandle) CreatePen (msp, _size, _color.NativeForm());
    SelectObject (_clientCtxt->Handle(), _handle);

#elif defined(__X_MOTIF__)
    Display* dpy   = XtDisplay (_clientCtxt->Client()); 
    XSetLineAttributes (dpy, _clientCtxt->Handle(), Size (),
                        getPatternFromX (Pattern ()),
                        CapButt, JoinMiter);
#endif
}



UI_Pen::~UI_Pen()
{
#if defined(__MS_WINDOWS__)
    if(_handle)
        DeleteObject (_handle); 

#elif defined(__X_MOTIF__)

#endif
}

void UI_Pen::Size (short sz)
{
    _size = sz;
    _Setup ();
}


void UI_Pen::Pattern (UI_PenPattern ptrn)
{
    _pattern = ptrn;
    _Setup ();
}

void UI_Pen::Color(UI_Color newColor)
{
    _color = newColor;
    _Setup();
}



bool UI_Pen::MoveTo     (const UI_Point& p)
{
#if defined(__MS_WINDOWS__)
    if (!_clientCtxt)
        return FALSE;
    // First check that p is within bounds
    short hsize = GetDeviceCaps (_clientCtxt->Handle(), HORZRES);
    short vsize = GetDeviceCaps (_clientCtxt->Handle(), VERTRES);
    UI_Rectangle rect (0, 0, hsize-1, vsize-1);
    if (rect.Includes (p)) {
        ::MoveTo (_handle, p.XCoord(), p.YCoord());
        _position = p;
        return TRUE;
    }
    return FALSE;

#elif defined(__X_MOTIF__)
    
    _position = p;
#endif
}


// Draw a line from the current position to the given one, using the
// current pattern and color
bool UI_Pen::DrawLineTo (const UI_Point& p)
{
#if defined(__MS_WINDOWS__)
    if (!_clientCtxt)
        return FALSE;
    POINT array[2];
    array[0].x = _position.XCoord();
    array[0].y = _position.YCoord();
    array[1].x = p.XCoord();
    array[1].y = p.YCoord();
    if (Polyline (_clientCtxt->Handle(), array, 2)) {
        _position = p;
        return TRUE;
    }
    return FALSE;
//     
//     if (LineTo (_clientCtxt->Handle(), p.XCoord()+1, p.YCoord()+1)) {
//         // ------------------------------------^^ -----------^^--
//         // The additions above are to account for the off-by-one of
//         // Windows's LineTo call
//         DWORD pos = GetCurrentPosition (_clientCtxt->Handle());
//         _position = UI_Point (LOWORD (pos), HIWORD (pos));
//         return TRUE;
//     }
//     return FALSE;

#elif defined(__X_MOTIF__)

    Display* dpy = XtDisplay (_clientCtxt->Client ());
    XDrawLine (dpy, XtWindow (_clientCtxt->Client ()), _clientCtxt->Handle (),
               _position.XCoord(), _position.YCoord(), p.XCoord(), p.YCoord());

#endif
}






#if defined(__MS_WINDOWS__)

short getPatternFromMS(UI_PenPattern p)
{

    switch(p){

    case UIPen_None:
        return PS_NULL;
        
    case UIPen_Solid:
        return PS_SOLID;
    
    case UIPen_Dash:
        return PS_DASH;
    
    case UIPen_DashDot:
        return PS_DASHDOT;

    case UIPen_Dot:
        return PS_DOT;
        
    default:
        return PS_SOLID;
    }

}

#elif defined(__X_MOTIF__)
long getPatternFromX (UI_PenPattern p)
{
    switch(p){

        case UIPen_Solid:
            return LineSolid;
        case UIPen_Dash:
            return LineOnOffDash;
        case UIPen_Dot:
            return LineOnOffDash;
        case UIPen_DashDot:
            return LineDoubleDash;
        default:
            return LineSolid;
   }

}

#endif

