




/*
 *
 *          Copyright (C) 1994, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1994. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */






#include "ui/monthcal.h"
#include "ui/dsplsurf.h"


// ----------------  Look-and-feel configuration parameters -----------------

// Labels for the week day columns:
static char* days[7] = {"S", "M", "T", "W", "T", "F", "S"};

// Top left corner of the month label: (the label rectangle spans the width
// of the calendar, and the name of month is centered in this rectangle)
static UI_Point CalendarOrigin (10,5);

// Vertical gap between month label and row of day labels:
static short GapBelowMonthLabel = 8;

// Vertical gap between row of day labels and 5x7 rectangle of dates:
static short GapBelowDayNames = 3;

// Gaps between cells in the 5x7 rectangular array:
static short HorzGap=5, VertGap = 3;

// ----------------- End configuration parameters --------------------------


UI_MonthCalendar::UI_MonthCalendar
    (UI_CompositeVObject* parent, UI_ViewID id,
     const UI_Rectangle& shape, const CL_Date& date)
: UI_SimpleVObject (parent, id, shape)
{
    _model = new CL_Date;
    if (*_model == date)
        *_model = CL_Date::Today();
    CL_Date* dt = (CL_Date*) _model;
#if defined (__MS_WINDOWS__)
    _style = WS_CHILD | WS_VISIBLE;

#endif
    _month = dt->Month();
    _year = dt->Year();
    _daysInMonth = dt->DaysInMonth();
}


void UI_MonthCalendar::AdvanceMonth ()
{
    CL_Date& our_model = *(CL_Date*) _model;
    SetModelValue (our_model.AddMonths (1));
    _month = our_model.Month();
    _year  = our_model.Year();
    _daysInMonth = CL_Date::DaysInMonth ((CL_Date::MonthEnum)_month, _year);
    Paint();
}

void UI_MonthCalendar::PreviousMonth()
{
    CL_Date& our_model = *(CL_Date*) _model;
    SetModelValue (our_model.AddMonths (-1));
    _month = our_model.Month();
    _year  = our_model.Year();
    _daysInMonth = CL_Date::DaysInMonth ((CL_Date::MonthEnum)_month, _year);
    Paint();
}


bool UI_MonthCalendar::Paint ()
{
    CL_Date dt (*(CL_Date*) _model);
    Background (UIColor_White);
    Foreground (UIColor_Black);
    UI_DisplaySurface& dc (CreateDisplaySurface());

    dc.ClearDisplay();
    _charWidth = dc.Font().Width();
    _charHeight = dc.Font().Height();
    _cellWidth = 3*_charWidth+2;
    _cellHeight = _charHeight+2;

    // Paint the month name
    UI_Point topLeft = CalendarOrigin;
    UI_Rectangle label (topLeft, 7*(_cellWidth+HorzGap), _cellHeight);
    dc.WriteText (CL_Date::MonthName((CL_Date::MonthEnum)_month) + " "
                  + CL_String (_year), label, UIText_Center);
    topLeft += UI_Point (0, _charHeight + GapBelowMonthLabel);

    // Paint the names of the weekdays
    UI_Rectangle cell (topLeft,  _cellWidth, _cellHeight);
    for (short i = 0; i < 7; i++) {
        dc.WriteText (days[i], cell, UIText_Center);
        cell += UI_Point (_cellWidth+HorzGap, 0);
    }
    topLeft += UI_Point (0, _charHeight + GapBelowDayNames);

    // Paint the month's days
    CL_Date firstDay (_year, _month, 1);
    short dayOfWeek = firstDay.DayOfWeek();
    _dayOfFirst = dayOfWeek;
    cell = UI_Rectangle (topLeft,  _cellWidth, _cellHeight) +
        UI_Point ((dayOfWeek-1)*(_cellWidth+HorzGap), 0);
    CL_Date today = CL_Date::Today();
    for (i = 1; i <= _daysInMonth; i++) {
        dc.WriteText (CL_String (i, 2, ' '), cell, UIText_Right);
        if (i == dt.Day() && _month == today.Month()
            && _year == today.Year()) {
            UI_Rectangle r (cell.Origin(), cell.Width(), cell.Height());
            dc.InvertRectangle (r);
        }
        cell += UI_Point (_cellWidth + HorzGap, 0);
        dayOfWeek++;
        if (dayOfWeek > 7) {
            dayOfWeek = 1;
            cell.Origin(UI_Point (topLeft.XCoord(), cell.TopLeftY()
                                  + _cellHeight + VertGap));
        }
    }
    dc.DrawRectangle (UI_Rectangle (topLeft, 7*(_cellWidth+HorzGap),
                                    6*(_cellHeight+VertGap)));
    DestroyDisplaySurface();
    return FALSE; // Why?
}


bool UI_MonthCalendar::LButtonPress (const UI_Point& p, bool, bool)
{
    UI_Rectangle monthRect
        (CalendarOrigin + UI_Point
         (0, 2*_charHeight + GapBelowMonthLabel + GapBelowDayNames),
         7*(_cellWidth+HorzGap), 5*(_cellHeight+VertGap));
    if (!monthRect.Includes (p)) {
        return FALSE;
    }

    UI_Point topLeft = CalendarOrigin +
        UI_Point (0, 2*_charHeight + GapBelowDayNames + GapBelowMonthLabel);
    UI_Rectangle cell  (topLeft,  _cellWidth, _cellHeight);
    cell += UI_Point ((_dayOfFirst-1)*(_cellWidth+HorzGap), 0);
    short dayOfWeek = _dayOfFirst;
    for (short i = 1; i <= _daysInMonth; i++) {
        if (cell.Includes (p)) {
            ClickOnDay (i);
            return TRUE;
        }
        cell += UI_Point (_cellWidth + HorzGap, 0);
        dayOfWeek++;
        if (dayOfWeek > 7) {
            dayOfWeek = 1;
            cell.Origin (UI_Point (topLeft.XCoord(), cell.TopLeftY()
                                   + _cellHeight + VertGap));
        }
    }
    return TRUE;
}

