

#include "menudrv.h"
#include "ids.h"
#include "box.h"

#include "ui/ui.h"


#if defined(__GNUC__)
template class CL_Binding<MenuDriver>; // Instantiate the binding
#endif

extern UI_Application* _TheApplication;
extern UI_MenuBar*     MainMenu;

MenuDriver::MenuDriver()
{
    box = NULL;
    (*MainMenu)[ID_STOP]->Disable();
    status = new UI_Label (_TheApplication->MainWindow(),
                             UI_Rectangle (20, 350, 300, 20));
}

MenuDriver::~MenuDriver()
{
    if (box)
        _TheApplication->Destroy(box);
}


typedef CL_Binding<MenuDriver> MenuBinding;
struct DispatcherStruct {
    UI_ViewID              menu_id;
    MenuBinding::MethodPtr method;
    UI_MenuItem::MenuEvent event;
    long                   parameter;
} FAR dispatch [] = {
    {ID_START,    MenuDriver::Start,  UI_MenuItem::Selected,  1}
  , {ID_STOP,     MenuDriver::Stop,   UI_MenuItem::Selected,  1}
  , {ID_OPEN,     MenuDriver::Open,   UI_MenuItem::Selected,  1}
  , {ID_QUIT,     MenuDriver::Quit,   UI_MenuItem::Selected,  1}
  , {ID_SUBMENU1, MenuDriver::Inform, UI_MenuItem::Selected,  ID_SUBMENU1}
  , {ID_SUBMENU2, MenuDriver::Inform, UI_MenuItem::Selected,  ID_SUBMENU2}

  , {ID_START, MenuDriver::Change, UI_MenuItem::Highlighted, ID_START}
  , {ID_STOP,  MenuDriver::Change, UI_MenuItem::Highlighted, ID_STOP}
  , {ID_OPEN,  MenuDriver::Change, UI_MenuItem::Highlighted, ID_OPEN}
  , {ID_QUIT,  MenuDriver::Change, UI_MenuItem::Highlighted, ID_QUIT}

  , {ID_START, MenuDriver::Change, UI_MenuItem::UnHighlighted, 0}
  , {ID_STOP,  MenuDriver::Change, UI_MenuItem::UnHighlighted, 0}
  , {ID_OPEN,  MenuDriver::Change, UI_MenuItem::UnHighlighted, 0}
  , {ID_QUIT,  MenuDriver::Change, UI_MenuItem::UnHighlighted, 0}

  , {ID_APP2,  MenuDriver::Change, UI_MenuItem::Highlighted, 0}
  , {ID_APP3,  MenuDriver::Change, UI_MenuItem::Highlighted, 0}
    
};



void MenuDriver::Setup (UI_MenuBar* menu)
{
    for (short i = 0; i < sizeof dispatch/sizeof (DispatcherStruct); i++) {
        (*menu)[dispatch[i].menu_id]->AddClient
            (MenuBinding (this, dispatch[i].method),
             dispatch[i].parameter, dispatch[i].event);
    }
}




bool MenuDriver::Start (CL_Object&, long)
{
    if (!box) {
        box = new Box (_TheApplication->MainWindow(),
                       UI_Rectangle (20, 50, 400, 250));
        (*MainMenu)[ID_STOP]->Enable();
        (*MainMenu)[ID_START]->Disable();
        return TRUE;
    }
    return FALSE;
}



bool MenuDriver::Stop  (CL_Object&, long)
{
    if (box) {
        _TheApplication->Destroy(box);
        box = NULL;
    }
    (*MainMenu)[ID_START]->Enable();
    (*MainMenu)[ID_STOP]->Disable();
    return TRUE;
}


bool MenuDriver::Quit  (CL_Object&, long)
{
    _TheApplication->End();
    return TRUE;
}

bool MenuDriver::Change (CL_Object&, long menu_id)
{
    CL_String& s (*(CL_String*) status->Model());
    switch (menu_id) {
    case ID_START:
        s = "Creates the composite";
        break;
        
    case ID_STOP:
        s = "Destroys the composite";
        break;
        
    case ID_QUIT:
        s = "Terminates the application";
        break;
        
    case ID_OPEN:
        s = "Demo of file open dialog";
        break;

    default:
        s = "";
    }
    return TRUE;
}


bool MenuDriver::Open (CL_Object&, long)
{
    CL_String file = UI_FileSelectDialog (_TheApplication->MainWindow());
    if (file.Size() > 0)
        UI_SimpleDialog ("File name: " + file);
    else
        UI_SimpleDialog ("Canceled.");
    return TRUE;
}


bool MenuDriver::Inform (CL_Object&, long item_id)
{
    UI_SimpleDialog ("You chose " + (*MainMenu)[item_id]->Title());
    return TRUE;
}

