




/*
 *
 *          Copyright (C) 1994, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1994. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */


#define MNEMONIC_CHAR '&'  // For alt- functions

#if defined(__MS_WINDOWS__)
#include <windows.h>

#elif defined(__X_MOTIF__)
#include <Xm/RowColumn.h>
#include <Xm/CascadeB.h>
#include <Xm/PushB.h>
#include <Xm/CascadeBG.h>
#include <Xm/PushBG.h>
#include <Xm/SeparatoG.h>
#endif

#include "ui/menu.h"
#include "ui/cntroler.h"

#include "base/binding.h"
#include "base/treewalk.h"

#if defined(__GNUC__) && __GNUC_MINOR__ >= 6
template class CL_Binding<UI_Menu>;
#endif


UI_MenuItem::UI_MenuItem (UI_Menu* container, const char*
                          label, State state, UI_ViewID id)
: UI_SimpleVObject (_Application->MainWindow (), id, UI_Rectangle (), -1),
  _container (*container)
{
    _title     = label;
    _ownModel  = FALSE;
    _state     = state;
#if defined(__MS_WINDOWS__)
    _handle    = 0;
#endif
    _font      = NULL; // Don't want fonts for menu items, for now
}


bool UI_MenuItem::AddClient (const CL_AbstractBinding& bind, long code,
                             MenuEvent event)
{
    return (event >= Highlighted && event <= Selected)
        ? _clients[event].Add (bind, code) : FALSE;
}




bool UI_MenuItem::MakeVisualElement ()
{
#if defined(__MS_WINDOWS__)
    // The actual visual element for a popup menu is created by the UI_Menu
    // object, so if we are a popup, our handle is already set
    return FALSE; // We don't register menu items under Windows 

#elif defined (__X_MOTIF__)
    return TRUE; // We register menu items under X
    
#endif
}



bool UI_MenuItem::DestroyVisualElement ()
{
#if defined (__MS_WINDOWS__)
    if (_handle > 0) {
        DestroyMenu (_handle);
        return TRUE;
    }
    return FALSE;
#endif

#if defined (__X_MOTIF__)
    if (_xwidget)
        XtDestroyWidget (_xwidget);
    if (_xitemw)
        XtDestroyWidget (_xitemw);
    _xitemw = _xwidget = 0; // So that the controller does not attempt
                            // destruction again
#endif
}



bool UI_MenuItem::Enable ()
{
    _state = Enabled;
#if defined(__MS_WINDOWS__)
    if (_parentHandle > 0)
        return EnableMenuItem (_parentHandle, _id, MF_ENABLED);
    else
        return TRUE;
#elif defined(__X_MOTIF__)
    XtSetSensitive (_xitemw, TRUE);
    return TRUE;
#endif
}



bool UI_MenuItem::Disable ()
{
    _state = Disabled;
#if defined(__MS_WINDOWS__)
    return (_parentHandle > 0) ? EnableMenuItem (_parentHandle, _id,
                                                 MF_GRAYED)
        : TRUE;
#elif defined(__X_MOTIF__)
    XtSetSensitive (_xitemw, FALSE);
    return TRUE;
#endif
}



UI_ViewHandle UI_MenuItem::ViewHandle () const
{
#if defined (__MS_WINDOWS__)
    return UI_VisualObject::ViewHandle ();

#elif defined (__X_MOTIF__)
    return UI_ViewHandle (_xitemw);

#endif
}




bool UI_MenuItem::SetState (UI_MenuItem::State state)
{
    _state = state;
#if defined(__MS_WINDOWS__)
    if (_handle <= 0) // Not yet created
        return TRUE;
    switch (state) {
    case Enabled:
        return EnableMenuItem (_parentHandle, _id, MF_ENABLED);
        
    case Grayed:
        return EnableMenuItem (_parentHandle, _id, MF_GRAYED);
        
    case Disabled:
        return EnableMenuItem (_parentHandle, _id, MF_DISABLED);
        
    case Checked:
        return CheckMenuItem (_parentHandle, _id, MF_CHECKED);
        
    case Unchecked:
        return CheckMenuItem (_parentHandle, _id, MF_UNCHECKED);

    default:
        return FALSE;
    }
#endif
}




bool UI_MenuItem::Paint ()
{
    return FALSE;
}


bool UI_MenuItem::GetFocus ()
{
    _clients[0].NotifyAll (*this);
    return TRUE;
}



bool UI_MenuItem::LoseFocus ()
{
    _clients[1].NotifyAll (*this);
    return TRUE;
}
        
bool UI_MenuItem::Select ()
{
    _clients[2].NotifyAll (*this);
    return TRUE;
}




UI_MenuItem::~UI_MenuItem ()
{
}


#if defined (__X_MOTIF__)

void UI_MenuItem::GetFocusCallback (Widget w, void *client, void *call)
{
    UI_MenuItem *mi = (UI_MenuItem *) client;
    _Controller->AddEvent (new UI_Event (Event_GetFocus, mi, mi));
}



void UI_MenuItem::LoseFocusCallback (Widget w, void *client, void *call)
{
    UI_MenuItem *mi = (UI_MenuItem *) client;
    _Controller->AddEvent (new UI_Event (Event_LoseFocus, mi, mi));
}



void UI_MenuItem::SelectionCallback (Widget w, void *client, void *call)
{
    UI_MenuItem *mi = (UI_MenuItem *) client;
    _Controller->AddEvent (new UI_Event (Event_Select, mi, mi));
}

#endif

// --------------------- UI_Menu methods -----------------------


#define ROOT_ID 0

UI_Menu::UI_Menu (UI_MenuItemDescriptor* items)
: UI_VisualObject (_Application->MainWindow (), -1)
{
    UI_MenuItem* root_item = new UI_MenuItem
        (this, "", UI_MenuItem::Disabled, ROOT_ID);
    if (!root_item)
        return;
    _menuTree.NewRoot (ROOT_ID);
    _menuTree.Root()->Content() = (long) root_item;
    _BuildMenuSubtree (items, ROOT_ID);
    _focusItem = NULL;
    _font = NULL; // No fonts for menus, for now
}

static long _SeparatorIdCount = -3; // Hack to support separators

void UI_Menu::_BuildMenuSubtree (UI_MenuItemDescriptor* items,
                                 UI_ViewID subtree_root)
{
    if (!items)
        return;
    CL_IntegerTreeNode* root = _menuTree.Node (subtree_root);
    if (!root)
        return;
    for (short n = 0; items[n].label != NULL; n++) {
        UI_ViewID id;
        if (CL_String (UIMenu_Separator) == items[n].label)
            id = _SeparatorIdCount--;
        else
            id = items[n].id;
        UI_MenuItem* new_itm = new UI_MenuItem
            (this, items[n].label, items[n].state, id);
        CL_IntegerTreeNode* node = _menuTree.AddChild (id, subtree_root);
        if (node) {
            node->Content() = (long) new_itm;
            _BuildMenuSubtree (items[n].submenu, items[n].id);
        }
        else
            CL_Error::Warning ("YACL: UI_Menu: invalid (duplicate?) "
                               "menu item id %ld", id);
    }
}



bool UI_Menu::_DeleteItem (CL_Object& node, long)
{
#if defined (__MS_WINDOWS__)
    // Since, under Windows, the Controller does not know about the
    // existence of MenuItems, they must be explicitly deleted.
    delete (UI_MenuItem*) ((CL_IntegerTreeNode&) node).Content();
#endif
    return TRUE;
}



UI_MenuItem* UI_Menu::operator [] (UI_ViewID id)
{
    CL_IntegerTreeNode* node = _menuTree.Node (id);
    return node ? ((UI_MenuItem*) node->Content()) : NULL;
}





#if defined(__MS_WINDOWS__)
static long MSWinMenuState (UI_MenuItem::State state)
{
    switch (state) {
    case UI_MenuItem::Enabled:
        return MF_ENABLED;
        
    case UI_MenuItem::Grayed:
        return MF_GRAYED;
        
    case UI_MenuItem::Disabled:
        return MF_DISABLED;

    default:
        return MF_ENABLED;
    }
        
}
#endif


#if defined(__X_MOTIF__)
void UI_Menu::SetMenuItemLabel (UI_MenuItem* itm)
{
    short mnemonic_pos = itm->_title.CharIndex (MNEMONIC_CHAR);
    if (mnemonic_pos >= 0 && mnemonic_pos < itm->_title.Size()-1) {
        itm->_title(mnemonic_pos,1) = ""; // Remove the mnemonic char
    }
    char *label    = (char *) itm->_title.AsPtr ();
    XmString xmlabel = XmStringCreate (label, XmSTRING_DEFAULT_CHARSET);
    Arg arg[2];
    short argn = 0;
    XtSetArg (arg[0], XmNlabelString, xmlabel); argn++;
    if (mnemonic_pos >= 0) {
        XtSetArg (arg[1], XmNmnemonic, itm->_title[mnemonic_pos]);  argn++;
    }
    XtSetValues (itm->_xitemw, arg, argn);
    XmStringFree (xmlabel);
}
#endif


bool UI_Menu::_CreateVisualElement (CL_Object& v, long)
{
    CL_IntegerTreeNode& node   = ((CL_IntegerTreeNode &) v);
    UI_MenuItem*         itm   = (UI_MenuItem *) node.Content ();
    CL_IntegerTreeNode* parent = node.Parent();

#if defined (__MS_WINDOWS__)
    UI_ViewHandle h = parent ?
        ((UI_MenuItem*) parent->Content())->ViewHandle() : 0;
    itm->_parentHandle = h;

#endif

    if ( !node.IsLeaf () ) {
        if (parent) {
            // This is not the root. The root's handle is set by the
            // MakeVisualElement method that is calling us.

#if defined(__MS_WINDOWS__)
            itm->_handle = CreatePopupMenu ();
            AppendMenu (h, MSWinMenuState (itm->_state) |
                        MF_STRING | MF_POPUP,
                        itm->_handle, itm->_title.AsPtr());

#elif defined (__X_MOTIF__)
            Widget parentw = ((UI_MenuItem *)
                              parent->Content())->_xwidget;
            char *title    = "menuitems";
            itm->_xwidget = XmCreatePulldownMenu (parentw, title, 
                                                  NULL, 0);
            itm->_xitemw = XtVaCreateManagedWidget
                ((char*) itm->_title.AsPtr(),
                 xmCascadeButtonGadgetClass, parentw,
                 XmNsubMenuId,  itm->_xwidget,
                 NULL);
            SetMenuItemLabel (itm);
            XtAddCallback (itm->_xitemw, XmNactivateCallback, 
                           &(UI_MenuItem::GetFocusCallback), itm);

            XtRealizeWidget (itm->_xwidget);
            XtRealizeWidget (itm->_xitemw);

#endif
        }
#if defined (__MS_WINDOWS__)
        _popupMenuMap.Add (itm->_handle, itm);

#endif

    }

    else {

#if defined (__MS_WINDOWS__)
        if ( h ) {
            if (CL_String (UIMenu_Separator) == itm->_title)
                AppendMenu (h, MF_SEPARATOR, -1, 0);
            else
                AppendMenu (h, MSWinMenuState (itm->_state) | MF_STRING,
                            itm->_id, itm->_title);
        }

#elif defined (__X_MOTIF__)
        Widget parentw = ((UI_MenuItem *) parent->Content ())->_xwidget;
        CL_String instance_name = itm->InstanceName();
        char* label    = (char *) instance_name.AsPtr ();
        UI_MenuItem* root_item = (UI_MenuItem *)  
                                  _menuTree.Node (ROOT_ID)->Content();
        UI_MenuItem* parent_item = (UI_MenuItem *) parent->Content ();

        struct _WidgetClassRec* wclass;
        if (CL_String (UIMenu_Separator) != itm->_title)
            wclass = (parent_item == root_item ? xmCascadeButtonGadgetClass:
                      xmPushButtonGadgetClass);
        else
            wclass = xmSeparatorGadgetClass;
        parentw = (parent_item == root_item ? _xwidget : parentw);

        if ( parent_item == root_item ) {
            itm->_xitemw = XtVaCreateManagedWidget
                (label, wclass, parentw,  NULL);
            if (wclass != xmSeparatorGadgetClass) {
                XtAddCallback (itm->_xitemw, XmNactivateCallback, 
                               &(UI_MenuItem::GetFocusCallback), itm);
                SetMenuItemLabel (itm);
            }
            XtRealizeWidget (itm->_xitemw);
        }
        else {
            itm->_xitemw = XtCreateManagedWidget
                (label, wclass, parentw, NULL, 0);
            if (wclass != xmSeparatorGadgetClass) {
                XtAddCallback (itm->_xitemw, XmNarmCallback, 
                               &(UI_MenuItem::GetFocusCallback), itm);
                XtAddCallback (itm->_xitemw, XmNdisarmCallback, 
                               &(UI_MenuItem::LoseFocusCallback), itm);
                XtAddCallback (itm->_xitemw, XmNactivateCallback, 
                               &(UI_MenuItem::SelectionCallback), itm);

                SetMenuItemLabel (itm);
            }
            XtRealizeWidget (itm->_xitemw);
        }
#endif
    }

    return TRUE;
}



bool UI_Menu::HandleEvent (UI_Event* e)
{
    UI_MenuItem* m = NULL;
    switch (e->Type()) {
    case Event_LoseFocus:
        if (_focusItem)
            _focusItem->LoseFocus();
        _focusItem = NULL;
        return TRUE;

    case Event_GetFocus:
    case Event_Select:
#if defined (__MS_WINDOWS__)
        if (! (e->param & 0x80000000L)) {
                       // ??!! Dirty hack for Windows
            CL_IntegerTreeNode* node = _menuTree.Node (e->param);
            if (node)
                m = (UI_MenuItem*) node->Content();
        }
        else
            m = (UI_MenuItem*) _popupMenuMap [-(e->param)];

#endif

        if (m) {
            if (_focusItem && e->Type() == Event_GetFocus) {
                _focusItem->LoseFocus();
            }
            _focusItem = m;
            bool b = m->HandleEvent (e);
            if (e->Type() == Event_Select) {
                if (_focusItem)
                    _focusItem->LoseFocus();
                _focusItem = NULL;
            }
            return b;
        }
        // Fall through to default case...
        
    default:
        return ProcessEvent (e);
    }
}


    

bool UI_Menu::DestroyVisualElement ()
{
    // We need to walk the tree and destroy the menu items explicitly here;
    // Under MS-Windows, this is 
    // because menu items are not registered with the Controller, while
    // under X/Motif, it's because we don't want the menu items to hang
    // around and be accessed by the controller after the menu itself has
    // been destroyed.
    CL_IntegerTreePostWalker walker (_menuTree.Root());
    for (walker.Reset(); walker.More(); ) {
        UI_MenuItem* m = (UI_MenuItem*) walker.Next()->Content();
        m->DestroyVisualElement();
    }
    return FALSE;
}

typedef CL_Binding<UI_Menu> MenuBind;

UI_Menu::~UI_Menu()
{
    MenuBind bind (this, &UI_Menu::_DeleteItem);
    _menuTree.PostOrderWalk (ROOT_ID, bind);
}



// ----------------- UI_MenuBar methods -------------------------



UI_MenuBar::UI_MenuBar (UI_MenuItemDescriptor* item)
: UI_Menu (item)
{
}


bool UI_MenuBar::MakeVisualElement ()
{
    UI_MenuItem* root_item = (UI_MenuItem*)
        _menuTree.Node (ROOT_ID)->Content();
#if defined (__MS_WINDOWS__)
    root_item->_handle = CreateMenu ();
    _handle = root_item->_handle;

#elif defined (__X_MOTIF__)
    root_item->_xwidget = XmCreateMenuBar ((Widget)_parent->ViewHandle (), 
                                           "menubar", NULL, 0);
    root_item->_xitemw = 0;
    _xwidget = root_item->_xwidget;

    XtManageChild   (root_item->_xwidget);
    XtRealizeWidget (root_item->_xwidget);

#endif
    MenuBind bind (this, (MenuBind::MethodPtr)
                   &UI_MenuBar::_CreateVisualElement);
    MenuBind null_binding (NULL, NULL);
    _menuTree.Traverse (ROOT_ID, bind, null_binding);
    _created = TRUE;
    return TRUE;
}


UI_PopupMenu::UI_PopupMenu (UI_MenuItemDescriptor* item)
: UI_Menu (item)
{
}


UI_PopupMenu::~UI_PopupMenu ()
{
}



bool UI_PopupMenu::MakeVisualElement ()
{
    UI_MenuItem* root_item = (UI_MenuItem*)
        _menuTree.Node (ROOT_ID)->Content();

#if defined (__MS_WINDOWS__)
    root_item->_handle = CreatePopupMenu ();

#elif defined (__X_MOTIF__)
    root_item->_xwidget = XmCreatePopupMenu ((Widget)_parent->ViewHandle (), 
                                             NULL, NULL, 0); 
    _xwidget = root_item->_xwidget;
    XtManageChild   (root_item->_xwidget);
    XtRealizeWidget (root_item->_xwidget);

#endif
    MenuBind bind (this, (MenuBind::MethodPtr)
                   &UI_PopupMenu::_CreateVisualElement);
    MenuBind null_binding (NULL, NULL);
    _menuTree.Traverse (ROOT_ID, bind, null_binding);
    _created = TRUE;
    return TRUE;
}



