

// A window demo using YACL


#include "ui/ui.h"



// ======================== Class MyComposite ===========================


#define ID_LABEL1 11
#define ID_LABEL2 12
#define ID_LABEL3 13
#define ID_LABEL4 14
#define ID_BUTTON 15


UI_ViewDescriptor desc[] = {
    {View_Label,      ID_LABEL1, 15,  15, 300, 20, FALSE, TRUE, ""},
    {View_Label,      ID_LABEL2, 15,  40, 300, 20, FALSE, TRUE, ""},
    {View_Label,      ID_LABEL3, 15,  65, 300, 20, FALSE, TRUE, ""},
    {View_Label,      ID_LABEL4, 15,  90, 300, 20, FALSE, TRUE, ""},
    {View_PushButton, ID_BUTTON,125, 130,  80, 40, FALSE, TRUE, ""},
    {View_None, 0}
};

class MyComposite: public UI_CompositeVObject {

public:
    MyComposite ();

protected:

    void Initialize ();
    
    bool Resize (long new_width, long new_height);

    bool ViewMove (const UI_Point& new_position);

    bool HandleChildEvent (UI_Event* e);

    long _xInc, _yInc;
};

    
MyComposite::MyComposite()
: UI_CompositeVObject (NULL, desc, FALSE, UI_Rectangle (50, 50, 330, 200))
{
    _xInc = _yInc = 20;
    _title = "YACL Window Demo";
}

void MyComposite::Initialize ()
{
    UI_CompositeVObject::Initialize ();
    (*this)[ID_LABEL1].Title() = "I am a window.";
    ((UI_Label&) (*this)[ID_LABEL2]).Title() =
        "My client area is at position " + CL_String (_shape.TopLeftX())
        + " x " + CL_String (_shape.TopLeftY()) + ".";
    ((UI_Label&) (*this)[ID_LABEL3]).Title() =
        "My client area size is " + CL_String (_shape.Width ())
        + " x " + CL_String (_shape.Height ()) + ".";
    UI_Rectangle r = Area ();
    ((UI_Label&) (*this)[ID_LABEL4]).Title() =
        "My window area size is " + CL_String (r.Width ())
        + " x " + CL_String (r.Height ()) + ".";
    (*this)[ID_BUTTON].Title() = "Move!";
}

bool MyComposite::Resize (long new_width, long new_height)
{
    UI_CompositeVObject::Resize (new_width, new_height);
    ((UI_Label&) (*this)[ID_LABEL3]).Title() =
        "My client area size is " + CL_String (_shape.Width ())
        + " x " + CL_String (_shape.Height ()) + ".";
    UI_Rectangle r = Area ();
    ((UI_Label&) (*this)[ID_LABEL4]).Title() =
        "My window area size is " + CL_String (r.Width ())
        + " x " + CL_String (r.Height ()) + ".";
    return TRUE;
}


bool MyComposite::ViewMove (const UI_Point& p)
{
    UI_CompositeVObject::ViewMove (p);
    ((UI_Label&) (*this)[ID_LABEL2]).Title() =
        "My client area is at position " + CL_String (_shape.TopLeftX())
        + " x " + CL_String (_shape.TopLeftY()) + ".";
    return TRUE;
}


bool MyComposite::HandleChildEvent (UI_Event* e)
{
    if (e->Origin()->ViewID() != ID_BUTTON || e->Type() != Event_Select)
        return ProcessEvent (e);

    UI_Rectangle screen_rect = _Application->ScreenRect();
    UI_Rectangle& client_area = ClientArea();
    long x = client_area.Origin().XCoord();
    long y = client_area.Origin().YCoord();
    if (x >= screen_rect.Width() - client_area.Width() || x < 0)
        _xInc = -_xInc;
    if (y >= screen_rect.Height() - client_area.Height() || y <= 20)
        _yInc = -_yInc;
    client_area += UI_Point (_xInc, _yInc); // Move the window
    return TRUE;
}


// ======================== Main program ===========================


int UI_Application::Main (int /* argc */, char* []) 
{
    Controller().MakeTopWindow (new MyComposite);
    MainWindow()->Title() = "YACL ScrollBar Demo";
    Run();
    return 0;
}


