
#ifndef _label_h_
#define _label_h_





/*
 *
 *          Copyright (C) 1994, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1994. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */




#include "ui/simple.h"

  
// This is a simple object that denotes a ``static'' string label, one
// whose contents can be modified by the application but not by the user
// of the application. Its
// title and model are the same entity; 
// modifying either of them modifies the displayed string.


  
class UI_Label : public UI_SimpleVObject {

public:
    UI_Label (UI_CompositeVObject* parent, 
                const UI_Rectangle& r,UI_ViewID id=-1,long style=-1);
    // Constructor: use this object's own model. The model will be
    // destroyed when this object is destroyed.

    UI_Label (UI_CompositeVObject* parent, CL_String* model,
                const UI_Rectangle& r, UI_ViewID id=-1, long style=-1);
    // Constructor: use the given string (second parameter) as model. The
    // model string is viewed as ``borrowed'', so it
    // is not this object's responsibility to destroy the model.

    UI_Label (UI_CompositeVObject* parent, UI_ViewID id, UI_ViewHandle h);
    // Resource-based constructor (only under MS-Windows).

    virtual bool SetTextStyle (UI_TextStyle style);
    // Set the style of text in this label.

    virtual UI_TextStyle TextStyle() const;
    // Return the current text style of this label.
    
    char* MSWindowsName() const   { return "static";    };

#if defined (__X_MOTIF__)
    struct _WidgetClassRec *XName ( ) const;

#endif

    const char* ClassName() const { return "UI_Label";};

protected:

#if defined(__X_MOTIF__)
    void _SetupStyle (void*, short&);
    
#endif
    void Initialize ();
    
    bool ModelChanged (CL_Object&,long);

    ~UI_Label(){};
    // Protected destructor, to discourage delete operations.

    UI_TextStyle _textStyle;
};



#endif
