

#ifndef _graphic_h_ /* Fri Oct 28 17:18:04 1994 */
#define _graphic_h_


// Graphic is an abstract class representing a graphic object that can be
// drawn on a DrawingSurface.

#include "base/object.h"
#include "ui/point.h"

class UI_DrawingSurface;
class UI_Rectangle;

class UI_GraphicObject: public CL_Object {

public:
    virtual bool DrawOn (UI_DrawingSurface& sfc,
                         const UI_Point& p = UI_Point(0,0)) const = 0;
    // A pure virtual function: draw the graphic on the given surface,
    // translated with respect to {\tt p} (i.e., treating {\tt p} as the
    // origin).

    virtual UI_Rectangle BoundingRectangle () const = 0;
    // Return the bounding rectangle for this graphic.
    
    virtual bool ReshapeTo (const UI_Rectangle& r);
    // Grow or shrink the graphic so that its bounding box is the given
    // rectangle. Return TRUE if successful. The
    // default implementation returns FALSE unconditionally.

    virtual bool Fill   (UI_DrawingSurface& s) const;
    // Fill the interior of the graphic on the given surface with the current
    // foreground color of the given surface. This operation makes sense
    // only for closed figures. The default implementation returns FALSE.

    virtual bool OnBoundary (const UI_Point& p) const;
    // Tell whether the given point is on the boundary of this graphic. The
    // default implementation returns FALSE.

    virtual bool Includes (const UI_Point& p) const;
    // Tell whether the given point is within this graphic. The
    // default implementation returns FALSE.

    virtual bool IntersectsBoundary (const UI_Rectangle& r) const;
    // Tell whether the given rectangle intersects the boundary of this
    // GraphicObject. The default implementation uses the bounding
    // rectangle.
    

};

#endif /* _graphic_h_ */
