




/*
 *
 *          Copyright (C) 1994, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1994. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */




#include "ui/event.h"
#include "ui/rectangl.h"
#include "ui/visualob.h"

UI_Event::UI_Event(UI_EventType t, UI_VisualObject* tg,
                   UI_VisualObject* cl, void* native)
{
    _type = t;
    _origin = tg;
    if (cl == NULL)
        _dest = _origin;
    else
        _dest = cl;
    // Now assign category
    if(_type < Event_FirstSoftEvent)
        _category = Event_Hard;
    else
        _category = Event_Soft;
    _nativeEvent = native;
}

UI_Event::UI_Event(const UI_Event& e)
{
    *this = e;
}

UI_Event::~UI_Event()
{
    if (_nativeEvent)
        delete _nativeEvent;
}

void UI_Event::SetDestination(UI_VisualObject* d)
{
    _dest = d;
}

void UI_Event::operator= (const UI_Event& e)
{
    _origin = e._origin;
    _dest = e._dest;
    _type = e._type;
    _category = e._category;

    curPos = e.curPos;
    duration  = e.duration;
    key = e.key;

    _nativeEvent = new NativeEventStruct;
    if (_nativeEvent && e._nativeEvent)
        *(NativeEventStruct*) _nativeEvent = *(NativeEventStruct*)
            e._nativeEvent;
}
      

