




/*
 *
 *          Copyright (C) 1994, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1994. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */




#include "ui/dialog.h"
#include "ui/cntroler.h"
#include "ui/button.h"
#include "ui/label.h"
#include "ui/stred.h"
#include "ui/strview.h"

#if defined(__GNUC__) && __GNUC_MINOR__ >= 6
template class CL_Binding<UI_Dialog>;
#endif

class DialogEvent: public CL_Object {

    // An encapsulation of a visual-object/event-type pair
    
public:
    DialogEvent (UI_ViewID id, UI_EventType type)
    : _id (id), _type (type) {};

    bool operator == (const CL_Object& o) const
        {return (_id == ((const DialogEvent&) o)._id &&
                 _type == ((const DialogEvent&) o)._type);};

    void operator = (const CL_Object& o)
        { _id = ((const DialogEvent&) o)._id;
          _type = ((const DialogEvent&) o)._type;};

    const char* ClassName() const {return "DialogEvent";};
    
protected:
    UI_ViewID _id;
    UI_EventType     _type;
};



typedef CL_Binding<UI_Dialog> DialogBind;


// static void __CopyMapContents(CL_IntPtrMap&, CL_IntPtrMap& );

UI_Dialog::UI_Dialog
    (UI_CompositeVObject* parent, UI_ViewDescriptor* vd,
     const UI_Rectangle& shape,   UI_DialogEventDescriptor* qd,
     UI_ViewID id, long st
    )
: UI_CompositeVObject (parent, vd, FALSE, shape, id, st)
{
    if (!qd) {
        _dialogEvents.Add (new DialogEvent (UI_IDOK, Event_Select));
        _dialogEvents.Add (new DialogEvent (UI_IDCANCEL, Event_Select));
    }
    else {
        for (short i = 0; qd[i].id != -1 && qd[i].type != View_None; i++) {
            DialogEvent* d = new DialogEvent (qd[i].id, qd[i].type);
            if (!_dialogEvents.Add (d))
                delete d; // Duplicate event
        }
    }
    _Controller->DispatchPendingEvents ();
    _lastEvent.id = -1;
}




UI_Dialog::UI_Dialog(UI_CompositeVObject* parent, const char *rsrc,
                     UI_DialogEventDescriptor* qd, UI_ViewID id)
                    :UI_CompositeVObject(parent,rsrc,id)
{
    if (!qd) {
        _dialogEvents.Add (new DialogEvent (UI_IDOK, Event_Select));
        _dialogEvents.Add (new DialogEvent (UI_IDCANCEL, Event_Select));
    }
    else {
        for (short i = 0; qd[i].id != -1 && qd[i].type != View_None; i++) {
            DialogEvent* d = new DialogEvent (qd[i].id, qd[i].type);
            if (!_dialogEvents.Add (d))
                delete d; // Duplicate event
        }
    }
    _Controller->DispatchPendingEvents ();
    _lastEvent.id = -1;
}



UI_Dialog::~UI_Dialog()
{
    _dialogEvents.DestroyContents();
}



UI_DialogEventDescriptor UI_Dialog::ExecuteModal ()
{
    _lastEvent.id = -1;

#ifdef __MS_WINDOWS__
    // Gray out the "Close" in the system menu
    HMENU h = GetSystemMenu (_handle, FALSE);
    if (h)
        EnableMenuItem (h, SC_CLOSE, FALSE);
#endif

    DialogBind filterBind (this, &UI_Dialog::EventFilter);
    DialogBind finishBind (this, &UI_Dialog::RunFinished);

    while (!_Controller->EventLoop (&finishBind, &filterBind));

    //    __CopyMapContents (_objMap, map);

    return _lastEvent;
}



bool UI_Dialog::HandleChildEvent (UI_Event* e)
{
    DialogEvent t (e->Origin()->ViewID(), e->Type());
    if (_dialogEvents.Includes (&t)) {
        _lastEvent.id   = e->Origin()->ViewID();
        _lastEvent.type = e->Type();
        return TRUE;
    }
    return UI_CompositeVObject::HandleChildEvent (e);
}



// #include <iostream.h> // DEBUG
bool UI_Dialog::EventFilter (CL_Object& event, long)
{
    UI_Event* e = &(UI_Event&) event;
    UI_VisualObject* origin = e->Origin();
    UI_VisualObject* dest = e->Destination();
    bool b = (origin == this || dest == this ||
              origin->Parent() == this ||
              dest->Parent() == this); /*  ||
              e->Category() == Event_Soft); */
#if defined(__MS_WINDOWS__)
    if (!b && e->Type() == Event_LButtonRelease)
        _Controller->Beep();
#endif
//     cout << "EventFilter: event " << e->Type() << " VObj " <<
//         origin->ClassName() << " id " << origin->ViewID() << " label '" <<
//         origin->Title() << "' returns " << b << endl;
    return b;
}



bool UI_Dialog::RunFinished (CL_Object&, long)
{
    return _lastEvent.id != -1;
}

bool UI_Dialog::AddDialogEvent (UI_ViewID id, UI_EventType type)
{
    DialogEvent* d = new DialogEvent (id, type);
    if (_dialogEvents.Add (d))
        return TRUE;
    delete d;
    return FALSE;
}


bool UI_Dialog::RemoveDialogEvent (UI_ViewID id, UI_EventType type)
{
    DialogEvent d (id, type);
    DialogEvent* p = (DialogEvent*) _dialogEvents.Remove (&d);
    if (p) {
        delete p;
        return TRUE;
    }
    return FALSE;
}


