




/*
 *
 *          Copyright (C) 1994, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1994. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */





#include "base/map.h"
#include "ui/cursor.h"
#include "ui/applic.h"
#include "ui/cntroler.h"

#ifdef __MS_WINDOWS__
#include <windows.h>
#endif

extern UI_Application* _TheApplication;


#if defined (__X_MOTIF__)
#include <X11/cursorfont.h>
#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <iostream.h> // DEBUG
#endif


// We have a static map that contains handles to the built-in cursors
// here:

class CursorMap: public CL_IntIntMap {

public:
    CursorMap ();
    ~CursorMap ();
};


#if defined(__MS_WINDOWS__)
static struct CodeAssoc {
    LPSTR code;
    UI_CursorType type;
} CursorCode [] = {
    (LPSTR) IDC_ARROW,  UICursor_Arrow,
    (LPSTR) IDC_WAIT,   UICursor_Wait,
    (LPSTR) IDC_CROSS,  UICursor_CrossHairs,
    (LPSTR) IDC_IBEAM,  UICursor_IBeam
};
#endif


CursorMap::CursorMap ()
{
}

CursorMap::~CursorMap ()
{
}



static CursorMap BuiltIn;  // STATIC OBJECT!!


static UI_CursorHandle MakeCursor (UI_CursorType type)
{
#if defined(__MS_WINDOWS__)
    HCURSOR h;
    BuiltIn.Add (UICursor_Default, 0);
    if (type == UICursor_Default)
        return 0;
    short n = sizeof CursorCode / sizeof (CodeAssoc);
    for (short i = 0; i < n; i++) {
        if (CursorCode[i].type == type)
            break;
    }
    h = 0;
    if (i < n) {
        h = LoadCursor (NULL, CursorCode[i].code);
        if (h)
            BuiltIn.Add (CursorCode[i].type, h);
    }
    if (!h)
        CL_Error::Warning ("YACL: UI_Cursor Init: Invalid cursor %d",
                           type);
    return h;
#endif

#if defined(__X_MOTIF__)
    if (type == UICursor_Default)
        return 0;
    
    Cursor c;
    switch (type) {
    case UICursor_Wait:
        c = XC_watch;
        break;
        
    case UICursor_CrossHairs:
        c = XC_crosshair;
        break;
        
    case UICursor_IBeam:
        c = XC_xterm;
        break;
        
    case UICursor_Arrow:
    default:
        c = XC_top_left_arrow;
        break;
    };
        
    UI_CursorHandle h = XCreateFontCursor
        (XtDisplay (_TheApplication->Controller().ShellWidget()), c);
    if (h)
        BuiltIn.Add ((long) type, h);
    return h;
#endif
}



UI_Cursor::UI_Cursor (UI_CursorType type)
{
    _type = type;
    if (BuiltIn.IncludesKey ((long) type))
        _handle = BuiltIn[(long) type];
    else
        _handle = MakeCursor (type);
}



UI_Cursor::~UI_Cursor ()
{
#if defined (__MS_WINDOWS__)
    if (_type == UICursor_Default && _handle)
        DestroyCursor (_handle);
#endif
}


void UI_Cursor::operator= (UI_CursorType type)
{
#if defined (__MS_WINDOWS__)
    if (BuiltIn.IncludesKey ((long) type))
        _handle = BuiltIn[(long) type];
    else {
        HCURSOR h = MakeCursor (type);
        if (h) {
            _Destroy ();
            _handle = h;
            _type   = type;
        }
        else
            CL_Error::Warning ("YACL: UI_Cursor::op=: cursor type %d: "
                               "unknown type", type);
    }
#endif

#if defined(__X_MOTIF__)
    _type = type;
    if (BuiltIn.IncludesKey ((long) type))
        _handle = BuiltIn[(long) type];
    else
        _handle = MakeCursor (type);
#endif
}


// Change this cursor to be the one with the given name
void UI_Cursor::operator= (const CL_String& cursor_name)
{
#if defined (__MS_WINDOWS__)
    HCURSOR h = LoadCursor (_TheApplication->ProcessId(), cursor_name);
    if (h) {
        _Destroy();
        _handle = h;
        _name = cursor_name;
        _type = UICursor_Default;
    }
    else 
        CL_Error::Warning ("YACL: Cursor::op= (string): LoadCursor "
                           "%s failed", cursor_name.AsPtr());
#endif
#if defined (__X_MOTIF__)
    CL_Error::Warning ("Cursor::op= (string): "
                       "not yet implemented for X/Motif");
#endif
}


void UI_Cursor::_Destroy ()
{
#if defined(__MS_WINDOWS__)
    if (BuiltIn.IncludesKey (_type))
        return; // Do not destroy built-in cursors
    if (_handle)
        DestroyCursor (_handle);
    _handle = 0;
    _name = "";
    _type = UICursor_Default;
#endif
}



bool UI_Cursor::operator== (const UI_Cursor& c) const
{
    return (_type != UICursor_Default) ? (_type == c._type)
        : (_name == c._name);
}

