
#ifndef _composit_h_
#define _composit_h_





/*
 *
 *          Copyright (C) 1994, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1994. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */



// Authors:   M. A. Sridhar
//            N. Bhowmik

#include "base/intseq.h"


#include "ui/visualob.h"
#include "ui/event.h"


enum UI_ViewType {
    View_None = 0,             View_ExOrToggleButton, View_Dialog,  
    View_PushButton,           View_ToggleButton,     View_StringView,
    View_Label,                View_TextView,         View_MenuItem,
    View_Composite,            View_StringEditor,     View_OrButtonGroup,
    View_ExOrButtonGroup,      View_HScrollBar,       View_VScrollBar,       
    View_MultiSelectStringView,View_ButtonGroup
};

// The ViewDescriptor is a passive representation of a single view object.
// If this descriptor is that of a composite, then the "enclosed" field
// points to the array of children, if any. 

struct UI_ViewDescriptor {
    UI_ViewType type;
    UI_ViewID   id;       // Id must be specified
    struct {              // Shape of this view, relative to the
                          // left top corner of parent
        long    x,
                y,
                w,
                h;
    } shape;
    bool        tab_stop; // Is this view a tab stop in the parent?

    char* msg;            // NULL for those views that do not require a label
                          // during construction.
    
    UI_ViewDescriptor* enclosed; // NULL for SimpleVObjs. For composite
                                 // children, must point to an array of
                                 // ViewDescriptors, with the last one having
                                 // a -1 for id.
};


class UI_Menu;
class UI_MenuBar;

// The Composite is an object whose visual representation is a window, on
// which other visual objects can be placed. The other objects so placed
// are thought of as children of the Composite. Thus the Composite
// provides the heterogeneous composition mechanism in YACL. Typical
// applications for the Composite are modeless and modal dialogs. The
// operator[] provided by the Composite allows access to its children via
// their view ID. The Composite manages the setting of focus on its
// children when the user types the TAB (or SHIFT-TAB) key.
//
// From another viewpoint, a Composite can be thought of as essentially a
// mechanism for accessing its child VisualObjects via their ViewID's.
//
// The children of a composite may be drawn anywhere; however, only those
// that are within its client area (and have not been made invisible by
// the programmer) will be visible.
//
// A Composite can be created with an array of descriptors of its
// children. When so created, the Composite creates all of the children
// described by those descriptors. When the Composite is destroyed, these
// children are all destroyed; in fact, so is the entire subtree of the view
// tree rooted at the Composite being destroyed.
//
// A Composite may have other Composites as its children (although this
// doesn't always seem to work under MS-Windows, possibly because of a
// Windows bug.) 
//
// It is possible to associate a MenuBar with a Composite, using the
// {\small\tt UseMenuBar} method.
//
// \paragraph {Event handling.} In response to each event in the windowing
// system, the controller first sends the event to its destination (e.g.,
// when the mouse is clicked on a button, a click event is sent to the
// button) by invoking the destination's {\small\tt HandleEvent} method.
// Then, the event is sent to the each of the ancestors of the destination
// in the view tree, in order from leaf to root, via their {\small\tt
// HandleChildEvent} methods. This allows a Composite to inspect events
// that occur in its children (in fact, all its descendants) by overriding
// the {\small\tt HandleChildEvent}, and taking the necessary action.
//

class UI_CompositeVObject: public UI_VisualObject {

public:

    // ---------------------- Construction ----------------------------

    UI_CompositeVObject (UI_CompositeVObject* parent,
                         UI_ViewDescriptor* vd, bool sticky = FALSE,
                         const UI_Rectangle& shape = UI_Rectangle (),
                         UI_ViewID id = -1, long style = -1);
    // Descriptor-based construction: the second parameter points to an
    // array of ViewDescriptor structures, the last of which has type set to
    // View_None. The data structure pointer to by vd is "borrowed" for
    // reading by this composite object, and therefore may not be destroyed
    // until the composite becomes visible. (But the composite does not
    // write into the vd data structure.) The parameter "sticky" indicates
    // whether this composite "sticks" to its parent's surface, and moves
    // along with the parent; if it is FALSE, the composite appears as a
    // separate window with its own caption bar. (Composites that stick to
    // parent composites seem to behave erroneously under MS-Windows,
    // perhaps because of a Windows bug?)

    UI_CompositeVObject (UI_CompositeVObject* parent,
                         const char* resource_name, UI_ViewID id = -1);
    // Resource-based construction: currently supported only under
    // MS-Windows. This creates a non-sticky composite.

    // ------------------- View-related methods ---------------
    
    virtual bool Enable ();
    // Allow view to capture events. This overrides the inherited method;
    // the overriding code enables all descendants.

    virtual bool Disable ();
    // Prevent view from capturing events. This overrides the inherited
    // method; the overriding code disables all descendants.

    virtual void MakeInvisible ();
    // This overrides the inherited method with code that makes all
    // descendants invisible.
    
    virtual void MakeVisible ();
    // This overrides the inherited method with code that makes all
    // descendants visible.

    virtual void ShowTitleBar ();

    virtual void HideTitleBar ();

    virtual bool IsTitleBarShown ();
    
    // -------------------- Subview manipulation ---------------------
    
    virtual UI_VisualObject*  CreateChild (const UI_ViewDescriptor& vd);
    //  Create a child with given descriptor, and return a pointer to it.
    
    virtual UI_VisualObject* RemoveChild (UI_ViewID id);
    // Remove the VisualObject with given id from the composite and
    // return it. The caller must destroy the returned object via the
    // Application's Destroy method.

    virtual UI_VisualObject& operator [] (UI_ViewID id);
    // Return a reference to the child with the given ID. The return value
    // is undefined if there is no such child.
    
    virtual long ChildCount ();
    // Return the number of children of this Composite.

    // ------------------ Convenience methods ----------------------

    CL_Object* Model ();
    // The returned model is an IntPtrMap whose keys are the view id's of
    // the children, and whose values are pointers to the corresponding
    // model objects.
    
    bool Contains (UI_ViewID id);
    // Test whether the object with ID 'id' is a child of this
    // composite.

    bool CreatedViaResource () {return _rname.Size() > 0;};
    // Return TRUE if this object was created using a resource name
    // (currently supported only under MS-Windows).
    
    // --------------------- Menu methods ---------------------------
    
    bool UseMenuBar  (UI_MenuBar* menu);
    // Set up the given menu bar for use with this composite object. There is
    // no ownership relationship between the two.

    UI_MenuBar* MenuBar () const;
    // Return the menu used by this composite. Return NULL if there is no
    // associated menu.

    
    // ---------------------- Basic methods -----------------------

    char* MSWindowsName() const;

#if defined (__X_MOTIF__)
    struct _WidgetClassRec *XName () const;

#endif

    const char* ClassName() const { return "UI_CompositeVObject";};

    void Initialize();




protected:
    

    bool GetFocus ();
    // Override VisualObject's GetFocus. The default implementation sets
    // focus to the child currently in focus.

    ~UI_CompositeVObject();

    virtual bool MakeVisualElement ();
    
    // 
    // Composite method for child event inspection:
    // 

    virtual bool HandleChildEvent (UI_Event* e);
    // This is a hook for inspecting and processing any event originating
    // in any of the contained objects that are passed up to this
    // composite -- the parent. By default, it does nothing. It may thus
    // be overridden in derived class for custom event handling.

    virtual bool TabHit (UI_Event& e);
    // Set the focus to the appropriate child. Called by the controller
    // when the user types a TAB key (with any modifier keys). The default
    // implementation moves the focus to the next child in sequence (or
    // the previous child, if SHIFT-TAB was hit).

    
    bool HandleEvent (UI_Event* e);
    // Inspects to see if event originates in a child.If so, calls
    // HandleChildEvent() else calls the default method for processing events
    
    bool DestroyVisualElement ();



    void initSimple (UI_VisualObject*);


#if defined(__X_MOTIF__)
    static void DeleteWindowCallback (struct _WidgetRec* w,
                                      void *client, void *call);
    
#endif
    
public:

    // -------------- For YACL internal use only -----------------
    
    bool CreateResourceChild (UI_ViewHandle, const CL_String& name);
    //  [Internal use only] Create a child if instantiated from a resource
    //  file.

    bool SetFont (UI_Font* font);
    // [Internal use only]

    void AddChild (UI_VisualObject* child);
    // [Internal use only]
    
protected:
    // 
    // Instance Variables:
    // 

    CL_IntPtrMap       _objMap;        // Object ID to VisualObject ptr map
    CL_String          _rname;         // Resource  name
                                       // (used only under MS-Windows)
    UI_MenuBar*        _menuBar;
    bool               _stickToParent; // Do we stick to our parent's
                                       // surface?
    short              _currentChild;  // Index of current child in map
    CL_IntegerSequence _tabSequence;   // The sequence of child id's in
                                       // tabbing order

    bool               _titleBarShown; // Is the title bar currently shown?
    
private:

    bool  _ShapeRectChanged (CL_Object&, long);
    // Override VisualObject's method

    bool _TitleChanged (CL_Object&, long);
    // Override VisualObject's method
    
    friend class UI_Controller;
    friend class UI_CompositeIterator;
#ifdef __MS_WINDOWS__
    class UI_ButtonGroup* _currentGroup;
#endif

#if defined(__X_MOTIF__)
    _WidgetRec* _popup;
#endif
};



// The CompositeIterator is a means of iterating over all the children of a
// CompositeVObject. This object can only be created on a CompositeVObject
// {\it after\/} the latter is initialized and ready for display.
//
// Warning: do not add or remove children from a CompositeVObject while an
// iterator is active.

class UI_CompositeIterator {

public:
    UI_CompositeIterator (UI_CompositeVObject& v);
    // Construct an iterator on the Composite v.

    void Reset ();
    // Reset the iterator to the beginning.

    UI_VisualObject* Next ();
    // Return a pointer to the next child of our Composite. Return NULL if
    // there are no more children.

protected:

    CL_ObjectSequence _seq;
    long              _index;
};


#endif
