




/*
 *
 *          Copyright (C) 1994, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1994. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */





#include "ui/color.h"

#if defined(__MS_WINDOWS__)
#include <windows.h>

#elif defined (__X_MOTIF__)
#include <X11/Xlib.h>

#endif



UI_Color::UI_Color ()
{
    _colorVal = getColorVal (0, 0, 0);
}


UI_Color::UI_Color (UI_ColorScheme c)
{
    _colorVal  = getAbsVal (c);
}


UI_Color::UI_Color(short r, short g, short b)
{
    _red      = r;
    _green    = g;
    _blue     = b;
    _colorVal = getColorVal (_red, _green, _blue);
}



UI_Color::UI_Color (const UI_Color& c)
{
    _red      = c._red;
    _green    = c._green;
    _blue     = c._blue;
    _colorVal = c._colorVal;
}


void UI_Color::Red (ushort r)
{
    if (!PrepareToChange ())
        return;

    _red      = r;
    _colorVal = getColorVal (_red, _green, _blue);
    Notify ();
}


void UI_Color::Green (ushort g)
{
    if (!PrepareToChange())
        return;

    _green    = g;
    _colorVal = getColorVal (_red, _green, _blue);
    Notify();
}


void UI_Color::Blue (ushort b)
{
    if (!PrepareToChange())
        return;
    _blue     = b;
    _colorVal = getColorVal (_red, _green, _blue);
    Notify();
}


void UI_Color::Set (UI_ColorScheme c)
{
    if (!PrepareToChange())
        return;

    _colorVal = getAbsVal (c);
    Notify();
}


void UI_Color::operator= (const UI_Color& x)
{
    if (!PrepareToChange())
        return;

    _red       = x._red;
    _green     = x._green;
    _blue      = x._blue;
    _colorVal  = x._colorVal;
    Notify();
}


bool UI_Color::operator== (const UI_Color& o) const
{
#if defined(__MS_WINDOWS__)
    return _colorVal == o._colorVal;

#elif defined (__X_MOTIF__)
    bool retval = (_colorVal.red   == o._colorVal.red && 
                   _colorVal.green == o._colorVal.green &&
                   _colorVal.blue  == o._colorVal.blue ? TRUE : FALSE);
    return retval;
#endif
}


UI_NativeColorRep& UI_Color::NativeForm () const
{
    return (UI_NativeColorRep &) _colorVal;
}


UI_NativeColorRep UI_Color::getColorVal (short r, short g, short b)
{
#if defined(__MS_WINDOWS__)

    return RGB (LOBYTE (r),LOBYTE (g),LOBYTE (b)); 

#elif defined(__X_MOTIF__)
    _colorVal.red   = r;
    _colorVal.green = g;
    _colorVal.blue  = b;

    return _colorVal;
#endif

}


UI_NativeColorRep UI_Color::getAbsVal(UI_ColorScheme c)
{
#if defined(__MS_WINDOWS__)

    switch(c) {

    case UIColor_Black:
        return getColorVal (0, 0, 0);

    case UIColor_Green:
        return getColorVal (0, 255, 0);

    case UIColor_Blue:
        return getColorVal (255, 0, 0);

    case UIColor_Red:
        return getColorVal (0, 0, 255);

    case UIColor_White:
        return getColorVal (255, 255, 255);

    case UIColor_MediumGray:
        return getColorVal (0x80, 0x80, 0x80);

    default:
        return getColorVal (0, 0, 0);
    }


#elif defined(__X_MOTIF__)
    switch(c) {

    case UIColor_Black:
        return getColorVal (0, 0, 0);

    case UIColor_Green:
        return getColorVal (0, 65535, 0);

    case UIColor_Blue:
        return getColorVal (65535, 0, 0);

    case UIColor_Red:
        return getColorVal (0, 0, 65535);

    case UIColor_White:
        return getColorVal (65535, 65535, 65535);

    case UIColor_MediumGray:
        return getColorVal (32767, 32767, 32767);

    default:
        return getColorVal (0, 0, 0);
    }

#endif 
}

