




/*
 *
 *          Copyright (C) 1994, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1994. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */






// ----------------------- Header file includes -----------------------



#include "ui/cntroler.h"
#include "ui/applic.h"
#include "ui/menu.h"
#include "ui/composit.h"
#include "ui/event.h"



#ifdef __BORLANDC__
#include <bwcc.h>
#endif

#if defined (__X_MOTIF__)
#include <X11/StringDefs.h>
#include <X11/Intrinsic.h>
#include <Xm/Xm.h>
#include <X11/Shell.h>
#include <iostream.h> // DEBUG

#endif

#if defined(__GNUC__) && __GNUC_MINOR__ >= 6
template class CL_Binding<UI_Controller>;
#endif


// ----------------------- Typedefs ---------------------------------

typedef CL_Binding<UI_Controller> ControllerBind;
typedef bool (UI_Controller::*ControllerMethod) (CL_Object&, long);


// ----------------------- Global and static variables -------------

extern UI_Application* _TheApplication;
char FAR _YACLWindowClassName[] = YACL_WINDOW_CLASSNAME;

#if defined(__X_MOTIF__)
static XtAppContext _XAppContext;
#endif



// ----------------------- Function prototypes ----------------------

#if defined(__MS_WINDOWS__)

void initApplicationMS (HANDLE);

#elif defined(__X_MOTIF__)

// static void beep ( Widget, XEvent*, String*, unsigned int * );
// static XtActionsRec actionsTable [] =
// {
//     {"beep", &beep}
// };
// 
// static char defaultTranslations[] =
//         "Ctrl<Key>J:    beep() \n\
//          Ctrl<Key>O:    beep() \n\
//          Ctrl<Key>M:    beep() \n\
//          <Key> RETURN:    beep()"; 
// #define FONTHEIGHT(f) ((f)->max_bounds.ascent + \
//                        (f)->max_bounds.descent) 
// static char _defaultTranslations[] =
//     "<Btn1Down>(2+): lButtonDouble() \n\
//      <Btn1Down>(2+): mButtonDouble() \n\
//      <Btn1Down>(2+): rButtonDouble()";
// 
// static XtActionsRec actionsTable [] =
// {
//     {"lButtonDouble", UI_Controller::LButtonDouble}
//   , {"mButtonDouble", UI_Controller::MButtonDouble}
//   , {"rButtonDouble", UI_Controller::RButtonDouble}
// };

#endif




//
//----------------------Constructor-----------------------
//



UI_Controller::UI_Controller (UI_Application* appl)
{
    UI_VisualObject::_Application = appl;
    _InitController();
}


void UI_Controller::_InitController ()
{
    widgetCount = 0;
    _current = NULL;
    UI_VisualObject::_Controller = this;
    _root = NULL;
    _eventQueue = new CL_ObjectSequence;
    _inWaitState = FALSE;
#if defined(__X_MOTIF__)
    _focus = NULL;
#endif
}




UI_Controller::~UI_Controller ( )
{
    if ( _root != NULL )
        Destroy ( _root );
    _eventQueue->MakeEmpty ( );
    if ( _viewTree )
        delete _viewTree;
    if ( _eventQueue )
        delete _eventQueue;

#if defined(__MS_WINDOWS__)
    UnregisterClass ( _YACLWindowClassName, hInst );
#endif
}


//
//-----------------Controller service methods----------------------------
//


//
//--------Mouse control methods
//




void UI_Controller::GiveMouseTo (const UI_VisualObject& view)
{
#if defined(__MS_WINDOWS__)
    SetCapture((HWND) view.ViewHandle ());

#elif defined(__X_MOTIF__)

#endif
}


void UI_Controller::ReleaseMouse()
{
#if defined(__MS_WINDOWS__)
    ReleaseCapture();

#elif defined(__X_MOTIF__)

#endif
}

void UI_Controller::GiveFocusTo (const UI_VisualObject& aView)
{
#if defined(__MS_WINDOWS__)
    SetFocus ((HWND) aView.ViewHandle ());
#elif defined(__X_MOTIF__)
    XtSetKeyboardFocus ((Widget) aView.ViewHandle(), None);
#endif
}



UI_VisualObject* UI_Controller::operator [] (UI_ViewHandle h) 
{
    return (UI_VisualObject *) _visualObjMap [(long) h];
}

void UI_Controller::Refresh ( )
{

#if defined(__X_MOTIF__)
    XtRealizeWidget (_shell);

#endif
}
  
//
//---------------------Initialize-----------------------------
//

#if defined(__MS_WINDOWS__)

//----------Entry point for UI under MSWINDOWS

short UI_Controller::Initialize (HANDLE hInstance,HANDLE hPrevInstance,LPSTR,
                                 short
                                )
{
    hInst = hInstance;
    hPrevInst = hPrevInstance;
    if ( !hPrevInstance )
        initApplicationMS (hInstance);
    return 1;
}

#elif defined(__X_MOTIF__)

//-------Entry Point for UI under XWINDOWS

short UI_Controller::Initialize ( int& argc, char *argv[] )
{
    CL_String title;
   
    title = (char *) argv[0];
    
    _shell = XtVaAppInitialize (&_XAppContext, _YACLWindowClassName,
                                NULL, 0, &argc, argv, NULL,
                                NULL
                               );
    Arg args [1];
    short argn = 0;

    XtSetArg (args [argn], XmNdeleteResponse, XmDO_NOTHING); argn++;
    XtSetValues (_shell, args, argn);
        // Do not destroy the shell widget in response to user
        // requests; the library will take care of it.
    // XtAppAddActions (_XAppContext, actionsTable, XtNumber (actionsTable));
}
#endif


void UI_Controller::MakeTopWindow (UI_CompositeVObject* rt)
{
    _root = rt;

    if ( (_root->Title ()).Length () == 0 ){
        CL_String title (_YACLWindowClassName);
        _root->Title ()= title;
    }

#if defined (__X_MOTIF__)
    UI_VisualObject::_shell = _shell;    

#endif
}


//
// -----------------------Controller methods-------------------
//


void UI_Controller::Register (UI_VisualObject* view,
                              UI_CompositeVObject* parent 
                             )
{
    if ( parent != NULL ) {
        CL_IntegerTreeNode* v =  _viewTree->AddChild
            ((long) view->ViewHandle (), (long) parent->ViewHandle ());
        if ( !v ) return;
        v->Content () = (long) view;
    }
    else {
        // We're creating the root of the view tree
        _root = (UI_CompositeVObject *) view;
        _viewTree = new CL_IntegerTree ((long) view->ViewHandle ());

        _viewTree->Root()->Content() = (long)_root;

        if ( (_root->Title ()).Length () == 0 ) {
            CL_String title (_YACLWindowClassName);
            _root->Title () = title;
        }
    }

    // now add visual object and window pair to the map
   
     _visualObjMap.Add ((long) view->ViewHandle (), view);
}  



bool UI_Controller::Destroy (UI_VisualObject* view)
{
    if ( view == NULL )
        return FALSE;
    if ( !(_visualObjMap.IncludesKey ((long) view->ViewHandle ())) )
        return FALSE;

    ControllerBind bnd (this, (ControllerBind::MethodPtr)
                        &(UI_Controller::DisposeNode));
    UI_ViewHandle vh = view->ViewHandle ();

    _viewTree->PostOrderWalk ((long) vh, bnd);

    if (view == UI_VisualObject::_Application->MainWindow ()) {
        delete _viewTree;
        _eventQueue->MakeEmpty ();
        _viewTree = NULL;
        _root = NULL;
    }
    else
        _viewTree->DestroySubtree ((long) vh);

    view = NULL;
    return TRUE;
}



bool UI_Controller::DisposeNode (const CL_Object& obj, long)
{
    UI_VisualObject* v;
    v = (UI_VisualObject *) ((CL_IntegerTreeNode &) obj).Content ();
    if (v == _current)
        _current = NULL;
#if defined(__X_MOTIF__)
    if (v == _focus)
        _focus = NULL;
#endif
    if (v) {
        if (v->ViewHandle())
            _visualObjMap.Remove ((long) v->ViewHandle ());
        v->Finalize ();
        if ( v->_created )
            v->DestroyVisualElement ();
        delete v;
    }
    return TRUE;
}


long UI_Controller::GetNextWidgetCount()
{
    return ++widgetCount;
}


bool UI_Controller::DispatchEvent (UI_Event* e)
{
    if (_inWaitState)
        return TRUE; // Do nothing if in wait state
    UI_VisualObject* obj = e->Destination ();
    bool b;
    if (obj) {
        b = obj->HandleEvent (e);
        if (b)
            return TRUE;
        UI_CompositeVObject* comp = (UI_CompositeVObject*) obj->Parent(); 

        while (comp && !(b = comp->HandleChildEvent (e))) 
            comp = (UI_CompositeVObject*) comp->Parent ();
    }
    return b;
}


bool UI_Controller::ProcessSoftEvent ( UI_Event* e )
{
    bool done = FALSE;
    switch (e->Type ()) {
    case Event_Quit:
        done  =  (e->Origin() == e->Destination() &&
                  e->Origin() == _root );
        Destroy (e->Destination ());
        break;

    case Event_Finalize:
        if ( e->Destination()->WantToQuit () ) {
            UI_CompositeVObject* p = e->Destination ()->Parent();
            done = ( e->Origin () == e->Destination () &&
                     e->Origin () == _root );
            Destroy (e->Destination ());
            if ( p ) {
#if defined (__MS_WINDOWS__)
                SetFocus (p->ViewHandle ());
#endif
            }
        }
        break;

    case Event_MakeInterface: {
        UI_VisualObject* origin = e->Origin ();
        if (!origin)
            break;
#if defined(__MS_WINDOWS__)

        // We don't create the interface for the child of a composite if the
        // composite was built from a resource under MS/Windows

        bool b;
        if ( !origin->Parent () ||
              origin->Parent ()->_rname.Length () == 0 ) {
            b = origin->MakeVisualElement ();
            UI_CompositeVObject* parent = origin->Parent();
            if (b) {
                Register (origin, parent);
            }
        }

#elif defined(__X_MOTIF__)
        bool b = origin->MakeVisualElement ();
        if ( b ) {
            Register (origin, origin->Parent ());
            Widget w = origin->_xwidget;
            if (w) {
                XtRealizeWidget (origin->_xwidget);
                if (origin->_visible) {
                    XtManageChild   (origin->_xwidget);
                }
                XtEventHandler p = &UI_Controller::XEventHandler;
                XtAddEventHandler (w, PointerMotionMask, FALSE, p, NULL);
                XtAddEventHandler (w, FocusChangeMask, FALSE, p, NULL);
            }
        };
#endif

#if defined(__MS_WINDOWS__)
        if (b && origin->ViewHandle () > 0)
            ShowWindow (origin->ViewHandle (), 
                        origin->_visible ? SW_SHOW : SW_HIDE
                       );
#endif
        
        origin->Initialize ();

#if defined(__MS_WINDOWS__)
        if (b && origin->ViewHandle () > 0) {
            UpdateWindow (origin->ViewHandle ());
            if (origin->_parent)
                UpdateWindow (origin->_parent->_handle);
        }
#endif
        break;
    }  // End of case Event_MakeInterface
        
    default:
        DispatchEvent (e);
        break;
    }
    return done;
}




bool UI_Controller::EventLoop (CL_AbstractBinding* termination,
                               CL_AbstractBinding* eventFilter
                              )
{
    // Process the hard events first:
    // Only process hard events after root is created and while it's alive

    while ( _root && ProcessNativeEvent (eventFilter))  ;

    if ( !_root )
        return TRUE;
    UI_Event evt (Event_None, NULL);
    if (termination && termination->Execute (evt, 0))
        return TRUE;
    
    // Now process the soft events:

    UI_Event* e = NULL;

    while ( _eventQueue->Size () > 0 ) {
        e = (UI_Event*) _eventQueue->ExtractLeftmost ();

        if ( !eventFilter || eventFilter->Execute (*e, 0) ) {
            ProcessSoftEvent (e);
        }
        if ( termination && termination->Execute (*e, 0) ) {
            // We must not forget to dispatch that last event!            
            //            _eventQueue->Insert (e);
            return TRUE;
        }
        delete e;
    }
    return FALSE;
}


bool UI_Controller::RootDestroyed ( CL_Object&, long )
{
    return _root == NULL;
}


    
void UI_Controller::Run ()
{
    // Start by cleaning up the soft events

    while ( _eventQueue->Size ( ) > 0 ) {
        UI_Event* e = ( UI_Event* ) _eventQueue->ExtractLeftmost ( );
        ProcessSoftEvent ( e );
        delete e;
    }

    ControllerBind bind ( this, &UI_Controller::RootDestroyed );
    while ( !EventLoop ( &bind, NULL ) )
        _TheApplication->IdleAction ( );
}


bool UI_Controller::_SetCurrentCursor (UI_Cursor& c)
{
#if defined (__MS_WINDOWS__)
    HCURSOR h = c.Handle();
    if (h) {
        SetCursor (h);
        return TRUE;
    }
    return FALSE;
#endif
#if defined (__X_MOTIF__)
    XSetWindowAttributes attrs;
    Display* dpy = XtDisplay (_shell);
    attrs.cursor = (c == UICursor_Default) ? None : c.Handle();
    XChangeWindowAttributes(dpy, XtWindow(_shell), CWCursor, &attrs);
    XFlush(dpy);
    return TRUE;
#endif
}


void UI_Controller::BeginWait ()
{
    DispatchPendingEvents ();
    _inWaitState = TRUE;
    _defaultCursor = UICursor_Wait;
    _SetCurrentCursor (_defaultCursor);
}


void UI_Controller::EndWait ()
{
    _inWaitState = FALSE;
    _defaultCursor = UICursor_Arrow;
    _SetCurrentCursor (_defaultCursor);

    // Now flush the event queue:
    _eventQueue->DestroyContents(); 
#if defined(__MS_WINDOWS__)
    MSG msg;
    while ( PeekMessage (&msg, NULL, 0, 0, PM_REMOVE) ); 
#elif defined(__X_MOTIF__)
    XEvent           xevent;
    while ( XtAppPending (_XAppContext) != 0 )
        XtAppNextEvent  (_XAppContext, &xevent);
#endif
}


        

void UI_Controller::DispatchPendingEvents ()
{
    EventLoop ();
#if defined(__X_MOTIF__)
    XmUpdateDisplay (_shell);
#endif
}



void UI_Controller::AddEvent(UI_Event* anEvent)
{
    _eventQueue->Add ( anEvent );
}


UI_Event* UI_Controller::RemoveEvent ()
{
    UI_Event *e;

    if ( _eventQueue->Size () > 0 ){
        e = ( UI_Event* ) _eventQueue->ExtractLeftmost ();
        return e;
    }
    return NULL;
}




#if defined(__MS_WINDOWS__)

static struct {
    UINT message;
    UI_EventType yaclEvent;
} TransTable [] = {
    WM_SETFOCUS,        Event_GetFocus,
    WM_KILLFOCUS,       Event_LoseFocus,
    WM_LBUTTONDOWN,     Event_LButtonPress,
    WM_LBUTTONUP,       Event_LButtonRelease,
    WM_LBUTTONDBLCLK,   Event_LButtonDblClk,
    WM_MBUTTONDOWN,     Event_MButtonPress,  
    WM_MBUTTONUP,       Event_MButtonRelease, 
    WM_MBUTTONDBLCLK,   Event_MButtonDblClk, 
    WM_RBUTTONDOWN,     Event_RButtonPress,
    WM_RBUTTONUP,       Event_RButtonRelease, 
    WM_RBUTTONDBLCLK,   Event_RButtonDblClk,
    WM_CHAR,            Event_KeyPress,
    WM_MOUSEMOVE,       Event_MouseMove,
    WM_CLOSE,           Event_Finalize,
    WM_INITMENU,        Event_GetFocus,
    WM_INITMENUPOPUP,   Event_GetFocus,
    WM_MENUSELECT,      Event_GetFocus,
    WM_MOVE,            Event_ViewMove,
    WM_SIZE,            Event_Resize,
    WM_PAINT,           Event_Paint,
    WM_COMMAND,         Event_Select,
    //    BM_SETCHECK,        Event_Select,
    WM_VSCROLL,         Event_None, // Set by special handling
    WM_HSCROLL,         Event_None, // Set by special handling
    0,                  Event_Other
};

#elif defined (__X_MOTIF__)

static struct {
    int          message  ;
    UI_EventType yaclEvent;
} TransTable [] = {
    ButtonPress    , Event_LButtonPress  ,
    ButtonRelease  , Event_LButtonRelease,
    MotionNotify   , Event_MouseMove     ,
    KeyPress       , Event_KeyPress      ,
    KeyRelease     , Event_KeyUp         ,
    EnterNotify    , Event_ViewEnter     ,
    LeaveNotify    , Event_ViewLeave     ,
    FocusIn        , Event_GetFocus      ,
    FocusOut       , Event_LoseFocus     , 
    Expose         , Event_Paint         ,
    GraphicsExpose , Event_GraphicsExpose,
    ConfigureNotify, Event_Resize        ,
    ConfigureNotify, Event_ViewMove      ,
    0              , Event_Other         
};

#endif


bool UI_Controller::ProcessNativeEvent (CL_AbstractBinding* eventFilter)
{
    if ( !_root )
        return TRUE;
    
#if defined(__MS_WINDOWS__)
    NativeEventStruct msg;

    if ( !PeekMessage (&msg, NULL, 0, 0, PM_REMOVE) )
        return FALSE;
    TranslateMessage (&msg);
    UI_Event e (Event_None, NULL);
    bool dsp =  TranslateNativeEvent (msg, e);
    
    // Now here's a major HACK to handle tabs:
    if ( msg.message != WM_CHAR || msg.wParam != '\011' )  {
        DispatchMessage (&msg);
    }
    else {
        if (CL_String (e.Origin()->MSWindowsName()).InLowerCase() !=
            "edit") {
            // A tab sent to an edit control would cause a beep, so we
            // don't dispatch it
            DispatchMessage (&msg);
        }
        UI_CompositeVObject* parent = e.Destination()->Parent();
        if (parent)
            parent->TabHit (e);
    }
    if (dsp && _visualObjMap.IncludesKey (e._origin->_handle)) {
        //       ^^^^^^^^^^^^^^^^^^^^^^^
        // This test is needed because it is possible that the
        // DispatchMessage call above generated events that destroyed
        // e._origin.
        if ( !eventFilter || eventFilter->Execute (e, 0) ) {
            // ! (e.Destination()->MSWindowsName() == _YACLWindowClassName &&
        // ------------------------------------^^^^---------------------
        // Note that the above is a comparison of pointers; this is why we
        // use a static char array for the window class name, rather than a
        // #define'd value.
            //   msg.message == WM_COMMAND && LOWORD (msg.lParam) == 0) &&
        // The above test is for menu selection commands; it is here
        // because Windows gives the WM_COMMAND menu select message
        // to both the TopWindowProc and the PeekMessage, which causes
        // double notification in our case.
            DispatchNativeEvent (e);
        }
    }

    return TRUE;
    
#elif defined(__X_MOTIF__)
    if ( XtAppPending (_XAppContext) != 0 ) {
        XEvent           xevent;
       
        XtAppNextEvent  (_XAppContext, &xevent);
        XtDispatchEvent (&xevent);
        UI_Event e (Event_None, 0);

        if (TranslateNativeEvent (xevent, e)) {
            if (!eventFilter || eventFilter->Execute (e, 0)) {
                DispatchNativeEvent (e);
                return FALSE;
            }
            return TRUE;
        }
     }

    return FALSE;
#endif

}


#if defined (__X_MOTIF__)
void UI_Controller::XEventHandler (Widget w, void *, XEvent* xevent,
                                          char *)
{
    if (!xevent)
        return;
    UI_Event e (Event_None, 0);

    UI_Controller& ctrl =  _TheApplication->Controller();
    if (ctrl.TranslateNativeEvent (*xevent, e)) {
       ctrl.DispatchNativeEvent (e);
    }
}

#endif

void UI_Controller::Beep ()
{
#if defined (__MS_WINDOWS__)
    MessageBeep (MB_ICONQUESTION);
	
#elif defined (__X_MOTIF__)
    XBell (XtDisplay (_current->_xwidget), 100);
	
#endif
}


bool UI_Controller::DispatchNativeEvent ( UI_Event& e )
{
    if (!_root)
        return TRUE;

#if defined (__MS_WINDOWS__)

    // Windows requires cursor setting on every mouse move, otherwise
    // it reverts to the window class cursor! (see the documentation
    // for the SetCursor call) This (setting of cursor on every move)
    // can only be avoided if we use a NULL for the window class
    // cursor; but if we do that, we'll not able to set our mouse
    // cursor when the mouse moves out of the client area and back in,
    // because we have no way of knowing when the mouse has moved out
    // of the client area. There's also the problem that cursor shape
    // changes on click. 

    UINT message = ((MSG*) e._nativeEvent)->message;
    if (message == WM_SETCURSOR || message == WM_MOUSEMOVE) {
        bool b = TRUE;
        if (_inWaitState)
            _SetCurrentCursor (_defaultCursor);
        else {
            POINT p;
            GetCursorPos (&p);
            if (e.Destination()->_shape.Includes (UI_Point (p.x, p.y)))
                b = _SetCurrentCursor (e.Destination()->Cursor());
        }
        if (message == WM_SETCURSOR)
            return b;
    }


#endif

    bool ret_val = TRUE;
    switch (e.Type ()) {
    case Event_Finalize: {
        UI_VisualObject* v = e.Destination ();
        if (v && v->WantToQuit () ) {
            Destroy (e.Destination());
            ret_val = FALSE;
        }
        else
            ret_val = TRUE;
        break;
    }

    case Event_MouseMove:
#ifdef __MS_WINDOWS__
        if ( _current != e.Destination () ) {
            // The mouse entered a different visual obj
            if ( _current ) {
                UI_Event leave (Event_ViewLeave, _current);
                DispatchEvent (&leave);
            }
            _current = e.Destination ();
            UI_Event enter (Event_ViewEnter, e.Destination ());
            ret_val = DispatchEvent (&enter);
        }
#endif
        ret_val = DispatchEvent (&e);
        break;

#if defined(__X_MOTIF__)
    case Event_ViewEnter:
        if (!_inWaitState)
            _SetCurrentCursor (e.Destination()->Cursor());
        // Fall through to the default case....
#endif
        
    default:
        ret_val = DispatchEvent (&e);
        break;
    }
    return ret_val;
}


#if defined(__MS_WINDOWS__)

bool UI_Controller::TranslateNativeEvent (NativeEventStruct& msg, UI_Event& e)
{
    e._nativeEvent = new NativeEventStruct;
    *(NativeEventStruct*)(e._nativeEvent) = msg;
    e.curPos = UI_Point (LOWORD (msg.lParam), HIWORD (msg.lParam));
    e._metaKey = (msg.lParam & (1L << 29)) ? TRUE : FALSE;
    e._shiftKey = (GetKeyState (VK_SHIFT) & 0x8000) ? TRUE : FALSE;
    e._ctrlKey  = (GetKeyState (VK_CONTROL) & 0x8000) ? TRUE : FALSE;


    UI_VisualObject* view = NULL;
    for (short i = 0; TransTable [i].message != 0; i++) {
        if (TransTable [i].message == msg.message)
            break;
    }
    e._type = TransTable[i].yaclEvent;
    switch (msg.message) {
    case WM_MOVE:
        e.curPos = UI_Point (LOWORD (msg.lParam), HIWORD (msg.lParam));
        break;

    case WM_SIZE:
        if (msg.wParam == SIZEICONIC)
            e._type = Event_Iconify;
        else if (msg.wParam == SIZEFULLSCREEN)
            e._type = Event_FullScreen;
        else
            e._type = Event_Resize;
        e.curPos = UI_Point (LOWORD (msg.lParam), HIWORD (msg.lParam));
        break;

    case WM_CHAR:
        e.key = msg.wParam;
        break;
        
    default:
        break;
    }
    UI_ViewHandle window_key;
    if (msg.message == WM_INITMENU || msg.message == WM_INITMENUPOPUP) {
        window_key = (long) msg.wParam;
        e.param = msg.wParam;
    }
    else if (msg.message == WM_VSCROLL || msg.message == WM_HSCROLL) {
        window_key = HIWORD (msg.lParam);
        e.param = LOWORD (msg.lParam);
        switch (msg.wParam) {
        case SB_BOTTOM:
            e._type = Event_ScrollToEnd;
            break;

        case SB_ENDSCROLL:
            e._type = Event_FinishScroll;
            break;

        case SB_LINEDOWN:
            e._type = Event_ScrollForwardLine;
            break;

        case SB_PAGEDOWN:
            e._type = Event_ScrollForwardPage;
            break;

        case SB_LINEUP:
            e._type = Event_ScrollBackwardLine;
            break;

        case SB_PAGEUP:
            e._type = Event_ScrollBackwardPage;
            break;

        case SB_THUMBPOSITION:
            e._type = Event_ScrollToPosition;
            break;

        case SB_THUMBTRACK:
            e._type = Event_Scroll;
            break;
        }
    }
    else
        window_key = (long) msg.hwnd;
    view = (UI_VisualObject *) _visualObjMap [window_key];
    e._origin = e._dest = view;

    // Now process the menu messages
    
    if (msg.message == WM_MENUSELECT) {
        if (LOWORD (msg.lParam) == 0xffff && HIWORD (msg.lParam) == 0) {
            // Menu closed
            e._type = Event_LoseFocus;
            e._origin = e._dest = 
                ((UI_CompositeVObject *) _visualObjMap [msg.hwnd])->_menuBar;
        }
        else {
            e._type = Event_GetFocus;
            e._origin = e._dest = 
                ((UI_CompositeVObject*) _visualObjMap [msg.hwnd])->_menuBar;
            e.param = msg.wParam;
            if (msg.lParam & MF_POPUP) {
                // This is a gross hack to deal with the distinction between
                // menu items and popup menus under Windows
                e.param = -e.param;
            }
        }        
    }
    else if (msg.message == WM_COMMAND) {
        if (LOWORD (msg.lParam) == 0) {
            // Message from a menu
            e._origin = e._dest = 
                ((UI_CompositeVObject*) _visualObjMap [msg.hwnd])->_menuBar;
            e.param = msg.wParam; // Set the menu id
        }
        else {
            // Message from a control
            e._origin = e._dest = (UI_VisualObject*)
                _visualObjMap  [LOWORD (msg.lParam)];
            switch (HIWORD (msg.lParam)) {
            case LBN_SELCHANGE:
            case BN_CLICKED:
                e._type = Event_Select;
                break;

            default:
                e._type = Event_Other;
                break;
            }
            //            return FALSE; // ??
        }
    }
    return /* e._type != Event_Other  && */ e._dest != NULL;
}

#elif defined (__X_MOTIF__)

bool UI_Controller::TranslateNativeEvent (NativeEventStruct& msg, UI_Event& e)
{
    char keystring [31];
    XComposeStatus composestat;
    KeySym         keysym     ; 

    Widget           widget;
    UI_VisualObject *view = 0;
    UI_EventType     type;

    e._nativeEvent = new NativeEventStruct;
    *(NativeEventStruct*) (e._nativeEvent) = msg;

    XLookupString (&msg.xkey, keystring, 30, &keysym, &composestat);
    e.key = keysym;
 
    e.curPos = UI_Point (msg.xbutton.x, msg.xbutton.y);


    // Now set the destination of the event
    widget = XtWindowToWidget (msg.xany.display, msg.xany.window);
    if ( widget == NULL ) return FALSE;

    // Check the map for the corresponding visual object for the 
    // widget in which the event occured. Due to the way events
    // are handled in X, if the entry is not present for the widget
    // a special case needs to be handled.
    // Since X delivers events from the window manager, like 
    // resizing the main window, to the top level
    // of the application, and the top level of the application is 
    // not registered in the map, any event to the top level window
    // of the application is delivered to the the object in focus; if the
    // latter is NULL, it is delivered to the root composite object.

    view = ( UI_VisualObject* ) _visualObjMap [(long) widget];
    if (!view) {
        if (_focus)
            view = _focus;
        else if ( widget == _shell )
            view = _root;
        else
            return FALSE;
    }

    if (e._type == Event_GetFocus)
        _focus = view;
    else if (e._type == Event_LoseFocus)
        _focus = NULL;

    e._origin = e._dest = view;
    for (short i =0; TransTable[i].message != 0; i++) {
        if ( TransTable [i].message == msg.type ) {
            break;
	}
    }
    e._type = TransTable [i].yaclEvent;
    switch (TransTable [i].message) {
    case ButtonPress:
        switch (msg.xbutton.button) {
          case Button1: e._type = Event_LButtonPress; break;
          case Button2: e._type = Event_MButtonPress; break;
          case Button3: e._type = Event_RButtonPress; break;
        }
        break;
        
    case ButtonRelease:
        switch (msg.xbutton.button) {
          case Button1: e._type = Event_LButtonRelease; break;
          case Button2: e._type = Event_MButtonRelease; break;
          case Button3: e._type = Event_RButtonRelease; break;
        }
        break;

    case ConfigureNotify:
         if ( e._origin->_shape.Width  () == msg.xconfigure.width &&
              e._origin->_shape.Height () == msg.xconfigure.height
            ) {
             e.curPos = UI_Point (msg.xconfigure.x, msg.xconfigure.y);
             e._type  = Event_ViewMove;
         }
         else {
             e.curPos = UI_Point (msg.xconfigure.width, 
                                  msg.xconfigure.height
                                 );
             e._type  = Event_Resize;
             break;
         }
    }
    return TRUE;
}

#endif




#if defined (__MS_WINDOWS__)

long UI_Controller::WindowProc ( HWND hwnd, unsigned message,
                                   WORD wParam, LONG lParam)
{
    UI_Event e (Event_None, NULL);
    NativeEventStruct msg;
    msg.hwnd = hwnd;
    msg.message = message;
    msg.lParam = lParam;
    msg.wParam = wParam;
    TranslateNativeEvent (msg, e);
    bool b = FALSE;
    if (!(msg.message == WM_LBUTTONDBLCLK ||
          msg.message == WM_MBUTTONDBLCLK ||
          msg.message == WM_RBUTTONDBLCLK ||
          (msg.message == WM_COMMAND && LOWORD (msg.lParam) == 0))) {
        // We don't dispatch menu messages or double clicks from here;
        // they're dispatched from the main event loop
        b = DispatchNativeEvent (e);
    }
    if (e._type == Event_Finalize || msg.message == WM_SETCURSOR) {
        if (!b)
            return DefWindowProc (hwnd, message, wParam, lParam);
        else
            return 0;
    }
    else
        return DefWindowProc (hwnd, message, wParam, lParam);
//     if (TranslateNativeEvent (msg, e)) {
//         if (!DispatchNativeEvent (e) || e._type == Event_Paint) {
// #ifdef __BORLANDC__
// //             return (e.Origin() == _root) ?
// //                 DefWindowProc (hwnd, message, wParam, lParam) :
// //                 BWCCDefWindowProc (hwnd, message, wParam, lParam);
//             return DefWindowProc (hwnd, message, wParam, lParam);
// #else
//             return DefWindowProc (hwnd, message, wParam, lParam);
// #endif
//         }
//         else
//             return 0;
//     }
//     else {
// #ifdef __BORLANDC__
//         // return BWCCDefWindowProc (hwnd, message, wParam, lParam);
//         return DefWindowProc (hwnd, message, wParam, lParam);
// #else
//         return DefWindowProc (hwnd, message, wParam, lParam);
// #endif
//     }
}



long UI_Controller::DialogProc (HWND hwnd, unsigned message,
                                WORD wParam, LONG lParam)
{
    UI_Event e (Event_None, NULL);
    NativeEventStruct msg;
    msg.hwnd = hwnd;
    msg.message = message;
    msg.lParam = lParam;
    msg.wParam = wParam;
    TranslateNativeEvent (msg, e);
    if (!(msg.message == WM_LBUTTONDBLCLK ||
          msg.message == WM_MBUTTONDBLCLK ||
          msg.message == WM_RBUTTONDBLCLK ||
          (msg.message == WM_COMMAND && LOWORD (msg.lParam) == 0))) {
        // We don't dispatch menu messages or double clicks from here;
        // they're dispatched from the main event loop
        DispatchNativeEvent (e);
    }
    return 0;
}

#endif



#if defined (__MS_WINDOWS__)

// MS Windows window manager messages caught here

long FAR PASCAL _export YACLWindowProc (HWND hwnd, unsigned msg, WORD
                                        wParam, LONG lp)
{
   return _TheApplication->Controller().WindowProc (hwnd, msg, wParam, lp);
}



long FAR PASCAL _export YACLDialogProc  (HWND h, unsigned m, WORD w, LONG l)
    // (HWND, unsigned, WORD, LONG)
{
    return _TheApplication->Controller().DialogProc (h, m, w, l);
}



void initApplicationMS(HANDLE hInst)
{
    WNDCLASS wc;

    wc.style = CS_HREDRAW | CS_VREDRAW | CS_DBLCLKS;
    wc.lpfnWndProc = (WNDPROC) YACLWindowProc;
    wc.cbClsExtra = NULL;
    wc.cbWndExtra = NULL;
    wc.hInstance = hInst;
    wc.hIcon = LoadIcon (NULL, IDI_APPLICATION);
    wc.hCursor = LoadCursor (NULL, IDC_ARROW);
    wc.hbrBackground = GetStockObject (WHITE_BRUSH); // (COLOR_WINDOW + 1);
    wc.lpszMenuName = NULL;
    wc.lpszClassName =  _YACLWindowClassName;

    if ( !RegisterClass (&wc) )
        CL_Error::Warning ("UI_Controller: RegisterClass failed!");
}


#endif


#if defined(__X_MOTIF__)
// void UI_Controller::LButtonDouble
//     (Widget w, XEvent* xevt, String*, unsigned int*)
// {
//     UI_Controller* ct = UI_VisualObject::_Controller;
//     UI_VisualObject* v =  (*ct)[w];
//     if (v) {
//         UI_Event* e = new UI_Event (Event_LButtonDblClk, v, v);
//         ct->TranslateNativeEvent (*xevt, *e);
//         ct->AddEvent (e);
//     }
// }
// 
// void UI_Controller::MButtonDouble
//     (Widget w, XEvent* xevt, String*, unsigned int*)
// {
//     UI_Controller* ct = UI_VisualObject::_Controller;
//     UI_VisualObject* v =  (*ct)[w];
//     if (v) {
//         UI_Event* e = new UI_Event (Event_MButtonDblClk, v, v);
//         ct->TranslateNativeEvent (*xevt, *e);
//         ct->AddEvent (e);
//     }
// }
// 
// void UI_Controller::RButtonDouble
//     (Widget w, XEvent* xevt, String*, unsigned int*)
// {
//     UI_Controller* ct = UI_VisualObject::_Controller;
//     UI_VisualObject* v =  (*ct)[w];
//     if (v) {
//         UI_Event* e = new UI_Event (Event_MButtonDblClk, v, v);
//         ct->TranslateNativeEvent (*xevt, *e);
//         ct->AddEvent (e);
//     }
// }


// RegisterTimeOut: register a timeout function with Xt. The return value is
// a handle to the registered function.
ulong UI_Controller::RegisterTimeOut
    (long msec, void (*function) (void*, ulong*), void* client_data)
{
    if (function && msec > 0) // Guard against errors
        return XtAppAddTimeOut (_XAppContext, msec, (XtTimerCallbackProc)
                                function, client_data);
    else
        return 0;
}

void UI_Controller::UnregisterTimeOut (ulong handle)
{
    XtRemoveTimeOut (handle);
}

#endif
