

#include "ui/ui.h"

#include "canvas.h"
#include "app.h"

Canvas::Canvas (UI_CompositeVObject* parent, UI_Rectangle shape)
: UI_CompositeVObject (parent, NULL, TRUE, shape)
{
    _inDrag = FALSE;
}


void Canvas::Initialize ()
{
    UI_CompositeVObject::Initialize();
}

void Canvas::Finalize ()
{
    UI_CompositeVObject::Finalize();
}


bool Canvas::ButtonDown (const UI_Point& p, UI_MouseButton m, bool, bool)
{
    if (m != UIM_Left || _mode != Mode_Create)
        return FALSE;
    ObjectStore& store = ((GraphicEditorApp*) _Application)->ObjStore();
    ObjectId id = store.Add (_shape, _origin);
    _currentObj = store.ObjectWithId (id);
    if (!_currentObj)
        return FALSE;
    _inDrag = TRUE;
    CreateDisplaySurface ();
    _Controller->GiveMouseTo (*this);
    _startPt = p;
    _displaySurface->Pen().Pattern (UIPen_DashDot);
    _displaySurface->Mode (UI_DisplaySurface::GMode_Xor);
    _origin = _startPt;
    return TRUE;
}


bool Canvas::MouseMove (const UI_Point& p)
{
    if (!_inDrag)
        return TRUE;
    if (_mode != Mode_Create || !_currentObj)
        return FALSE;
    long wd = p.XCoord() - _startPt.XCoord();
    long ht = p.YCoord() - _startPt.YCoord();
    _origin = _startPt;
    _currentObj->DrawOn (*_displaySurface);
    // Erase the old graphic
    UI_Rectangle r (_origin, wd, ht);
    switch (_shape) {
    case GR_Line:
        *(UI_LineSegment*) _currentObj = UI_LineSegment (_startPt, p);
        break;

    default:
        _currentObj->ReshapeTo (r);
        break;
    }
    _currentObj->DrawOn (*_displaySurface);
    // Draw the new graphic
    return TRUE;
}



bool Canvas::ButtonUp (const UI_Point& /* p */, UI_MouseButton m)
{
    if (m != UIM_Left || !_inDrag)
        return FALSE;
    if (! _currentObj)
        return FALSE;
    _inDrag = FALSE;
    _Controller->ReleaseMouse();
    _currentObj->DrawOn (*_displaySurface); // Erase it
    _displaySurface->Pen().Pattern (UIPen_Solid);
    _displaySurface->Mode (UI_DisplaySurface::GMode_Copy);
    _currentObj->DrawOn (*_displaySurface); // Redraw it
    _currentObj->ReshapeTo (UI_Rectangle (0, 0, 0, 0));
    DestroyDisplaySurface();
    return TRUE;
}


bool Canvas::DoubleClick (const UI_Point&, UI_MouseButton)
{
    return TRUE;
}

