

// A small calendar program using YACL
//
// M. A. Sridhar
// Dec 25, 1993

#include "ui/ui.h"


// ======================== Class MyComposite ===========================

#define ID_NEXT 10
#define ID_PREV 11

class MyComposite: public UI_CompositeVObject {

public:
    MyComposite ();

    // Override the Composite's virtual method:
    bool HandleChildEvent (UI_Event* e);

protected:
    UI_MonthCalendar* cal;
    UI_PushButton* prev, *next;

};

    
MyComposite::MyComposite()
: UI_CompositeVObject (NULL, NULL, FALSE, UI_Rectangle (50, 50, 220, 320))
{
    cal = new UI_MonthCalendar (this, -1, UI_Rectangle (0,0, 240, 230));
    UI_Font& font (cal->Font());
    font.PointSize (11);
    font.TypeFace ("Arial");
    prev = new UI_PushButton (this, UI_Rectangle (50, 250, 40, 20), ID_PREV);
    (prev->Title()) = "<";
    next = new UI_PushButton (this, UI_Rectangle (120, 250, 40, 20), ID_NEXT);
    (next->Title()) = ">";
}


bool MyComposite::HandleChildEvent (UI_Event* e)
{
    if (e->Type() == Event_Select) {
        if (e->Origin()->ViewID() == ID_NEXT)
            cal->AdvanceMonth();
        else if (e->Origin()->ViewID() == ID_PREV)
            cal->PreviousMonth();
	return TRUE;
    }
    return FALSE;
}




// ========================== Main program ==========================


int UI_Application::Main (int, char* [])
{
    Controller().MakeTopWindow (new MyComposite);
    MainWindow()->Title() = "YACL Calendar Demo";
    Run();
    return 0;
}
