



#ifndef _btngroup_h_ /* Wed Mar 30 08:49:46 1994 */
#define _btngroup_h_





/*
 *
 *          Copyright (C) 1994, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1994. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */


// Author: M. A. Sridhar





// A ButtonGroup is a SimpleVObject that has an IntegerSet as model. The
// set contains the ViewID's of those buttons in the group that are chosen
// (or checked). If the contained buttons are ToggleButtons, the model
// may possibly contain more than one id; if they are ExOrToggleButtons,
// the model will contain at most one id (it may contain none, if no
// button in the group is checked). This class does not define the notion
// of selection.


#include "base/intset.h"
#include "ui/composit.h"


class UI_ButtonGroup: public UI_CompositeVObject {

public:
    UI_ButtonGroup (UI_CompositeVObject* parent, 
                    const UI_Rectangle& shape, UI_ViewDescriptor *vd,
                    UI_ViewID id, long style = -1
                   );
    // Constructor: creates an empty ButtonGroup as a child of {\tt
    // parent}, with the given shape and view ID.

    UI_ButtonGroup (UI_CompositeVObject* parent,  UI_ViewID id,
                    UI_ViewHandle h);
    // Resource-based construction (only under MS-Windows). This assumes
    // that (1) all (and only) the buttons in the group are geometrically
    // contained within the button group box's rectangle,  (2) the
    // contained buttons occur immediately after the group box in the
    // resource file ordering, and (3) the group box has a valid id.
    // Therefore, this does not allow (in particular) for groups within groups.

    CL_Object* Model ();
    // Return our model, which is really a CL_IntegerSet.


    virtual bool Add (UI_ViewID id);
    // Add a new button id to the group. Returns TRUE if successful, FALSE
    // if there was already a button with the given id in the group, or on
    // memory allocation failure.

    virtual bool Remove (UI_ViewID id);
    // Remove a button from the group. Returns TRUE if successful, FALSE
    // if either no such button was in the group, or memory allocation failed.

    UI_VisualObject& operator[] (UI_ViewID id);
    // Override the inherited method.
    
    char* MSWindowsName () const;
    // Override method inherited from {\small\tt UI_VisualObject}.

#if defined (__X_MOTIF__)
    struct _WidgetClassRec* XName ( ) const;
    // [X-Windows-specific method] Return the class name of this widget. 

#endif

    const char* ClassName () const {return "UI_ButtonGroup";};
    // Override method inherited from {\small\tt CL_Object}.
    
protected:
    ~UI_ButtonGroup ();
    // Protected, to discourage direct destruction. (All YACL
    // VisualObjects are destroyed by the Controller, and must not be
    // deleted by a user program.)

    bool MakeVisualElement ();

    void MakeInvisible ();
    // Override the inherited virtual method.
    
    void MakeVisible ();
    // Override the inherited virtual method.
    
    void Initialize ();
    
    bool Paint ();
    // Under MS-Windows, this method repaints the client area of the
    // ButtonGroup. Not sure why Windows doesn't take care of this.

    void Finalize ();
    // Under Windows, this method removes the contained buttons. This is
    // because the ButtonGroup support under Windows is a hack. Under X,
    // this method does nothing.
    
    CL_IntegerSet  _buttons; // The id's of the buttons contained in this
                             // group

#if defined(__X_MOTIF__)
private:
    UI_ViewHandle  _frameWidget; // The frame (parent of the button group)
    UI_ViewHandle  _frameLabel;  // Label of the frame
#endif

};

                     

#endif /* _btngroup_h_ */
