




/*
 *
 *          Copyright (C) 1994, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1994. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */





#include "base/string.h"

#include "ui/bitmap.h"
#include "ui/applic.h"

#if defined(__MS_WINDOWS__)
#define OEMRESOURCE
#include <windows.h>
#endif


extern UI_Application* _TheApplication;

UI_BitMap::UI_BitMap ()
{
#if defined (__MS_WINDOWS__)
    _handle = 0;
#endif
}


#ifdef __MS_WINDOWS__
static struct {
    char* name;
    long  code;
} BuiltIn [] = {
"+OBM_CLOSE"   , OBM_CLOSE   ,
"+OBM_UPARROW" , OBM_UPARROW ,
"+OBM_DNARROW" , OBM_DNARROW ,
"+OBM_RGARROW" , OBM_RGARROW ,
"+OBM_LFARROW" , OBM_LFARROW ,
"+OBM_REDUCE"  , OBM_REDUCE  ,
"+OBM_ZOOM"    , OBM_ZOOM    ,
"+OBM_RESTORE" , OBM_RESTORE ,
"+OBM_REDUCED" , OBM_REDUCED ,
"+OBM_ZOOMD"   , OBM_ZOOMD   ,
"+OBM_RESTORED", OBM_RESTORED,
"+OBM_UPARROWD", OBM_UPARROWD,
"+OBM_DNARROWD", OBM_DNARROWD,
"+OBM_RGARROWD", OBM_RGARROWD,
"+OBM_LFARROWD", OBM_LFARROWD,
"+OBM_MNARROW" , OBM_MNARROW ,
"+OBM_COMBO"   , OBM_COMBO   ,
"+OBM_UPARROWI", OBM_UPARROWI,
"+OBM_DNARROWI", OBM_DNARROWI,
0, 0
};
#endif


UI_BitMap::UI_BitMap (const char* name)
{
#if defined (__MS_WINDOWS__)
    if (name && name[0] == '+') {
        for (short i = 0; BuiltIn[i].name != 0; i++) {
            if (CL_String (name) == BuiltIn[i].name)
                break;
        }
        _handle = LoadBitmap (NULL, (LPSTR) BuiltIn[i].code);
    }
    else
        _handle = LoadBitmap (_TheApplication->ProcessId(), name);
    if (_handle) {
        BITMAP  bm;
        GetObject (_handle, sizeof (BITMAP), (LPSTR) &bm);
        _bitsPerPixel = bm.bmBitsPixel;
        _width  = bm.bmWidth;
        _height = bm.bmHeight;
    }
    else
        _bitsPerPixel = _width = _height = 0;
#endif
}




UI_BitMap::~UI_BitMap ()
{
#if defined (__MS_WINDOWS__)
    if (_handle)
        DeleteObject (_handle);
#endif
}



// UI_Color& UI_BitMap::operator[] (short i, short j)
// {
// }



bool UI_BitMap::DrawOn   (UI_DrawingSurface& s, const UI_Point& p) const
{
#if defined (__MS_WINDOWS__)
    if (!_handle)
        return FALSE;
    HDC destDC = s.Handle ();
    if (!destDC)
        return FALSE;
    HDC hDC = CreateCompatibleDC (destDC);
    if (!hDC)
        return FALSE;
    HANDLE old_h = SelectObject (hDC, _handle);
    SetMapMode (hDC, GetMapMode (destDC));

    BITMAP bm;
    POINT ptSize, ptOrg;

    GetObject (_handle, sizeof (BITMAP), (LPSTR) &bm);
    ptSize.x = bm.bmWidth;
    ptSize.y = bm.bmHeight;
    DPtoLP (destDC, &ptSize, 1);

    ptOrg.x = 0; ptOrg.y = 0;
    DPtoLP (hDC, &ptOrg, 1);
                
    BitBlt (destDC, p.XCoord(), p.YCoord(), Width(), Height(), hDC, 0, 0,
            SRCCOPY);
    SelectObject (hDC, old_h);
    DeleteDC (hDC);
    return TRUE;
#endif
}



void UI_BitMap::CopyFrom (UI_DisplaySurface& s, const UI_Rectangle& r)
{
#if defined (__MS_WINDOWS__)
    HDC srcDC = s.Handle ();
    if (!srcDC)
        return;
    HDC destDC = CreateCompatibleDC (srcDC);
    if (!destDC)
        return;
    if (_handle)
        DeleteObject (_handle);
    _handle = CreateCompatibleBitmap (srcDC, r.Width(), r.Height());
    SelectObject (destDC, _handle);
    SetMapMode (destDC, GetMapMode (srcDC));
    BitBlt (destDC, r.Left(), r.Top(), r.Width(), r.Height(), srcDC, 0, 0,
            SRCCOPY);
    DeleteDC (destDC);
#endif
}



