




/*
 *
 *          Copyright (C) 1994, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1994. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */




#if defined(__MS_WINDOWS__)
#include <windows.h>
#elif defined(__X_MOTIF__)
#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <iostream.h>
#endif

#ifdef __BORLANDC__
#include <bwcc.h>
#endif

#include "base/error.h"

#include "ui/applic.h"
#include "ui/composit.h"
#include "ui/cntroler.h"

// --------------------------- Global variables ------------------------

UI_Application* _TheApplication = NULL;
extern char* environ[];


// ----------------------------------------------------------------


static bool ErrorHandler (const char* message)
{
#if defined(__MS_WINDOWS__)
    MessageBox (NULL, message, "YACL", MB_ICONEXCLAMATION | MB_OK);

#elif defined(__X_MOTIF__)
    cerr << "YACL: " <<  message << endl;

#endif
    return TRUE;
}



UI_Application::UI_Application()
{
    CL_Error::SetWarningHandler    (ErrorHandler);
    CL_Error::SetFatalErrorHandler (ErrorHandler);

    if (_TheApplication)
        CL_Error::Fatal ("Application constructor: attempt to construct"
                         "more than one Application object!");
    _TheApplication = this;
    // Set up the environment map
    for (short i = 0; environ[i] != NULL; i++) {
        CL_String s (environ[i]);
        short j = s.CharIndex ('=');
        if (j >= 0)
            _env.Add (s(0,j), s.Suffix(j+1));
    }
}



UI_Application::~UI_Application()
{
    delete _controller;
}



#if defined(__MS_WINDOWS__)

void UI_Application::Initialize
    (HANDLE hInstance, HANDLE hPrevInstance, LPSTR lpCmdln, int nCmdShow)
{
#ifdef __BORLANDC__
    BWCCGetVersion ();
#endif
    pid = hInstance;
    _controller = new UI_Controller ( this );
    _controller->Initialize (hInstance, hPrevInstance, lpCmdln, nCmdShow);
}


#elif defined(__X_MOTIF__)
void UI_Application::Initialize (int& argc, char* argv[])
{
    _controller = new UI_Controller (this);
    _controller->Initialize (argc, argv);
}
#endif



void UI_Application::MakeTopWindow (UI_CompositeVObject* root)
{
    _controller-> MakeTopWindow (root);
}



void UI_Application::Destroy(UI_VisualObject *v)
{
    if (v !=NULL && _controller->Root() != NULL)
        _controller->AddEvent (new UI_Event (Event_Quit, v));

        // Instead of: _controller->Destroy (v);
}



bool UI_Application::ConditionalDestroy (UI_VisualObject *v)
{
    if ( v == NULL || _controller->Root () == NULL )
        return FALSE;

    if ( v->WantToQuit () ) {
        _controller->AddEvent (new UI_Event (Event_Quit, v));
        // Instead of: _controller->Destroy (v);
        return TRUE;
    }

    return FALSE;
}



void UI_Application::Run ()
{   
    if ( _controller != NULL )
        _controller->Run ();
}



void UI_Application::End ()
{
    _controller->AddEvent (new UI_Event
                           (Event_Finalize, _controller->Root ()));
}




UI_CompositeVObject* UI_Application::MainWindow () const
{
    return _controller->Root();
}


CL_String UI_Application::InstanceName (UI_VisualObject*)
{
    return CL_String (_controller->GetNextWidgetCount());
}


UI_Rectangle UI_Application::ScreenRect () const
{
#if defined(__MS_WINDOWS__)
    RECT r;
    GetClientRect (GetDesktopWindow (), &r);
    return UI_Rectangle (r.left, r.top, r.right-r.left+1,
                         r.bottom-r.top+1
                        );

#elif defined (__X_MOTIF__)
    Screen* screen;
    screen = DefaultScreenOfDisplay
        (XtDisplay ((Widget) (_controller->Root()->ViewHandle())));
    long height = HeightOfScreen (screen);
    long width  = WidthOfScreen  (screen);
    return UI_Rectangle (0, 0, width, height);
#endif
}
